/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.intr.test;

import cytoscape.util.intr.IntBTree;
import cytoscape.util.intr.IntEnumerator;
import java.io.IOException;
import java.io.InputStream;

public class IntBTreeQueryTuner {
    public static void main(String[] args) throws IOException {
        int read;
        int branches = Integer.parseInt(args[0]);
        int N = Integer.parseInt(args[1]);
        if (N < 1000) {
            throw new IllegalStateException("N should be at least 1000");
        }
        int[] elements = new int[N];
        InputStream in = System.in;
        byte[] buff = new byte[4];
        int inx = 0;
        int off = 0;
        while (inx < N && (read = in.read(buff, off, buff.length - off)) > 0) {
            if ((off += read) < buff.length) continue;
            off = 0;
            elements[inx++] = (Integer.MAX_VALUE & IntBTreeQueryTuner.assembleInt(buff)) % N;
        }
        if (inx < N) {
            throw new IOException("premature end of input");
        }
        IntBTree tree = new IntBTree(branches);
        for (int i = 0; i < elements.length; ++i) {
            tree.insert(elements[i]);
        }
        int querySpan = N / 3;
        boolean reverseOrder = false;
        long timeBegin = System.currentTimeMillis();
        for (int i = 0; i < 1000; i += 3) {
            IntEnumerator iter = tree.searchRange(i, i + querySpan, reverseOrder);
            reverseOrder = !reverseOrder;
        }
        long timeEnd = System.currentTimeMillis();
        System.out.println(timeEnd - timeBegin + " milliseconds");
    }

    private static int assembleInt(byte[] fourConsecutiveBytes) {
        int firstByte = (fourConsecutiveBytes[0] & 0xFF) << 24;
        int secondByte = (fourConsecutiveBytes[1] & 0xFF) << 16;
        int thirdByte = (fourConsecutiveBytes[2] & 0xFF) << 8;
        int fourthByte = (fourConsecutiveBytes[3] & 0xFF) << 0;
        return firstByte | secondByte | thirdByte | fourthByte;
    }
}

