/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.util.AbstractScaler;
import java.util.Arrays;
import java.util.HashMap;

class RankScaler
extends AbstractScaler {
    RankScaler() {
    }

    public double[] scale(double[] values, double a, double b) throws IllegalArgumentException {
        if (values.length < 2) {
            throw new IllegalArgumentException("need at least 2 values for scaling!");
        }
        if (a >= b) {
            throw new IllegalArgumentException("bad bounds!");
        }
        double[] sortedValues = (double[])values.clone();
        Arrays.sort(sortedValues);
        HashMap<Double, Double> origValueToRankValueMap = new HashMap<Double, Double>();
        double stepSize = (b - a) / (double)values.length;
        double currentValue = sortedValues[0];
        double sum = stepSize / 2.0;
        double count = 1.0;
        for (int i = 1; i < values.length; ++i) {
            double currentRankValue = stepSize * (0.5 + (double)i);
            if (sortedValues[i] == currentValue) {
                count += 1.0;
                sum += currentRankValue;
                continue;
            }
            origValueToRankValueMap.put(currentValue, sum / count);
            currentValue = sortedValues[i];
            sum = currentRankValue;
            count = 1.0;
        }
        origValueToRankValueMap.put(sortedValues[values.length - 1], sum / count);
        double[] scaledValues = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            scaledValues[i] = (Double)origValueToRankValueMap.get(values[i]);
        }
        return scaledValues;
    }
}

