/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.logger.CyLogger;
import cytoscape.util.MonitoredTask;
import java.awt.Component;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import javax.swing.ProgressMonitor;

public class CytoscapeProgressMonitor
extends JFrame
implements Runnable {
    public static final int ONE_SECOND = 1000;
    private ProgressMonitor pMonitor;
    private Timer timer;
    private Component parentComponent;
    private MonitoredTask monitoredTask;

    public CytoscapeProgressMonitor(MonitoredTask monitored_task) {
        this(monitored_task, (Component)null);
    }

    public CytoscapeProgressMonitor(MonitoredTask monitored_task, Component parent_component) {
        this.monitoredTask = monitored_task;
        this.parentComponent = parent_component;
    }

    public void run() {
        this.startMonitor(true);
    }

    public void startMonitor(boolean wait_for_task) {
        if (this.parentComponent != null) {
            this.parentComponent.setEnabled(false);
        }
        MonitoringThread monitoringThread = new MonitoringThread();
        this.initializeMonitor();
        monitoringThread.start();
        this.monitoredTask.go(wait_for_task);
    }

    protected void initializeMonitor() {
        String message = this.monitoredTask.getTaskName();
        this.pMonitor = new ProgressMonitor(this.parentComponent, new Object[]{message}, null, 0, this.monitoredTask.getLengthOfTask());
        CyLogger.getLogger().info("Task length: " + this.monitoredTask.getLengthOfTask());
        CyLogger.getLogger().info("About to Popup");
        this.pMonitor.setProgress(0);
        this.pMonitor.setMillisToDecideToPopup(0);
        this.pMonitor.setMillisToPopup(0);
    }

    class MonitoringThread
    extends Thread {
        MonitoringThread() {
        }

        public void run() {
            Timer mytimer = new Timer(false);
            mytimer.scheduleAtFixedRate((TimerTask)new UpdateProgressMonitor(mytimer), 0L, 1000L);
        }

        class UpdateProgressMonitor
        extends TimerTask {
            private boolean firstTick = true;
            private Timer myTimer;

            UpdateProgressMonitor(Timer timer) {
                this.myTimer = timer;
            }

            public void run() {
                if (CytoscapeProgressMonitor.this.pMonitor.isCanceled()) {
                    CytoscapeProgressMonitor.this.pMonitor.close();
                    CytoscapeProgressMonitor.this.monitoredTask.cancel();
                    this.myTimer.cancel();
                    if (CytoscapeProgressMonitor.this.parentComponent != null) {
                        CytoscapeProgressMonitor.this.parentComponent.setEnabled(true);
                    }
                } else if (CytoscapeProgressMonitor.this.monitoredTask.done()) {
                    CytoscapeProgressMonitor.this.pMonitor.close();
                    CytoscapeProgressMonitor.this.monitoredTask.stop();
                    this.myTimer.cancel();
                    if (CytoscapeProgressMonitor.this.parentComponent != null) {
                        CytoscapeProgressMonitor.this.parentComponent.setEnabled(true);
                    }
                } else {
                    CytoscapeProgressMonitor.this.pMonitor.setNote(CytoscapeProgressMonitor.this.monitoredTask.getMessage());
                    CytoscapeProgressMonitor.this.pMonitor.setProgress(CytoscapeProgressMonitor.this.monitoredTask.getCurrent());
                }
            }
        }
    }
}

