/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin;

import cytoscape.plugin.Category;
import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.DownloadableType;
import cytoscape.plugin.Installable;
import cytoscape.plugin.InstallableTheme;
import cytoscape.plugin.PluginInfo;
import cytoscape.plugin.PluginManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeInfo
extends DownloadableInfo {
    private Set<PluginInfo> themePlugins;

    public ThemeInfo() {
        this.init();
    }

    public ThemeInfo(String ID2) {
        super(ID2);
        this.init();
    }

    private void init() {
        this.setName("Unknown");
        this.setDescription("No description");
        this.setObjectVersion(0.1);
        this.setCategory(Category.THEME);
        this.themePlugins = new HashSet<PluginInfo>();
    }

    @Override
    public Installable getInstallable() {
        return new InstallableTheme(this);
    }

    @Override
    public DownloadableType getType() {
        return DownloadableType.THEME;
    }

    public void replacePlugin(PluginInfo oldPlugin, PluginInfo newPlugin) {
        this.themePlugins.remove(oldPlugin);
        this.themePlugins.add(newPlugin);
    }

    public void addPlugin(PluginInfo plugin) {
        this.themePlugins.add(plugin);
    }

    public List<PluginInfo> getPlugins() {
        return new ArrayList<PluginInfo>(this.themePlugins);
    }

    public boolean containsPlugin(PluginInfo plugin) {
        for (PluginInfo pi : this.themePlugins) {
            if (!pi.equalsDifferentObjectVersion(plugin)) continue;
            return true;
        }
        return false;
    }

    public void clearPluginList() {
        this.themePlugins.clear();
    }

    public String getInstallLocation() {
        File Dir = new File(PluginManager.getPluginManager().getPluginManageDirectory(), this.getName() + "-" + this.getObjectVersion());
        return Dir.getAbsolutePath();
    }

    @Override
    public String htmlOutput() {
        String Html = this.basicHtmlOutput();
        Html = Html + "<b>Plugins Included</b>:<br><ul>";
        for (PluginInfo i : this.getPlugins()) {
            Html = Html + "<li>" + i.toString();
        }
        Html = Html + "</ul>";
        Html = Html + "</font></body></html>";
        return Html;
    }
}

