/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin;

import cytoscape.CytoscapeVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class PluginTestXML {
    private static String testFileDir() {
        String FS = "/";
        String UserDir = System.getProperty("user.dir");
        if (System.getProperty("os.name").contains("Windows")) {
            UserDir = UserDir.replaceFirst("\\w:", "");
            UserDir = UserDir.replaceAll("\\\\", FS);
        }
        return UserDir + FS + "testData" + FS + "plugins" + FS;
    }

    private static StreamSource getXSL() throws IOException {
        String XSLFile = PluginTestXML.testFileDir() + "test_plugins.xsl";
        FileInputStream instream = new FileInputStream(XSLFile);
        if (instream == null || ((InputStream)instream).available() == 0) {
            String Msg = "";
            if (instream == null) {
                Msg = "input stream is null";
            } else if (((InputStream)instream).available() == 0) {
                Msg = "0 bytes in input stream";
            }
            IOException Error2 = new IOException("Unable to load test_plugins.xsl: " + Msg);
            throw Error2;
        }
        return new StreamSource(instream);
    }

    public static File transformXML(String FileName, String FileUrl) throws IOException {
        StreamSource xsltSource = PluginTestXML.getXSL();
        String XmlFile = PluginTestXML.testFileDir() + FileName;
        StreamSource testFile = new StreamSource(XmlFile);
        File TempTestFile = File.createTempFile("test_plugins", ".xml");
        StreamResult resultFile = new StreamResult(TempTestFile.getAbsolutePath());
        TransformerFactory transFact = TransformerFactory.newInstance();
        try {
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.setOutputProperty("method", "xml");
            trans.setOutputProperty("indent", "yes");
            trans.setParameter("cytoscapeVersion", CytoscapeVersion.version);
            trans.setParameter("fileUrl", FileUrl);
            trans.transform(testFile, resultFile);
        }
        catch (TransformerException te) {
            te.printStackTrace();
        }
        return TempTestFile;
    }
}

