/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.CytoscapeVersion;
import cytoscape.logger.CyLogger;
import cytoscape.plugin.CytoscapePlugin;
import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.DownloadableType;
import cytoscape.plugin.DuplicatePluginClassException;
import cytoscape.plugin.Installable;
import cytoscape.plugin.InstallablePlugin;
import cytoscape.plugin.JarUtil;
import cytoscape.plugin.ManagerException;
import cytoscape.plugin.ManagerUtil;
import cytoscape.plugin.PluginException;
import cytoscape.plugin.PluginFileReader;
import cytoscape.plugin.PluginInfo;
import cytoscape.plugin.PluginProperties;
import cytoscape.plugin.PluginStatus;
import cytoscape.plugin.PluginTracker;
import cytoscape.plugin.ThemeInfo;
import cytoscape.plugin.TrackerException;
import cytoscape.plugin.WebstartException;
import cytoscape.task.TaskMonitor;
import cytoscape.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jdom.JDOMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManager {
    protected PluginTracker pluginTracker;
    private boolean duplicateLoadError;
    private List<String> duplicateClasses;
    private static PluginManager pluginMgr = null;
    private static File tempDir;
    private static List<URL> pluginURLs;
    private static List<String> resourcePlugins;
    private static Set<String> loadedPlugins;
    private static Set<Throwable> loadingErrors;
    private static HashMap<String, PluginInfo> initializedPlugins;
    private static URLClassLoader classLoader;
    private static boolean usingWebstart;
    private static String cyVersion;
    private static CyLogger logger;

    public List<Throwable> getLoadingErrors() {
        if (this.pluginTracker.hasCorruptedElements()) {
            loadingErrors.add(new TrackerException("Corrupted elements removed from the Plugin Tracker.  Some plugins may need to be reinstalled."));
        }
        return new ArrayList<Throwable>(loadingErrors);
    }

    public void clearErrorList() {
        this.pluginTracker.clearCorruptedElements();
        loadingErrors.clear();
    }

    public static URLClassLoader getClassLoader() {
        return classLoader;
    }

    public static List<String> getResourcePlugins() {
        return resourcePlugins;
    }

    public static List<URL> getPluginURLs() {
        return pluginURLs;
    }

    public static boolean usingWebstartManager() {
        return usingWebstart;
    }

    protected boolean removeWebstartInstalls() {
        if (tempDir == null) {
            logger.warn("Directory not yet set up, can't delete");
            return false;
        }
        return PluginManager.recursiveDeleteFiles(tempDir.getParentFile());
    }

    public static PluginManager getPluginManager() {
        if (pluginMgr == null) {
            pluginMgr = new PluginManager(null);
        }
        return pluginMgr;
    }

    public static void setPluginManageDirectory(String loc) {
        tempDir = new File(loc);
        if (!tempDir.getAbsolutePath().contains(cyVersion)) {
            tempDir = new File(tempDir, cyVersion);
        }
    }

    public File getPluginManageDirectory() {
        return tempDir;
    }

    private static void setWebstart() {
        if (System.getProperty("javawebstart.version") != null && System.getProperty("javawebstart.version").length() > 0) {
            logger.info("USING WEBSTART: " + System.getProperty("javawebstart.version"));
            usingWebstart = true;
        } else {
            usingWebstart = false;
        }
    }

    protected static PluginManager getPluginManager(PluginTracker Tracker) {
        if (pluginMgr == null) {
            pluginMgr = new PluginManager(Tracker);
        }
        return pluginMgr;
    }

    protected void resetManager() {
        if (this.pluginTracker != null && pluginMgr != null) {
            this.pluginTracker.delete();
            this.pluginTracker = null;
            PluginManager.recursiveDeleteFiles(tempDir);
            pluginMgr = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginManager(PluginTracker Tracker) {
        loadingErrors = new HashSet<Throwable>();
        PluginManager.setWebstart();
        String trackerFileName = "track_plugins.xml";
        if (tempDir == null) {
            if (PluginManager.usingWebstartManager()) {
                tempDir = new File(CytoscapeInit.getConfigDirectory(), "webstart" + File.separator + new CytoscapeVersion().getMajorVersion() + File.separator + "plugins");
                this.removeWebstartInstalls();
                trackerFileName = "track_webstart_plugins.xml";
            } else {
                tempDir = new File(CytoscapeInit.getConfigVersionDirectory(), "plugins");
            }
        } else if (!tempDir.getAbsolutePath().endsWith("/plugins")) {
            tempDir = new File(tempDir, "plugins");
        }
        if (!tempDir.exists()) {
            logger.info("Creating directories for " + tempDir.getAbsolutePath());
            if (!tempDir.mkdirs()) {
                Cytoscape.exit(-1);
            }
        }
        if (Tracker != null) {
            this.pluginTracker = Tracker;
        } else {
            try {
                this.pluginTracker = new PluginTracker(tempDir.getParentFile(), trackerFileName);
            }
            catch (IOException ioe) {
                loadingErrors.add(ioe);
            }
            catch (TrackerException te) {
                loadingErrors.add(te);
            }
            finally {
                try {
                    this.pluginTracker = new PluginTracker(tempDir.getParentFile(), trackerFileName);
                }
                catch (Exception e) {
                    logger.warn("Unable to read plugin tracking file", e);
                }
            }
        }
        pluginURLs = new ArrayList<URL>();
        loadedPlugins = new HashSet<String>();
        initializedPlugins = new HashMap();
        resourcePlugins = new ArrayList<String>();
    }

    public List<DownloadableInfo> getDownloadables(PluginStatus Status2) {
        return this.pluginTracker.getDownloadableListByStatus(Status2);
    }

    public List<DownloadableInfo> inquire(String Url) throws IOException, JDOMException {
        List<DownloadableInfo> infoObjs = null;
        PluginFileReader Reader2 = new PluginFileReader(Url);
        infoObjs = Reader2.getDownloadables();
        return infoObjs;
    }

    protected void register(CytoscapePlugin Plugin2, JarFile Jar) {
        logger.info("Registering " + Plugin2.toString());
        DownloadableInfo InfoObj2 = ManagerUtil.getInfoObject(Plugin2.getClass());
        if (InfoObj2 != null && InfoObj2.getType().equals((Object)DownloadableType.THEME)) {
            this.registerTheme(Plugin2, Jar, (ThemeInfo)InfoObj2);
        } else {
            this.registerPlugin(Plugin2, Jar, (PluginInfo)InfoObj2, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PluginInfo registerPlugin(CytoscapePlugin Plugin2, JarFile Jar, PluginInfo PluginObj, boolean addToTracker) {
        block13: {
            logger.info("     Registering " + Plugin2.getClass().getName());
            try {
                try {
                    PluginProperties pp = new PluginProperties(Plugin2);
                    PluginObj = pp.fillPluginInfoObject(PluginObj);
                }
                catch (IOException ioe) {
                    logger.warn("ERROR registering plugin: " + ioe.getMessage(), ioe);
                    logger.warn(Plugin2.getClass().getName() + " loaded but not registered, this will not affect the operation of the plugin");
                    Object var7_9 = null;
                    if (PluginObj == null) {
                        PluginObj = new PluginInfo();
                        PluginObj.addCytoscapeVersion(cyVersion);
                        PluginObj.setName(Plugin2.getClass().getName());
                        PluginObj.setObjectVersion(0.1);
                    }
                    PluginObj.setPluginClassName(Plugin2.getClass().getName());
                    if (!usingWebstart && Jar != null) {
                        PluginObj.setInstallLocation(Jar.getName());
                        PluginObj.addFileName(Jar.getName());
                    }
                    PluginObj.setFiletype(PluginInfo.FileType.JAR);
                    initializedPlugins.put(PluginObj.getPluginClassName(), PluginObj);
                    logger.info("Track plugin: " + addToTracker);
                    if (!addToTracker) return PluginObj;
                    this.pluginTracker.addDownloadable(PluginObj, PluginStatus.CURRENT);
                    return PluginObj;
                }
                catch (Exception e) {
                    logger.warn("ERROR registering plugin: ", e);
                    Object var7_10 = null;
                    if (PluginObj == null) {
                        PluginObj = new PluginInfo();
                        PluginObj.addCytoscapeVersion(cyVersion);
                        PluginObj.setName(Plugin2.getClass().getName());
                        PluginObj.setObjectVersion(0.1);
                    }
                    PluginObj.setPluginClassName(Plugin2.getClass().getName());
                    if (!usingWebstart && Jar != null) {
                        PluginObj.setInstallLocation(Jar.getName());
                        PluginObj.addFileName(Jar.getName());
                    }
                    PluginObj.setFiletype(PluginInfo.FileType.JAR);
                    initializedPlugins.put(PluginObj.getPluginClassName(), PluginObj);
                    logger.info("Track plugin: " + addToTracker);
                    if (!addToTracker) return PluginObj;
                    this.pluginTracker.addDownloadable(PluginObj, PluginStatus.CURRENT);
                    return PluginObj;
                }
                Object var7_8 = null;
                if (PluginObj != null) break block13;
                PluginObj = new PluginInfo();
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                if (PluginObj == null) {
                    PluginObj = new PluginInfo();
                    PluginObj.addCytoscapeVersion(cyVersion);
                    PluginObj.setName(Plugin2.getClass().getName());
                    PluginObj.setObjectVersion(0.1);
                }
                PluginObj.setPluginClassName(Plugin2.getClass().getName());
                if (!usingWebstart && Jar != null) {
                    PluginObj.setInstallLocation(Jar.getName());
                    PluginObj.addFileName(Jar.getName());
                }
                PluginObj.setFiletype(PluginInfo.FileType.JAR);
                initializedPlugins.put(PluginObj.getPluginClassName(), PluginObj);
                logger.info("Track plugin: " + addToTracker);
                if (!addToTracker) throw throwable;
                this.pluginTracker.addDownloadable(PluginObj, PluginStatus.CURRENT);
                throw throwable;
            }
            PluginObj.addCytoscapeVersion(cyVersion);
            PluginObj.setName(Plugin2.getClass().getName());
            PluginObj.setObjectVersion(0.1);
        }
        PluginObj.setPluginClassName(Plugin2.getClass().getName());
        if (!usingWebstart && Jar != null) {
            PluginObj.setInstallLocation(Jar.getName());
            PluginObj.addFileName(Jar.getName());
        }
        PluginObj.setFiletype(PluginInfo.FileType.JAR);
        initializedPlugins.put(PluginObj.getPluginClassName(), PluginObj);
        logger.info("Track plugin: " + addToTracker);
        if (!addToTracker) return PluginObj;
        this.pluginTracker.addDownloadable(PluginObj, PluginStatus.CURRENT);
        return PluginObj;
    }

    private void registerTheme(CytoscapePlugin Plugin2, JarFile Jar, ThemeInfo ThemeObj) {
        logger.info("--- Registering THEME " + ThemeObj.getName());
        for (PluginInfo plugin : ThemeObj.getPlugins()) {
            if (!plugin.getPluginClassName().equals(Plugin2.getClass().getName())) continue;
            logger.info(plugin.getName());
            PluginInfo updatedPlugin = this.registerPlugin(Plugin2, Jar, plugin, false);
            ThemeObj.replacePlugin(plugin, updatedPlugin);
        }
        this.pluginTracker.addDownloadable(ThemeObj, PluginStatus.CURRENT);
    }

    private void cleanCurrentList() {
        List<DownloadableInfo> CurrentList = this.getDownloadables(PluginStatus.CURRENT);
        for (DownloadableInfo info : CurrentList) {
            PluginInfo pInfo;
            if (!info.getType().equals((Object)DownloadableType.PLUGIN) || initializedPlugins.containsKey((pInfo = (PluginInfo)info).getPluginClassName())) continue;
            this.pluginTracker.removeDownloadable(info, PluginStatus.CURRENT);
        }
    }

    public void install() {
        for (DownloadableInfo info : this.getDownloadables(PluginStatus.INSTALL)) {
            this.install(info);
        }
    }

    public void install(DownloadableInfo obj) {
        this.pluginTracker.removeDownloadable(obj, PluginStatus.INSTALL);
        this.pluginTracker.addDownloadable(obj, PluginStatus.CURRENT);
        if (PluginManager.usingWebstartManager()) {
            this.pluginTracker.addDownloadable(obj, PluginStatus.DELETE);
        }
    }

    public void delete(DownloadableInfo Obj) throws WebstartException {
        this.checkWebstart();
        this.pluginTracker.addDownloadable(Obj, PluginStatus.DELETE);
    }

    public void delete() throws ManagerException {
        List<DownloadableInfo> toDelete = this.pluginTracker.getDownloadableListByStatus(PluginStatus.DELETE);
        for (DownloadableInfo infoObj : toDelete) {
            Installable ins = infoObj.getInstallable();
            try {
                if (!ins.uninstall()) continue;
                this.pluginTracker.removeDownloadable(infoObj, PluginStatus.DELETE);
                this.pluginTracker.removeDownloadable(infoObj, PluginStatus.CURRENT);
            }
            catch (Exception me) {
                throw new ManagerException("Failed to completely delete the following installed components:\n" + infoObj.getName() + " v" + infoObj.getObjectVersion() + "\n", me);
            }
        }
    }

    protected static boolean recursiveDeleteFiles(File file) {
        boolean del;
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                PluginManager.recursiveDeleteFiles(f);
            }
        }
        if (!(del = file.delete())) {
            for (int i = 0; i < 1000 && file.exists(); ++i) {
                System.gc();
                del = file.delete();
            }
        }
        return del;
    }

    private void checkWebstart() throws WebstartException {
        if (usingWebstart) {
            throw new WebstartException();
        }
    }

    public List<DownloadableInfo> findUpdates(DownloadableInfo Info2) throws IOException, JDOMException {
        return Info2.getInstallable().findUpdates();
    }

    public void update(DownloadableInfo Current, DownloadableInfo New) throws IOException, ManagerException, WebstartException {
        this.update(Current, New, null);
    }

    public void update(DownloadableInfo currentObj, DownloadableInfo newObj, TaskMonitor taskMonitor) throws IOException, ManagerException, WebstartException {
        if (!currentObj.getType().equals((Object)newObj.getType())) {
            throw new ManagerException("Cannot update an object of one download type to an object of a different download type");
        }
        currentObj.getInstallable().update(newObj, taskMonitor);
        this.pluginTracker.addDownloadable(currentObj, PluginStatus.DELETE);
        this.pluginTracker.addDownloadable(newObj, PluginStatus.INSTALL);
    }

    public DownloadableInfo download(DownloadableInfo Obj) throws IOException, ManagerException {
        return this.download(Obj, null);
    }

    public DownloadableInfo download(DownloadableInfo Obj, TaskMonitor taskMonitor) throws IOException, ManagerException {
        ArrayList<DownloadableInfo> CurrentAndInstalled = new ArrayList<DownloadableInfo>();
        CurrentAndInstalled.addAll(this.getDownloadables(PluginStatus.CURRENT));
        CurrentAndInstalled.addAll(this.getDownloadables(PluginStatus.INSTALL));
        List<DownloadableInfo> FlattenedList = this.flattenDownloadableList(CurrentAndInstalled);
        for (DownloadableInfo currentlyInstalled : FlattenedList) {
            DownloadableInfo CurrentlyInstalled = null;
            CurrentlyInstalled = currentlyInstalled.getParent() != null ? currentlyInstalled.getParent() : currentlyInstalled;
            if (Obj.equals(currentlyInstalled) || Obj.equalsDifferentObjectVersion(currentlyInstalled)) {
                throw new ManagerException(Obj.toString() + " cannot be installed, it is already loaded in: " + CurrentlyInstalled.toString());
            }
            if (!Obj.getType().equals((Object)DownloadableType.THEME)) continue;
            for (PluginInfo themePlugin : ((ThemeInfo)Obj).getPlugins()) {
                if (!themePlugin.equalsDifferentObjectVersion(currentlyInstalled)) continue;
                throw new ManagerException(Obj.toString() + " cannot be installed a plugin contained within the theme is already present: " + CurrentlyInstalled.toString());
            }
        }
        Installable installable = Obj.getInstallable();
        installable.install(taskMonitor);
        this.pluginTracker.addDownloadable(Obj, PluginStatus.INSTALL);
        return installable.getInfoObj();
    }

    private List<DownloadableInfo> flattenDownloadableList(List<DownloadableInfo> list) {
        ArrayList<DownloadableInfo> FlattenedList = new ArrayList<DownloadableInfo>();
        for (DownloadableInfo info : list) {
            switch (info.getType()) {
                case THEME: {
                    FlattenedList.addAll(((ThemeInfo)info).getPlugins());
                }
                case PLUGIN: {
                    FlattenedList.add(info);
                }
            }
        }
        return FlattenedList;
    }

    public void loadPlugin(DownloadableInfo i) throws MalformedURLException, IOException, ClassNotFoundException, PluginException {
        switch (i.getType()) {
            case PLUGIN: {
                this.loadPlugin((PluginInfo)i);
                break;
            }
            case THEME: {
                ThemeInfo Info2 = (ThemeInfo)i;
                for (PluginInfo p : Info2.getPlugins()) {
                    this.loadPlugin(p);
                }
                break;
            }
        }
    }

    public void loadPlugin(PluginInfo p) throws ManagerException {
        ArrayList<URL> ToLoad = new ArrayList<URL>();
        for (String FileName : p.getFileList()) {
            if (!FileName.endsWith(".jar")) continue;
            try {
                ToLoad.add(PluginManager.jarURL(FileName));
            }
            catch (MalformedURLException mue) {
                loadingErrors.add(mue);
            }
        }
        InstallablePlugin insp = new InstallablePlugin(p);
        this.loadURLPlugins(ToLoad, false);
        if (this.duplicateLoadError) {
            insp.uninstall();
            this.pluginTracker.removeDownloadable(p, PluginStatus.CURRENT);
            this.addDuplicateError();
        }
    }

    public void loadPlugins(List<String> p) {
        HashSet<String> PluginsSeen = new HashSet<String>();
        for (String currentPlugin : p) {
            try {
                String[] allLines;
                if (PluginsSeen.contains(currentPlugin)) continue;
                if (currentPlugin.contains(".cytoscape")) {
                    logger.info(currentPlugin);
                }
                File f = new File(currentPlugin);
                if (currentPlugin.endsWith(".jar")) {
                    PluginsSeen.add(f.getAbsolutePath());
                    if (!currentPlugin.matches("^(jar\\:)?((http|https|ftp|file)+\\:\\/+\\S+)(\\!\\/\\S*)?$")) {
                        logger.info(" - file: " + f.getAbsolutePath());
                        pluginURLs.add(PluginManager.jarURL(f.getAbsolutePath()));
                        continue;
                    }
                    logger.info(" - url: " + f.getAbsolutePath());
                    pluginURLs.add(PluginManager.jarURL(currentPlugin));
                    continue;
                }
                if (!f.exists()) {
                    logger.info(" - classpath: " + currentPlugin);
                    resourcePlugins.add(currentPlugin);
                    continue;
                }
                if (f.isDirectory()) {
                    logger.info(" - directory: " + f.getAbsolutePath());
                    for (String fileName : f.list()) {
                        if (!fileName.endsWith(".jar")) continue;
                        PluginsSeen.add(f.getAbsolutePath() + System.getProperty("file.separator") + fileName);
                        pluginURLs.add(PluginManager.jarURL(f.getAbsolutePath() + System.getProperty("file.separator") + fileName));
                    }
                    continue;
                }
                logger.info(" - file manifest: " + f.getAbsolutePath());
                String text = FileUtil.getInputString(currentPlugin);
                for (String pluginLoc : allLines = text.split(System.getProperty("line.separator"))) {
                    if (!pluginLoc.endsWith(".jar")) continue;
                    PluginsSeen.add(pluginLoc);
                    if (pluginLoc.matches("^(jar\\:)?((http|https|ftp|file)+\\:\\/+\\S+)(\\!\\/\\S*)?$")) {
                        pluginURLs.add(PluginManager.jarURL(pluginLoc));
                        continue;
                    }
                    logger.warn("Plugin location specified in " + currentPlugin + " is not a valid url: " + pluginLoc + " -- NOT adding it.");
                    loadingErrors.add(new PluginException("Plugin location specified in " + currentPlugin + " is not a valid url: " + pluginLoc + " -- NOT adding it."));
                }
            }
            catch (Throwable t) {
                loadingErrors.add(new PluginException("problem loading plugin: " + currentPlugin, t));
            }
        }
        this.loadURLPlugins(pluginURLs, true);
        this.loadResourcePlugins(resourcePlugins);
        this.cleanCurrentList();
        if (this.duplicateLoadError) {
            this.addDuplicateError();
        }
    }

    private void addDuplicateError() {
        String Msg = "The following plugins were not loaded due to duplicate class definitions:\n";
        for (String dup : this.duplicateClasses) {
            Msg = Msg + "\t" + dup + "\n";
        }
        logger.warn(Msg);
        loadingErrors.add(new DuplicatePluginClassException(Msg));
    }

    private void loadURLPlugins(List<URL> pluginUrls, boolean register) {
        URL[] urls = new URL[pluginUrls.size()];
        pluginUrls.toArray(urls);
        this.duplicateClasses = new ArrayList<String>();
        this.duplicateLoadError = false;
        for (URL url : urls) {
            try {
                this.addClassPath(url);
            }
            catch (Throwable t) {
                loadingErrors.add(new PluginException("Classloader Error: " + url, t));
            }
        }
        classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        for (int i = 0; i < urls.length; ++i) {
            try {
                Class pc;
                logger.info("attempting to load plugin url: " + urls[i]);
                JarURLConnection jc = (JarURLConnection)urls[i].openConnection();
                jc.setUseCaches(false);
                JarFile jar = jc.getJarFile();
                if (jar == null) continue;
                String className = JarUtil.getPluginClass(jar.getName(), PluginInfo.FileType.JAR);
                if (className != null && (pc = this.getPluginClass(className)) != null) {
                    logger.info("Loading from manifest");
                    this.loadPlugin(pc, jar, register);
                    continue;
                }
                Enumeration<JarEntry> entries = jar.entries();
                if (entries == null) {
                    loadingErrors.add(new PluginException("Jar file " + jar.getName() + " has no entries, skipped loading."));
                    logger.warn("Jar file " + jar.getName() + " has no entries, skipped loading.");
                    continue;
                }
                int totalPlugins = 0;
                while (entries.hasMoreElements()) {
                    String entry = ((Object)entries.nextElement()).toString();
                    if (!entry.endsWith("class")) continue;
                    entry = entry.replaceAll("\\.class$", "");
                    Class pc2 = this.getPluginClass(entry = entry.replaceAll("/|\\\\", "."));
                    if (pc2 == null) continue;
                    ++totalPlugins;
                    this.loadPlugin(pc2, jar, register);
                    break;
                }
                if (totalPlugins != 0) continue;
                logger.info("No plugin found in specified jar - assuming it's a library.");
                continue;
            }
            catch (Throwable t) {
                loadingErrors.add(new PluginException("problem loading plugin URL: " + urls[i], t));
            }
        }
    }

    private void loadResourcePlugins(List<String> resourcePlugins) {
        for (String resource : resourcePlugins) {
            logger.info("attempting to load plugin resourse: " + resource);
            try {
                Class<?> rclass = Class.forName(resource);
                this.loadPlugin(rclass, null, true);
            }
            catch (Throwable t) {
                loadingErrors.add(new PluginException("problem loading plugin resource: " + resource, t));
            }
        }
    }

    private void loadPlugin(Class plugin, JarFile jar, boolean register) throws PluginException {
        if (CytoscapePlugin.class.isAssignableFrom(plugin) && !loadedPlugins.contains(plugin.getName())) {
            Object obj = CytoscapePlugin.loadPlugin(plugin);
            if (obj != null) {
                loadedPlugins.add(plugin.getName());
                if (register) {
                    this.register((CytoscapePlugin)obj, jar);
                }
            }
        } else if (loadedPlugins.contains(plugin.getName())) {
            this.duplicateClasses.add(plugin.getName());
            this.duplicateLoadError = true;
        }
    }

    private Class getPluginClass(String name) throws ClassNotFoundException, NoClassDefFoundError {
        Class<?> c = classLoader.loadClass(name);
        if (CytoscapePlugin.class.isAssignableFrom(c)) {
            return c;
        }
        return null;
    }

    private static URL jarURL(String urlString) throws MalformedURLException {
        String uString = urlString.matches("^(jar\\:)?((http|https|ftp|file)+\\:\\/+\\S+)(\\!\\/\\S*)?$") ? "jar:" + urlString + "!/" : "jar:file:" + urlString + "!/";
        return new URL(uString);
    }

    private void addClassPath(URL url) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)ClassLoader.getSystemClassLoader(), url);
    }

    static {
        cyVersion = new CytoscapeVersion().getMajorVersion();
        logger = CyLogger.getLogger(PluginManager.class);
    }
}

