/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.groups;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.groups.CyGroup;
import cytoscape.groups.CyGroupChangeListener;
import cytoscape.groups.CyGroupImpl;
import cytoscape.groups.CyGroupViewer;
import cytoscape.view.CyNetworkView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyGroupManager {
    private static Map<CyNode, CyGroup> groupMap = new HashMap<CyNode, CyGroup>();
    private static Map<String, CyGroupViewer> viewerMap = new HashMap<String, CyGroupViewer>();
    private static Map<CyGroupViewer, List<CyGroup>> groupViewerMap = new HashMap<CyGroupViewer, List<CyGroup>>();
    private static List<CyGroupChangeListener> changeListeners = new ArrayList<CyGroupChangeListener>();

    public static CyGroup getCyGroup(CyNode groupNode) {
        if (groupMap == null || !groupMap.containsKey(groupNode)) {
            return null;
        }
        return groupMap.get(groupNode);
    }

    public static List<CyGroup> getGroup(CyNode memberNode) {
        ArrayList<CyGroup> groupList = new ArrayList<CyGroup>();
        for (CyGroup group : groupMap.values()) {
            if (!group.contains(memberNode)) continue;
            groupList.add(group);
        }
        if (groupList.size() == 0) {
            return null;
        }
        return groupList;
    }

    public static List<CyGroup> getGroupList() {
        Collection<CyGroup> c = groupMap.values();
        return new ArrayList<CyGroup>(c);
    }

    public static List<CyGroup> getGroupList(CyGroupViewer viewer) {
        if (!groupViewerMap.containsKey(viewer)) {
            return null;
        }
        List<CyGroup> groupList = groupViewerMap.get(viewer);
        return groupList;
    }

    public static CyGroup findGroup(String groupName) {
        for (CyGroup group : CyGroupManager.getGroupList()) {
            if (group.getGroupName().equals(groupName)) {
                return group;
            }
            if (!group.getGroupNode().getIdentifier().equals(groupName)) continue;
            ((CyGroupImpl)group).setGroupName(group.getGroupNode().getIdentifier());
            return group;
        }
        return null;
    }

    public static CyGroup createGroup(String groupName, String viewer) {
        if (CyGroupManager.findGroup(groupName) != null) {
            return null;
        }
        CyGroupImpl group = new CyGroupImpl(groupName);
        groupMap.put(group.getGroupNode(), group);
        CyGroupManager.notifyListeners(group, CyGroupChangeListener.ChangeType.GROUP_CREATED);
        CyGroupManager.setGroupViewer(group, viewer, null, true);
        return group;
    }

    public static CyGroup createGroup(String groupName, List<CyNode> nodeList, String viewer) {
        if (CyGroupManager.findGroup(groupName) != null) {
            return null;
        }
        CyGroupImpl group = new CyGroupImpl(groupName, nodeList);
        groupMap.put(group.getGroupNode(), group);
        CyGroupManager.notifyListeners(group, CyGroupChangeListener.ChangeType.GROUP_CREATED);
        CyGroupManager.setGroupViewer(group, viewer, null, false);
        return group;
    }

    public static CyGroup createGroup(CyNode groupNode, List<CyNode> nodeList, String viewer) {
        if (CyGroupManager.findGroup(groupNode.getIdentifier()) != null) {
            return null;
        }
        CyGroupImpl group = null;
        group = nodeList != null ? new CyGroupImpl(groupNode, nodeList) : new CyGroupImpl(groupNode);
        groupMap.put(group.getGroupNode(), group);
        CyAttributes nodeAttributes = Cytoscape.getNodeAttributes();
        try {
            int state = nodeAttributes.getIntegerAttribute(groupNode.getIdentifier(), "__groupState");
            group.setState(state);
        }
        catch (Exception e) {
            // empty catch block
        }
        CyGroupManager.notifyListeners(group, CyGroupChangeListener.ChangeType.GROUP_CREATED);
        if (viewer != null) {
            CyGroupManager.setGroupViewer(group, viewer, null, true);
        }
        return group;
    }

    public static void removeGroup(CyGroup group) {
        CyGroupManager.removeGroup(group.getGroupNode());
    }

    public static void removeGroup(CyNode groupNode) {
        if (groupMap.containsKey(groupNode)) {
            CyGroupManager.notifyRemoveGroup(groupMap.get(groupNode));
            CyGroup group = groupMap.get(groupNode);
            String viewer = group.getViewer();
            if (viewer != null && viewerMap.containsKey(viewer)) {
                CyGroupViewer groupViewer = viewerMap.get(viewer);
                List<CyGroup> gList = groupViewerMap.get(groupViewer);
                gList.remove(group);
            }
            groupMap.remove(groupNode);
            List<CyNode> nodeList = group.getNodes();
            for (CyNode node : nodeList) {
                node.removeFromGroup(group);
            }
            CyNetwork network = Cytoscape.getCurrentNetwork();
            network.removeNode(groupNode.getRootGraphIndex(), false);
            CyGroupManager.notifyListeners(group, CyGroupChangeListener.ChangeType.GROUP_DELETED);
        }
    }

    public static boolean isaGroup(CyNode groupNode) {
        return groupMap.containsKey(groupNode);
    }

    public static void registerGroupViewer(CyGroupViewer viewer) {
        viewerMap.put(viewer.getViewerName(), viewer);
    }

    public static Collection<CyGroupViewer> getGroupViewers() {
        return viewerMap.values();
    }

    public static void setGroupViewer(CyGroup group, String viewer, CyNetworkView myView, boolean notify) {
        CyGroupViewer v;
        if (group.getViewer() != null) {
            v = viewerMap.get(group.getViewer());
            if (groupViewerMap.containsKey(v)) {
                groupViewerMap.get(v).remove(group);
                if (notify) {
                    v.groupWillBeRemoved(group);
                }
            }
            ((CyGroupImpl)group).setViewer(null);
        }
        if (viewer != null && viewerMap.containsKey(viewer)) {
            v = viewerMap.get(viewer);
            if (!groupViewerMap.containsKey(v)) {
                groupViewerMap.put(v, new ArrayList());
            }
            groupViewerMap.get(v).add(group);
            if (notify) {
                CyNetworkView currentView = Cytoscape.getCurrentNetworkView();
                if (myView != null) {
                    v.groupCreated(group, myView);
                } else if (currentView != null) {
                    v.groupCreated(group, currentView);
                }
                CyGroupManager.notifyListeners(group, CyGroupChangeListener.ChangeType.GROUP_MODIFIED);
            }
        }
        ((CyGroupImpl)group).setViewer(viewer);
    }

    public static CyGroupViewer getGroupViewer(String viewerName) {
        if (viewerName != null && viewerMap.containsKey(viewerName)) {
            return viewerMap.get(viewerName);
        }
        return null;
    }

    public static void notifyCreateGroup(CyGroup group) {
        String viewer = group.getViewer();
        if (viewer != null && viewerMap.containsKey(viewer)) {
            CyGroupViewer v = viewerMap.get(viewer);
            v.groupCreated(group);
        }
    }

    public static void notifyRemoveGroup(CyGroup group) {
        String viewer = group.getViewer();
        if (viewer != null && viewerMap.containsKey(viewer)) {
            CyGroupViewer v = viewerMap.get(viewer);
            v.groupWillBeRemoved(group);
        }
    }

    public static void addGroupChangeListener(CyGroupChangeListener listener) {
        changeListeners.add(listener);
    }

    public static void removeGroupChangeListener(CyGroupChangeListener listener) {
        changeListeners.remove(listener);
    }

    private static void notifyListeners(CyGroup group, CyGroupChangeListener.ChangeType whatChanged) {
        Iterator<CyGroupChangeListener> listeners = changeListeners.iterator();
        while (listeners.hasNext()) {
            listeners.next().groupChanged(group, whatChanged);
        }
    }
}

