/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.readers.EqnAttrTracker;
import cytoscape.logger.CyLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class CyAttributesReader {
    public static final String DECODE_PROPERTY = "cytoscape.decode.attributes";
    private static final String badDecodeMessage = "Trouble when decoding attribute value, first occurence line no. {0}\nIgnore if attributes file was created before 2.6.3 or wasn't creatad by Cytoscape.\nUse -Dcytoscape.decode.attributes=false when starting Cytoscape to turn off decoding.";
    private boolean badDecode;
    private int lineNum = 0;
    private boolean doDecoding;
    final Map<String, Map<String, Class>> idsToAttribNameToTypeMapMap;
    private final CyLogger logger = CyLogger.getLogger(CyAttributesReader.class);

    CyAttributesReader() {
        this.doDecoding = Boolean.valueOf(System.getProperty(DECODE_PROPERTY, "true"));
        this.idsToAttribNameToTypeMapMap = new HashMap<String, Map<String, Class>>();
    }

    public static void loadAttributes(CyAttributes cyAttrs, Reader fileIn) throws IOException {
        CyAttributesReader ar = new CyAttributesReader();
        ar.loadAttributesInternal(cyAttrs, fileIn);
    }

    private Class mapCytoscapeAttribTypeToEqnType(byte attribType) {
        switch (attribType) {
            case 1: {
                return Boolean.class;
            }
            case 3: {
                return Long.class;
            }
            case 2: {
                return Double.class;
            }
            case 4: {
                return String.class;
            }
            case -2: {
                return List.class;
            }
        }
        return null;
    }

    public void loadAttributesInternal(CyAttributes cyAttrs, Reader fileIn) throws IOException {
        this.badDecode = false;
        boolean guessedAttrType = false;
        try {
            String attributeName;
            BufferedReader reader = fileIn instanceof BufferedReader ? (BufferedReader)fileIn : new BufferedReader(fileIn);
            int type = -1;
            String firstLine = reader.readLine();
            ++this.lineNum;
            if (firstLine == null) {
                return;
            }
            String searchStr = "class=";
            int inx = firstLine.indexOf("class=");
            if (inx < 0) {
                attributeName = firstLine.trim();
            } else {
                attributeName = firstLine.substring(0, inx - 1).trim();
                String foo = firstLine.substring(inx);
                StringTokenizer tokens = new StringTokenizer(foo);
                String className = (foo = tokens.nextToken()).substring("class=".length()).trim();
                if (className.endsWith(")")) {
                    className = className.substring(0, className.length() - 1);
                }
                if (className.equalsIgnoreCase("java.lang.String") || className.equalsIgnoreCase("String")) {
                    type = 4;
                } else if (className.equalsIgnoreCase("java.lang.Boolean") || className.equalsIgnoreCase("Boolean")) {
                    type = 1;
                } else if (className.equalsIgnoreCase("java.lang.Integer") || className.equalsIgnoreCase("Integer")) {
                    type = 3;
                } else if (className.equalsIgnoreCase("java.lang.Double") || className.equalsIgnoreCase("Double") || className.equalsIgnoreCase("java.lang.Float") || className.equalsIgnoreCase("Float")) {
                    type = 2;
                }
            }
            if (attributeName.indexOf("(") >= 0) {
                attributeName = attributeName.substring(0, attributeName.indexOf("(")).trim();
            }
            boolean firstLine2 = true;
            boolean list = false;
            block17: while (true) {
                String line = reader.readLine();
                ++this.lineNum;
                if (line == null) break;
                if ("".equals(line.trim())) continue;
                int inx2 = line.indexOf(61);
                String key = line.substring(0, inx2).trim();
                String val = line.substring(inx2 + 1).trim();
                boolean equation = val.startsWith("=");
                key = this.decodeString(key);
                if (firstLine2 && val.startsWith("(")) {
                    list = true;
                }
                if (list) {
                    val = val.substring(1).trim();
                    val = val.substring(0, val.length() - 1).trim();
                    String[] elms = val.split("::");
                    ArrayList<Object> elmsBuff = new ArrayList<Object>();
                    for (String vs : elms) {
                        vs = this.decodeString(vs);
                        vs = CyAttributesReader.decodeSlashEscapes(vs);
                        elmsBuff.add(vs);
                    }
                    if (firstLine2) {
                        if (type < 0) {
                            guessedAttrType = true;
                            try {
                                new Integer((String)elmsBuff.get(0));
                                type = 3;
                            }
                            catch (Exception e) {
                                try {
                                    new Double((String)elmsBuff.get(0));
                                    type = 2;
                                }
                                catch (Exception e2) {
                                    type = 4;
                                }
                            }
                        }
                        firstLine2 = false;
                    }
                    for (int i = 0; i < elmsBuff.size(); ++i) {
                        if (type == 3) {
                            elmsBuff.set(i, new Integer((String)elmsBuff.get(i)));
                            continue;
                        }
                        if (type == 1) {
                            elmsBuff.set(i, new Boolean((String)elmsBuff.get(i)));
                            continue;
                        }
                        if (type != 2) continue;
                        elmsBuff.set(i, new Double((String)elmsBuff.get(i)));
                    }
                    cyAttrs.setListAttribute(key, attributeName, elmsBuff);
                    continue;
                }
                val = this.decodeString(val);
                val = CyAttributesReader.decodeSlashEscapes(val);
                if (firstLine2) {
                    if (type < 0) {
                        guessedAttrType = true;
                        try {
                            new Integer(val);
                            type = 3;
                        }
                        catch (Exception e) {
                            try {
                                new Double(val);
                                type = 2;
                            }
                            catch (Exception e3) {
                                type = 4;
                            }
                        }
                    }
                    firstLine2 = false;
                }
                if (equation) {
                    Class eqnReturnType;
                    switch (type) {
                        case 3: {
                            eqnReturnType = Long.class;
                            break;
                        }
                        case 2: {
                            eqnReturnType = Double.class;
                            break;
                        }
                        case 1: {
                            eqnReturnType = Boolean.class;
                            break;
                        }
                        case 4: {
                            eqnReturnType = String.class;
                            break;
                        }
                        case -2: {
                            eqnReturnType = List.class;
                            break;
                        }
                        default: {
                            String message = "don't know which equation return type to register on line " + this.lineNum + "!";
                            System.err.println(message);
                            this.logger.warn(message);
                            continue block17;
                        }
                    }
                    EqnAttrTracker eqnAttrTracker = Cytoscape.getEqnAttrTracker();
                    eqnAttrTracker.recordEquation(cyAttrs, key, attributeName, val, eqnReturnType);
                    continue;
                }
                if (type == 3) {
                    cyAttrs.setAttribute(key, attributeName, new Integer(val));
                    continue;
                }
                if (type == 1) {
                    cyAttrs.setAttribute(key, attributeName, new Boolean(val));
                    continue;
                }
                if (type == 2) {
                    cyAttrs.setAttribute(key, attributeName, new Double(val));
                    continue;
                }
                cyAttrs.setAttribute(key, attributeName, val);
            }
        }
        catch (Exception e) {
            String message = guessedAttrType ? "failed parsing attributes file at line: " + this.lineNum + " with exception: " + e.getMessage() + " This is most likely due to a missing attribute type on the first line.\n" + "Attribute type should be one of the following: " + "(class=String), (class=Boolean), (class=Integer), or (class=Double). " + "(\"Double\" stands for a floating point a.k.a. \"decimal\" number.)" + " This should be added to end of the first line." : "failed parsing attributes file at line: " + this.lineNum + " with exception: " + e.getMessage();
            this.logger.warn(message, e);
            throw new IOException(message);
        }
    }

    private String decodeString(String in) throws IOException {
        block3: {
            if (this.doDecoding) {
                try {
                    in = URLDecoder.decode(in, "UTF-8");
                }
                catch (IllegalArgumentException iae) {
                    if (this.badDecode) break block3;
                    this.logger.info(MessageFormat.format(badDecodeMessage, this.lineNum), iae);
                    this.badDecode = true;
                }
            }
        }
        return in;
    }

    private static String decodeSlashEscapes(String in) {
        StringBuilder elmBuff = new StringBuilder();
        for (int inx2 = 0; inx2 < in.length(); ++inx2) {
            char ch = in.charAt(inx2);
            if (ch == '\\') {
                char ch2;
                if (inx2 + 1 >= in.length()) continue;
                if ((ch2 = in.charAt(++inx2)) == 'n') {
                    elmBuff.append('\n');
                    continue;
                }
                if (ch2 == 't') {
                    elmBuff.append('\t');
                    continue;
                }
                if (ch2 == 'b') {
                    elmBuff.append('\b');
                    continue;
                }
                if (ch2 == 'r') {
                    elmBuff.append('\r');
                    continue;
                }
                if (ch2 == 'f') {
                    elmBuff.append('\f');
                    continue;
                }
                elmBuff.append(ch2);
                continue;
            }
            elmBuff.append(ch);
        }
        return elmBuff.toString();
    }

    public boolean isDoDecoding() {
        return this.doDecoding;
    }

    public void setDoDecoding(boolean doDec) {
        this.doDecoding = doDec;
    }
}

