/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.attr.util;

import cytoscape.data.attr.MultiHashMap;
import cytoscape.data.attr.MultiHashMapDefinition;
import cytoscape.data.attr.util.MultiHashMapFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class MultiHashMapTest
extends TestCase {
    MultiHashMapDefinition def;
    MultiHashMap data;
    RuntimeException exc;

    public static Test suite() {
        return new TestSuite(MultiHashMapTest.class);
    }

    public void setUp() {
        Object mm = MultiHashMapFactory.instantiateDataModel();
        this.def = (MultiHashMapDefinition)mm;
        this.data = (MultiHashMap)mm;
        this.def.defineAttribute("p-values", (byte)2, new byte[]{4, 3});
        this.data.setAttributeValue("node1", "p-values", new Double(0.5), new Object[]{"Ideker", new Integer(0)});
        this.data.setAttributeValue("node1", "p-values", new Double(0.6), new Object[]{"Ideker", new Integer(1)});
        this.data.setAttributeValue("node1", "p-values", new Double(0.6), new Object[]{"Ideker", new Integer(2)});
        this.data.setAttributeValue("node1", "p-values", new Double(0.7), new Object[]{"Salk", new Integer(0)});
        this.data.setAttributeValue("node1", "p-values", new Double(0.6), new Object[]{"Salk", new Integer(1)});
        this.data.setAttributeValue("node2", "p-values", new Double(0.4), new Object[]{"Salk", new Integer(0)});
        this.data.setAttributeValue("node2", "p-values", new Double(0.2), new Object[]{"Weirdo", new Integer(0)});
        this.data.setAttributeValue("node3", "p-values", new Double(0.1), new Object[]{"Foofoo", new Integer(11)});
        this.data.setAttributeValue("node4", "p-values", new Double(0.9), new Object[]{"BarBar", new Integer(9)});
        this.exc = null;
    }

    public void testSetAttrValue1() {
        try {
            this.data.setAttributeValue("node4", "p-values", new Double(0.4), new Object[]{"BarBar", new Long(1L)});
        }
        catch (ClassCastException e) {
            this.exc = e;
        }
        MultiHashMapTest.assertNotNull(this.exc);
    }

    public void testSetAttrValue2() {
        try {
            this.data.setAttributeValue("node5", "p-values", new Double(0.4), new Object[]{"BarBar", new Long(1L)});
        }
        catch (ClassCastException e) {
            this.exc = e;
        }
        MultiHashMapTest.assertNotNull(this.exc);
    }

    public void testDefineAttr() {
        this.def.defineAttribute("color", (byte)4, null);
        this.data.setAttributeValue("node1", "color", "red", null);
        this.data.setAttributeValue("node8", "color", "yellow", null);
        try {
            this.data.removeAttributeValue("node1", "p-values", new Object[]{"Salk", new Long(1L)});
        }
        catch (ClassCastException e) {
            this.exc = e;
        }
        MultiHashMapTest.assertNotNull(this.exc);
    }

    public void testRemoveAttr() {
        Object o = this.data.removeAttributeValue("node4", "p-values", new Object[]{"BarBar", new Integer(9)});
        MultiHashMapTest.assertEquals(new Double(0.9), (Double)o);
        this.def.defineAttribute("color", (byte)4, null);
        this.data.setAttributeValue("node4", "color", "cyan", null);
        o = this.data.removeAttributeValue("node4", "color", null);
        MultiHashMapTest.assertEquals("cyan", (String)o);
    }
}

