/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.util;

import com.sun.glf.FillRenderer;
import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.Position;
import com.sun.glf.ShapeLayer;
import com.sun.glf.util.Glyph;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

class GlyphPreview
extends JComponent {
    RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    BufferedImage buffer;
    Graphics2D g;
    boolean fixedSize;
    Glyph glyph;
    static int c = 0;

    public GlyphPreview(boolean bl) {
        this.fixedSize = bl;
        this.setPreferredSize(new Dimension(15, 15));
    }

    public void setGlyph(Glyph glyph) {
        Glyph glyph2 = this.glyph;
        this.glyph = glyph;
        if (!this.glyph.equals(glyph2)) {
            this.prepareBuffer();
        }
        this.setToolTipText("\\u" + Integer.toHexString(glyph.getChar()));
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.buffer = null;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.buffer = null;
    }

    private void prepareBuffer() {
        Shape shape;
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getPreferredSize();
        if (dimension.width <= 0) {
            dimension.width = dimension2.width;
        }
        if (dimension.height <= 0) {
            dimension.height = dimension2.height;
        }
        if (this.buffer == null || dimension.width != this.buffer.getWidth() || dimension.height != this.buffer.getHeight()) {
            this.buffer = new BufferedImage(dimension.width, dimension.height, 2);
            this.g = this.buffer.createGraphics();
        }
        this.g.setTransform(new AffineTransform());
        this.g.setComposite(AlphaComposite.Clear);
        this.g.fillRect(0, 0, dimension.width, dimension.height);
        this.g.setComposite(AlphaComposite.SrcOver);
        LayerComposition layerComposition = new LayerComposition(this.getSize());
        FillRenderer fillRenderer = new FillRenderer(this.getForeground() != null ? this.getForeground() : Color.black);
        Shape shape2 = shape = this.glyph != null ? this.glyph.getShape() : null;
        if (shape != null) {
            Object object;
            if (this.fixedSize) {
                object = shape.getBounds();
                float f = 0.0f;
                if (((Rectangle)object).width != 0) {
                    f = (float)dimension.width / (float)((Rectangle)object).width;
                }
                if (((Rectangle)object).height != 0) {
                    f = Math.min(f, (float)dimension.height / (float)((Rectangle)object).height);
                }
                if (f < 1.0f) {
                    AffineTransform affineTransform = new AffineTransform();
                    affineTransform.scale(f, f);
                    affineTransform.translate(-((Rectangle)object).width / 2, -((Rectangle)object).height / 2);
                    shape = affineTransform.createTransformedShape(shape);
                }
            }
            object = new ShapeLayer(layerComposition, shape, fillRenderer, Position.CENTER);
            ShapeLayer shapeLayer = new ShapeLayer(layerComposition, new Rectangle(0, 0, dimension.width, dimension.height), new FillRenderer(this.getBackground()));
            layerComposition.setLayers(new Layer[]{shapeLayer, object});
            layerComposition.setRenderingHints(this.rh);
            layerComposition.paint(this.g);
            this.g.setTransform(new AffineTransform());
            this.paintBorder(this.g);
        }
        this.repaint();
    }

    public Glyph getGlyph() {
        return this.glyph;
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.prepareBuffer();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.buffer == null || dimension.width != this.buffer.getWidth() || dimension.height != this.buffer.getHeight()) {
            this.prepareBuffer();
        }
        graphics.drawImage(this.buffer, 0, 0, null);
    }
}

