/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.util;

import com.sun.glf.Composition;
import com.sun.glf.PaintProgressListener;
import com.sun.glf.util.GridBagPanel;
import com.sun.glf.util.TimeProbe;
import java.util.Vector;
import javax.swing.JProgressBar;

public class CompositionPaintMonitor
extends GridBagPanel
implements PaintProgressListener {
    static final String PAINT_STARTED = "Paint started";
    static final String PAINT_FINISHED = "Paint finished";
    private JProgressBar progressBar;
    private Composition monitored;
    private Vector paintLog;
    private TimeProbe probe = new TimeProbe();
    private String stepDescription;

    public CompositionPaintMonitor() {
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.add(this.progressBar, 0, 0, 1, 1, 10, 2, 0.0, 0.0);
    }

    public void monitor(Composition composition) {
        if (this.monitored != null) {
            this.monitored.removePaintProgressListener(this);
        }
        this.monitored = composition;
        if (this.monitored != null) {
            this.monitored.addPaintProgressListener(this);
        }
        this.paintLog = new Vector();
        this.progressBar.setEnabled(false);
        this.repaint();
    }

    public void paintStarted(Composition composition, int n) {
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(n);
        this.progressBar.setEnabled(true);
        this.progressBar.invalidate();
        this.validate();
    }

    public void paintStepStarted(Composition composition, String string) {
        if (this.progressBar.getValue() > 0) {
            this.paintLog.addElement(this.probe.traceTime("" + this.progressBar.getValue() + " (" + this.stepDescription + ") : "));
        }
        this.stepDescription = string;
        this.progressBar.setValue(this.progressBar.getValue() + 1);
        this.progressBar.invalidate();
        this.validate();
        this.probe.startTiming();
    }

    public void paintFinished(Composition composition) {
        this.paintLog.addElement(this.probe.traceTime("" + this.progressBar.getValue() + " (" + this.stepDescription + " : "));
        this.progressBar.setValue(this.progressBar.getMaximum());
        this.progressBar.invalidate();
        this.validate();
        boolean bl = System.getProperty("com.sun.glf.debug", "false").equalsIgnoreCase("true");
        if (bl) {
            int n = this.paintLog.size();
            for (int i = 0; i < n; ++i) {
                System.out.println(this.paintLog.elementAt(i));
            }
            System.out.println("Paint finished...");
        }
    }
}

