/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.goodies;

import com.sun.glf.FillRenderer;
import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.Renderer;
import com.sun.glf.ShapeLayer;
import com.sun.glf.StrokeRenderer;
import com.sun.glf.goodies.RadialGradientPaintExtContext;
import com.sun.glf.util.CompositionComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class RadialGradientPaintExt
implements Paint {
    Rectangle2D.Float gradientBounds;
    int transparency;
    Color[] colors;
    float[] I;

    public Color[] getColors() {
        Color[] colorArray = new Color[this.colors.length];
        System.arraycopy(this.colors, 0, colorArray, 0, this.colors.length);
        return colorArray;
    }

    public float[] getIntervals() {
        float[] fArray = new float[this.I.length];
        System.arraycopy(this.I, 0, fArray, 0, this.I.length);
        return fArray;
    }

    public Rectangle2D getBounds() {
        return (Rectangle2D)this.gradientBounds.clone();
    }

    public RadialGradientPaintExt(Rectangle2D rectangle2D, Color[] colorArray, float[] fArray) {
        int n;
        if (rectangle2D == null) {
            throw new IllegalArgumentException();
        }
        if (colorArray == null) {
            throw new IllegalArgumentException();
        }
        if (fArray == null) {
            throw new IllegalArgumentException();
        }
        if (colorArray.length < 2) {
            throw new IllegalArgumentException();
        }
        if (colorArray.length != fArray.length + 1) {
            throw new IllegalArgumentException();
        }
        this.gradientBounds = new Rectangle2D.Float();
        this.gradientBounds.setRect((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
        this.colors = new Color[colorArray.length];
        System.arraycopy(colorArray, 0, this.colors, 0, colorArray.length);
        float[] fArray2 = new float[fArray.length];
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        fArray = fArray2;
        float f = 0.0f;
        for (n = 0; n < fArray.length; ++n) {
            if (fArray[n] <= 0.0f) {
                throw new IllegalArgumentException("Cannot use negative or null interval: " + fArray[n]);
            }
            f += fArray[n];
        }
        n = 0;
        while (n < fArray.length) {
            int n2 = n++;
            fArray[n2] = fArray[n2] / f;
        }
        this.I = fArray;
        n = 1;
        for (int i = 0; i < this.colors.length; ++i) {
            n = n != 0 && this.colors[i].getAlpha() == 255 ? 1 : 0;
        }
        this.transparency = n != 0 ? 1 : 3;
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        try {
            return new RadialGradientPaintExtContext(this.gradientBounds, this.colors, this.I, affineTransform);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new IllegalArgumentException("transform should be invertible");
        }
    }

    public int getTransparency() {
        return this.transparency;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("RadialGradientPaint unit testing");
        jFrame.getContentPane().setLayout(new GridLayout(0, 2));
        jFrame.getContentPane().setBackground(Color.white);
        Dimension dimension = new Dimension(200, 100);
        Color[] colorArray = new Color[]{Color.white, Color.yellow, new Color(128, 50, 50)};
        float[] fArray = new float[]{1.0f, 1.0f};
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.0, 0.0, 150.0, 100.0);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(0.0, 0.0, 100.0, 100.0);
        RadialGradientPaintExt radialGradientPaintExt = new RadialGradientPaintExt(double_.getBounds2D(), colorArray, fArray);
        RadialGradientPaintExt radialGradientPaintExt2 = new RadialGradientPaintExt(double_2.getBounds2D(), colorArray, fArray);
        FillRenderer fillRenderer = new FillRenderer(radialGradientPaintExt);
        FillRenderer fillRenderer2 = new FillRenderer(radialGradientPaintExt2);
        Rectangle rectangle = new Rectangle(20, 20, 160, 60);
        AffineTransform affineTransform = null;
        jFrame.getContentPane().add(RadialGradientPaintExt.makeNewComponent(dimension, rectangle, fillRenderer, affineTransform, "No transform"));
        jFrame.getContentPane().add(RadialGradientPaintExt.makeNewComponent(dimension, rectangle, fillRenderer2, affineTransform, "No transform"));
        affineTransform = AffineTransform.getTranslateInstance(40.0, 40.0);
        jFrame.getContentPane().add(RadialGradientPaintExt.makeNewComponent(dimension, rectangle, fillRenderer, affineTransform, "Translation"));
        jFrame.getContentPane().add(RadialGradientPaintExt.makeNewComponent(dimension, rectangle, fillRenderer2, affineTransform, "Translation"));
        affineTransform = AffineTransform.getScaleInstance(2.0, 2.0);
        jFrame.getContentPane().add(RadialGradientPaintExt.makeNewComponent(dimension, rectangle, fillRenderer, affineTransform, "Scale"));
        jFrame.getContentPane().add(RadialGradientPaintExt.makeNewComponent(dimension, rectangle, fillRenderer2, affineTransform, "Scale"));
        affineTransform = AffineTransform.getRotateInstance(0.7853981633974483, 100.0, 50.0);
        jFrame.getContentPane().add(RadialGradientPaintExt.makeNewComponent(dimension, rectangle, fillRenderer, affineTransform, "Rotation"));
        jFrame.getContentPane().add(RadialGradientPaintExt.makeNewComponent(dimension, rectangle, fillRenderer2, affineTransform, "Rotation"));
        affineTransform = AffineTransform.getShearInstance(0.5, 0.0);
        jFrame.getContentPane().add(RadialGradientPaintExt.makeNewComponent(dimension, rectangle, fillRenderer, affineTransform, "Shear"));
        jFrame.getContentPane().add(RadialGradientPaintExt.makeNewComponent(dimension, rectangle, fillRenderer2, affineTransform, "Shear"));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private static JComponent makeNewComponent(Dimension dimension, Shape shape, Renderer renderer, AffineTransform affineTransform, String string) {
        LayerComposition layerComposition = new LayerComposition(dimension);
        Rectangle rectangle = new Rectangle(-1, -1, dimension.width, dimension.height);
        ShapeLayer shapeLayer = new ShapeLayer(layerComposition, shape, renderer);
        shapeLayer.setTransform(affineTransform);
        ShapeLayer shapeLayer2 = new ShapeLayer(layerComposition, rectangle, new StrokeRenderer((Paint)Color.black, 1.0f));
        layerComposition.setLayers(new Layer[]{shapeLayer, shapeLayer2});
        layerComposition.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        CompositionComponent compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText(string);
        return compositionComponent;
    }
}

