/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class ServiceHandler {
    private static boolean servicesStopped = false;

    public static void resetStopState() {
        servicesStopped = false;
    }

    public static void stopServices(Context context, boolean bl) {
        ContextImpl contextImpl = (ContextImpl)context;
        if (!bl && servicesStopped) {
            return;
        }
        if (!InstallerUtil.isWindows() || InstallerUtil.isWindows9X()) {
            return;
        }
        List list = contextImpl.getInstallationProperties().getPropertyList("service");
        if (list.size() > 0) {
            ProgressInterface progressInterface = contextImpl.getProgressInterface();
            progressInterface.setStatusMessage(Messages.getMessages().getString("StatusStoppingServices"));
            progressInterface.setDetailMessage(" ");
            progressInterface.setIndeterminateProgress(true);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!new File(string).exists()) continue;
                try {
                    Process process = Runtime.getRuntime().exec(new String[]{string, "/stop"});
                    process.waitFor();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            progressInterface.setIndeterminateProgress(false);
        }
        servicesStopped = true;
    }
}

