/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.parse_tree;

import java.util.Stack;
import org.cytoscape.equations.CodeAndSourceLocation;
import org.cytoscape.equations.Function;
import org.cytoscape.equations.interpreter.Instruction;
import org.cytoscape.equations.parse_tree.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FuncCallNode
extends Node {
    private final Function func;
    final Class returnType;
    private final Node[] args;

    public FuncCallNode(int sourceLocation, Function func, Class returnType, Node[] args) {
        super(sourceLocation);
        if (func == null) {
            throw new IllegalArgumentException("function must not be null!");
        }
        if (returnType == null) {
            throw new IllegalArgumentException("return type must not be null!");
        }
        if (args == null) {
            throw new IllegalArgumentException("args must not be null!");
        }
        this.func = func;
        this.returnType = returnType;
        this.args = args;
    }

    @Override
    public String toString() {
        return "FuncCallNode: call to " + this.func.getName().toUpperCase() + " with " + this.args.length + " args";
    }

    @Override
    public Class getType() {
        return this.returnType;
    }

    @Override
    public Node getLeftChild() {
        return null;
    }

    @Override
    public Node getRightChild() {
        return null;
    }

    public Object getValue() {
        return null;
    }

    @Override
    public void genCode(Stack<CodeAndSourceLocation> codeStack) {
        for (int i = this.args.length - 1; i >= 0; --i) {
            this.args[i].genCode(codeStack);
        }
        codeStack.push(new CodeAndSourceLocation(this.args.length, -1));
        codeStack.push(new CodeAndSourceLocation(this.func, -1));
        codeStack.push(new CodeAndSourceLocation((Object)Instruction.CALL, this.getSourceLocation()));
    }
}

