/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.automata;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.automata.AutomatonException;
import org.biojava.utils.automata.FiniteAutomaton;
import org.biojava.utils.automata.NfaBuilder;

public class Nfa
extends FiniteAutomaton
implements NfaBuilder {
    static Symbol EPSILON = null;
    static Symbol LAMBDA = AlphabetManager.createSymbol("lambda");

    public Nfa(String name, FiniteAlphabet alfa) {
        super(name, alfa);
    }

    protected int alphaIndex(Symbol sym) throws IllegalSymbolException {
        if (sym == LAMBDA) {
            return 998;
        }
        return super.alphaIndex(sym);
    }

    public boolean containsNode(FiniteAutomaton.Node node) {
        return this.nodes.contains(node);
    }

    public FiniteAutomaton.Transition addEpsilonTransition(FiniteAutomaton.Node start, FiniteAutomaton.Node end) {
        return this.addTransition(start, end, EPSILON);
    }

    public FiniteAutomaton.Transition addLambdaTransition(FiniteAutomaton.Node start, FiniteAutomaton.Node end) {
        return this.addTransition(start, end, LAMBDA);
    }

    void doEpsilonClosure() {
        boolean foundEpsilonTransitions;
        HashSet<FiniteAutomaton.Node> closure = new HashSet<FiniteAutomaton.Node>();
        do {
            closure.clear();
            foundEpsilonTransitions = false;
            Iterator transI = this.transitions.iterator();
            while (transI.hasNext()) {
                FiniteAutomaton.Transition currTransition = (FiniteAutomaton.Transition)transI.next();
                if (currTransition.sym != EPSILON) continue;
                foundEpsilonTransitions = true;
                if (closure.isEmpty()) {
                    closure.add(currTransition.source);
                    closure.add(currTransition.dest);
                    continue;
                }
                if (!closure.contains(currTransition.source) && !closure.contains(currTransition.dest)) continue;
                closure.add(currTransition.source);
                closure.add(currTransition.dest);
            }
            if (!foundEpsilonTransitions) continue;
            boolean containsStart = closure.contains(this.start);
            boolean containsEnd = closure.contains(this.end);
            if (containsStart && containsEnd) {
                throw new BioError("The epsilon transitions span entire model, you fool!");
            }
            FiniteAutomaton.Node vicar = null;
            vicar = containsStart ? this.start : (containsEnd ? this.end : (FiniteAutomaton.Node)closure.iterator().next());
            this.replaceNode(closure, vicar);
        } while (foundEpsilonTransitions);
    }

    FiniteAutomaton.NodeSet getLambdaClosure(FiniteAutomaton.Node node) throws AutomatonException {
        return this._getLambdaClosure(node, this.createNodeSet());
    }

    private FiniteAutomaton.NodeSet _getLambdaClosure(FiniteAutomaton.Node node, FiniteAutomaton.NodeSet visitedNodes) throws AutomatonException {
        visitedNodes.addNode(node);
        FiniteAutomaton.NodeSet closureSet = this.createNodeSet();
        FiniteAutomaton.NodeSet thisClosure = this.getClosure(node, LAMBDA);
        closureSet.addNodeSet(thisClosure);
        Iterator closI = thisClosure.iterator();
        while (closI.hasNext()) {
            FiniteAutomaton.Node currNode = (FiniteAutomaton.Node)closI.next();
            if (visitedNodes.contains(currNode)) continue;
            closureSet.addNodeSet(this._getLambdaClosure(currNode, visitedNodes));
        }
        return closureSet;
    }

    private void replaceNode(Set oldNodes, FiniteAutomaton.Node newNode) {
        FiniteAutomaton.Transition currTransition;
        FiniteAutomaton.Transition[] transitionArray = new FiniteAutomaton.Transition[this.transitions.size()];
        int j = 0;
        Iterator tranI = this.transitions.iterator();
        while (tranI.hasNext()) {
            currTransition = (FiniteAutomaton.Transition)tranI.next();
            if (oldNodes.contains(currTransition.source)) {
                currTransition.source = newNode;
            }
            if (oldNodes.contains(currTransition.dest)) {
                currTransition.dest = newNode;
            }
            transitionArray[j++] = currTransition;
        }
        this.transitions.clear();
        for (int i = 0; i < j; ++i) {
            currTransition = transitionArray[i];
            if (currTransition.sym == EPSILON && currTransition.source == currTransition.dest) continue;
            this.transitions.add(currTransition);
        }
        Iterator oldI = oldNodes.iterator();
        while (oldI.hasNext()) {
            this.nodes.remove(oldI.next());
        }
        this.nodes.add(newNode);
    }
}

