/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.projection;

import java.util.ArrayList;
import java.util.Iterator;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;

public class ProjectionUtils {
    public static Location transformLocation(Location oldLoc, int translation, boolean oppositeStrand) {
        if (oppositeStrand) {
            return ProjectionUtils.flipLocation(oldLoc, translation);
        }
        return oldLoc.translate(translation);
    }

    public static Location revertLocation(Location oldLoc, int translation, boolean oppositeStrand) {
        if (oppositeStrand) {
            return ProjectionUtils.flipLocation(oldLoc, translation);
        }
        return oldLoc.translate(-translation);
    }

    public static Location flipLocation(Location oldLoc, int translation) {
        if (oldLoc.isContiguous()) {
            if (oldLoc instanceof PointLocation) {
                return new PointLocation(translation - oldLoc.getMin());
            }
            return new RangeLocation(translation - oldLoc.getMax(), translation - oldLoc.getMin());
        }
        ArrayList<RangeLocation> locList = new ArrayList<RangeLocation>();
        Iterator i = oldLoc.blockIterator();
        while (i.hasNext()) {
            Location oldBlock = (Location)i.next();
            locList.add(new RangeLocation(translation - oldBlock.getMax(), translation - oldBlock.getMin()));
        }
        Location compound = LocationTools.union(locList);
        return compound;
    }

    public static StrandedFeature.Strand flipStrand(StrandedFeature.Strand s) {
        if (s == StrandedFeature.POSITIVE) {
            return StrandedFeature.NEGATIVE;
        }
        if (s == StrandedFeature.NEGATIVE) {
            return StrandedFeature.POSITIVE;
        }
        return StrandedFeature.UNKNOWN;
    }
}

