/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.game;

import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.game.ElementRecognizer;
import org.biojava.bio.seq.io.game.StAXFeatureHandler;
import org.biojava.bio.seq.io.game.StAXHandlerFactory;
import org.biojava.bio.seq.io.game.StAXPropertyHandler;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.stax.IntElementHandlerBase;
import org.biojava.utils.stax.StAXContentHandler;

public class GAMESpanPropHandler
extends StAXPropertyHandler {
    public static final StAXHandlerFactory GAME_SPAN_PROP_HANDLER_FACTORY = new StAXHandlerFactory(){

        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new GAMESpanPropHandler(staxenv);
        }
    };
    private int start = 0;
    private int stop = 0;
    private StAXFeatureHandler staxenv;

    GAMESpanPropHandler(StAXFeatureHandler staxenv) {
        super(staxenv);
        this.setHandlerCharacteristics("span", true);
        this.staxenv = staxenv;
        super.addHandler(new ElementRecognizer.ByLocalName("start"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StartHandler();
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("end"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StopHandler();
            }
        });
    }

    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler handler) {
        boolean isStrandedTemplate = this.staxenv.featureTemplate instanceof StrandedFeature.Template;
        Feature.Template templ = this.staxenv.featureTemplate;
        if (this.start < this.stop) {
            templ.location = new RangeLocation(this.start + 1, this.stop);
            if (isStrandedTemplate) {
                ((StrandedFeature.Template)templ).strand = StrandedFeature.POSITIVE;
            }
        } else if (this.start > this.stop) {
            this.staxenv.featureTemplate.location = new RangeLocation(this.stop + 1, this.start);
            if (isStrandedTemplate) {
                ((StrandedFeature.Template)templ).strand = StrandedFeature.NEGATIVE;
            }
        } else {
            this.staxenv.featureTemplate.location = new PointLocation(this.start);
            if (isStrandedTemplate) {
                ((StrandedFeature.Template)templ).strand = StrandedFeature.UNKNOWN;
            }
        }
    }

    private class StopHandler
    extends IntElementHandlerBase {
        private StopHandler() {
        }

        protected void setIntValue(int val) {
            GAMESpanPropHandler.this.stop = val;
        }
    }

    private class StartHandler
    extends IntElementHandlerBase {
        private StartHandler() {
        }

        protected void setIntValue(int val) {
            GAMESpanPropHandler.this.start = val;
        }
    }
}

