/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.homologene;

import org.biojava.bio.program.homologene.HomologeneTools;
import org.biojava.bio.program.homologene.Orthologue;
import org.biojava.bio.program.homologene.Taxon;

public class SimpleOrthologue
implements Orthologue {
    private String title;
    private Taxon taxon;
    private String locusID;
    private String homologeneID;
    private String accession;

    public SimpleOrthologue(Taxon taxon, String locusID, String homologeneID, String accession) {
        this.setTaxon(taxon);
        this.setLocusID(locusID);
        this.setHomologeneID(homologeneID);
        this.setAccession(accession);
    }

    public SimpleOrthologue(int taxonID, String locusID, String homologeneID, String accession) throws IllegalArgumentException {
        this.taxon = HomologeneTools.getTaxon(taxonID);
        if (this.taxon == null) {
            throw new IllegalArgumentException("Taxon with ID of " + taxonID + " does not exist.");
        }
        this.setTaxon(this.taxon);
        this.setLocusID(locusID);
        this.setHomologeneID(homologeneID);
        this.setAccession(accession);
    }

    public String getTitle() {
        return this.title;
    }

    public Taxon getTaxon() {
        return this.taxon;
    }

    public int getTaxonID() {
        return this.taxon.getTaxonID();
    }

    public String getLocusID() {
        return this.locusID;
    }

    public String getHomologeneID() {
        return this.homologeneID;
    }

    public String getAccession() {
        return this.accession;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    void setTaxon(Taxon taxon) {
        this.taxon = taxon;
    }

    void setLocusID(String locusID) {
        this.locusID = locusID.trim();
    }

    void setHomologeneID(String homologeneID) {
        this.homologeneID = homologeneID.trim();
    }

    void setAccession(String accession) {
        this.accession = accession.trim();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Orthologue)) {
            return false;
        }
        Orthologue other = (Orthologue)o;
        if (other.getTaxon() != this.taxon) {
            return false;
        }
        if (other.getLocusID() != this.locusID) {
            return false;
        }
        if (other.getHomologeneID() != this.homologeneID) {
            return false;
        }
        return other.getAccession() == this.accession;
    }
}

