/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.biojava.bio.AbstractAnnotation;
import org.biojava.bio.Annotation;
import org.biojava.bio.AnnotationType;
import org.biojava.bio.BioError;
import org.biojava.bio.CollectionConstraint;
import org.biojava.bio.PropertyConstraint;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.utils.ChangeVetoException;

public final class AnnotationTools {
    public static Annotation allIn(Annotation annotation, AnnotationType annType) {
        AbstractAnnotation res = annotation instanceof SmallAnnotation ? new SmallAnnotation() : new SimpleAnnotation();
        Iterator i = annType.getProperties().iterator();
        while (i.hasNext()) {
            Object tag = i.next();
            try {
                res.setProperty(tag, annotation.getProperty(tag));
            }
            catch (ChangeVetoException cve) {
                throw new BioError("Assertion Failure: Can't alter an annotation", cve);
            }
        }
        return res;
    }

    public static Annotation allOut(Annotation annotation, AnnotationType annType) {
        AbstractAnnotation res = annotation instanceof SmallAnnotation ? new SmallAnnotation() : new SimpleAnnotation();
        Set props = annType.getProperties();
        Iterator i = annotation.keys().iterator();
        while (i.hasNext()) {
            Object tag = i.next();
            if (props.contains(tag)) continue;
            try {
                res.setProperty(tag, annotation.getProperty(tag));
            }
            catch (ChangeVetoException cve) {
                throw new BioError("Assertion Failure: Can't alter an annotation", cve);
            }
        }
        return res;
    }

    public static Set searchAnnotation(Annotation ann, AnnotationType query) {
        HashSet hits = new HashSet();
        AnnotationTools.searchAnnotation(ann, query, hits);
        return hits;
    }

    private static void searchAnnotation(Annotation ann, AnnotationType query, Set hits) {
        if (query.instanceOf(ann)) {
            hits.add(ann);
        }
        Iterator i = ann.keys().iterator();
        while (i.hasNext()) {
            Object prop = i.next();
            Object val = ann.getProperty(prop);
            if (val instanceof Annotation) {
                AnnotationTools.searchAnnotation((Annotation)val, query, hits);
                continue;
            }
            if (!(prop instanceof Collection)) continue;
            Iterator vi = ((Collection)val).iterator();
            while (vi.hasNext()) {
                Object v = vi.next();
                if (!(v instanceof Annotation)) continue;
                AnnotationTools.searchAnnotation((Annotation)v, query, hits);
            }
        }
    }

    public static AnnotationType intersection(AnnotationType ann1, AnnotationType ann2) {
        if (ann1.subTypeOf(ann2)) {
            return ann2;
        }
        if (ann2.subTypeOf(ann1)) {
            return ann1;
        }
        HashSet props = new HashSet();
        props.addAll(ann1.getProperties());
        props.addAll(ann2.getProperties());
        AnnotationType.Impl intersect = new AnnotationType.Impl();
        Iterator i = props.iterator();
        while (i.hasNext()) {
            CollectionConstraint pc2;
            Object key = i.next();
            CollectionConstraint pc1 = ann1.getConstraint(key);
            CollectionConstraint pc = AnnotationTools.intersection(pc1, pc2 = ann2.getConstraint(key));
            if (pc == CollectionConstraint.NONE) {
                return AnnotationType.NONE;
            }
            intersect.setConstraint(key, pc);
        }
        intersect.setDefaultConstraint(AnnotationTools.intersection(ann1.getDefaultConstraint(), ann2.getDefaultConstraint()));
        return intersect;
    }

    public static PropertyConstraint intersection(PropertyConstraint pc1, PropertyConstraint pc2) {
        if (pc1.subConstraintOf(pc2)) {
            return pc2;
        }
        if (pc2.subConstraintOf(pc1)) {
            return pc1;
        }
        if (pc1 instanceof PropertyConstraint.ByClass && pc2 instanceof PropertyConstraint.ByClass) {
            PropertyConstraint.ByClass pc1c = (PropertyConstraint.ByClass)pc1;
            PropertyConstraint.ByClass pc2c = (PropertyConstraint.ByClass)pc2;
            Class c1 = pc1c.getPropertyClass();
            Class c2 = pc2c.getPropertyClass();
            if (!c1.isInterface() && !c2.isInterface()) {
                return new PropertyConstraint.And(pc1c, pc2c);
            }
            return PropertyConstraint.NONE;
        }
        if (pc2 instanceof PropertyConstraint.ByClass) {
            return AnnotationTools.intersection(pc2, pc1);
        }
        if (pc1 instanceof PropertyConstraint.ByClass) {
            PropertyConstraint.ByClass pc1c = (PropertyConstraint.ByClass)pc1;
            if (pc2 instanceof PropertyConstraint.Enumeration) {
                PropertyConstraint.Enumeration pc2e = (PropertyConstraint.Enumeration)pc2;
                HashSet values = new HashSet();
                Iterator i = pc2e.getValues().iterator();
                while (i.hasNext()) {
                    Object val = i.next();
                    if (!pc1c.accept(val)) continue;
                    values.add(val);
                }
                if (values.isEmpty()) {
                    return PropertyConstraint.NONE;
                }
                if (values.size() == 1) {
                    return new PropertyConstraint.ExactValue(values.iterator().next());
                }
                return new PropertyConstraint.Enumeration(values);
            }
            if (pc2 instanceof PropertyConstraint.ExactValue) {
                return PropertyConstraint.NONE;
            }
        } else {
            if ((pc1 instanceof PropertyConstraint.Enumeration || pc1 instanceof PropertyConstraint.ExactValue) && (pc2 instanceof PropertyConstraint.Enumeration || pc2 instanceof PropertyConstraint.ExactValue)) {
                if (pc1 instanceof PropertyConstraint.Enumeration && pc2 instanceof PropertyConstraint.Enumeration) {
                    HashSet intersection = new HashSet(((PropertyConstraint.Enumeration)pc1).getValues());
                    intersection.retainAll(((PropertyConstraint.Enumeration)pc2).getValues());
                    if (intersection.size() == 0) {
                        return PropertyConstraint.NONE;
                    }
                    if (intersection.size() == 1) {
                        return new PropertyConstraint.ExactValue(intersection.iterator().next());
                    }
                    return new PropertyConstraint.Enumeration(intersection);
                }
                return PropertyConstraint.NONE;
            }
            if (pc1 instanceof PropertyConstraint.ByAnnotationType && !(pc2 instanceof PropertyConstraint.ByAnnotationType) || pc2 instanceof PropertyConstraint.ByAnnotationType && !(pc1 instanceof PropertyConstraint.ByAnnotationType)) {
                return PropertyConstraint.NONE;
            }
            if (pc1 instanceof PropertyConstraint.ByAnnotationType && pc2 instanceof PropertyConstraint.ByAnnotationType) {
                PropertyConstraint.ByAnnotationType pc1a = (PropertyConstraint.ByAnnotationType)pc1;
                PropertyConstraint.ByAnnotationType pc2a = (PropertyConstraint.ByAnnotationType)pc2;
                AnnotationType intersect = AnnotationTools.intersection(pc1a.getAnnotationType(), pc2a.getAnnotationType());
                if (intersect == AnnotationType.NONE) {
                    return PropertyConstraint.NONE;
                }
                return new PropertyConstraint.ByAnnotationType(intersect);
            }
        }
        return new PropertyConstraint.And(pc1, pc2);
    }

    public static AnnotationType union(AnnotationType ann1, AnnotationType ann2) {
        if (ann1.subTypeOf(ann2)) {
            return ann1;
        }
        if (ann2.subTypeOf(ann1)) {
            return ann2;
        }
        HashSet props = new HashSet();
        props.addAll(ann1.getProperties());
        props.addAll(ann2.getProperties());
        AnnotationType.Impl union = new AnnotationType.Impl();
        Iterator i = props.iterator();
        while (i.hasNext()) {
            Object key = i.next();
            CollectionConstraint pc1 = ann1.getConstraint(key);
            CollectionConstraint pc2 = ann2.getConstraint(key);
            CollectionConstraint pc = AnnotationTools.union(pc1, pc2);
            union.setConstraint(key, pc);
        }
        return union;
    }

    public static PropertyConstraint union(PropertyConstraint pc1, PropertyConstraint pc2) {
        if (pc1.subConstraintOf(pc2)) {
            return pc1;
        }
        if (pc2.subConstraintOf(pc1)) {
            return pc2;
        }
        if (pc1 instanceof PropertyConstraint.ByClass && pc2 instanceof PropertyConstraint.ByClass) {
            return new PropertyConstraint.Or(pc1, pc2);
        }
        if (pc2 instanceof PropertyConstraint.ByClass) {
            return AnnotationTools.intersection(pc2, pc1);
        }
        if (pc1 instanceof PropertyConstraint.ByClass) {
            PropertyConstraint.ByClass pc1c = (PropertyConstraint.ByClass)pc1;
            if (pc2 instanceof PropertyConstraint.Enumeration) {
                PropertyConstraint.Enumeration pc2e = (PropertyConstraint.Enumeration)pc2;
                HashSet values = new HashSet();
                Iterator i = pc2e.getValues().iterator();
                while (i.hasNext()) {
                    Object val = i.next();
                    if (pc1c.accept(val)) continue;
                    values.add(val);
                }
                if (values.isEmpty()) {
                    return pc1;
                }
                if (values.size() == 1) {
                    return new PropertyConstraint.Or(pc1, new PropertyConstraint.ExactValue(values.iterator().next()));
                }
                return new PropertyConstraint.Or(pc1, new PropertyConstraint.Enumeration(values));
            }
            if (pc2 instanceof PropertyConstraint.ExactValue) {
                return new PropertyConstraint.Or(pc1, pc2);
            }
        } else if (pc1 instanceof PropertyConstraint.ByAnnotationType && pc2 instanceof PropertyConstraint.ByAnnotationType) {
            PropertyConstraint.ByAnnotationType pc1a = (PropertyConstraint.ByAnnotationType)pc1;
            PropertyConstraint.ByAnnotationType pc2a = (PropertyConstraint.ByAnnotationType)pc2;
            return new PropertyConstraint.ByAnnotationType(AnnotationTools.union(pc1a.getAnnotationType(), pc2a.getAnnotationType()));
        }
        return new PropertyConstraint.Or(pc1, pc2);
    }

    public static CollectionConstraint intersection(CollectionConstraint cc1, CollectionConstraint cc2) {
        if (cc1.subConstraintOf(cc2)) {
            return cc2;
        }
        if (cc2.subConstraintOf(cc1)) {
            return cc1;
        }
        if (cc1 instanceof CollectionConstraint.AllValuesIn && cc2 instanceof CollectionConstraint.AllValuesIn) {
            Location card2;
            PropertyConstraint pc1 = ((CollectionConstraint.AllValuesIn)cc1).getPropertyConstraint();
            PropertyConstraint pc2 = ((CollectionConstraint.AllValuesIn)cc2).getPropertyConstraint();
            Location card1 = ((CollectionConstraint.AllValuesIn)cc1).getCardinalityConstraint();
            Location card = LocationTools.intersection(card1, card2 = ((CollectionConstraint.AllValuesIn)cc2).getCardinalityConstraint());
            if (card == Location.empty) {
                return CollectionConstraint.NONE;
            }
            PropertyConstraint pc = AnnotationTools.intersection(pc1, pc2);
            if (pc == PropertyConstraint.NONE && !card.contains(0)) {
                return CollectionConstraint.NONE;
            }
            return new CollectionConstraint.AllValuesIn(pc, card);
        }
        if (cc1 instanceof CollectionConstraint.Contains && cc2 instanceof CollectionConstraint.Contains) {
            Location card2;
            PropertyConstraint pc1 = ((CollectionConstraint.Contains)cc1).getPropertyConstraint();
            PropertyConstraint pc2 = ((CollectionConstraint.Contains)cc2).getPropertyConstraint();
            Location card1 = ((CollectionConstraint.Contains)cc1).getCardinalityConstraint();
            Location card = LocationTools.intersection(card1, card2 = ((CollectionConstraint.Contains)cc2).getCardinalityConstraint());
            if (card == Location.empty) {
                return CollectionConstraint.NONE;
            }
            PropertyConstraint pc = AnnotationTools.intersection(pc1, pc2);
            if (pc == PropertyConstraint.NONE && !card.contains(0)) {
                return CollectionConstraint.NONE;
            }
            return new CollectionConstraint.Contains(pc, card);
        }
        if (cc1 instanceof CollectionConstraint.Contains && cc2 instanceof CollectionConstraint.AllValuesIn) {
            PropertyConstraint pc1 = ((CollectionConstraint.Contains)cc1).getPropertyConstraint();
            PropertyConstraint pc2 = ((CollectionConstraint.AllValuesIn)cc2).getPropertyConstraint();
            Location card1 = ((CollectionConstraint.Contains)cc1).getCardinalityConstraint();
            Location card2 = ((CollectionConstraint.AllValuesIn)cc2).getCardinalityConstraint();
            if (card1.getMin() > card2.getMax()) {
                return CollectionConstraint.NONE;
            }
            PropertyConstraint pc = AnnotationTools.intersection(pc1, pc2);
            if (pc == PropertyConstraint.NONE && !card1.contains(0)) {
                return CollectionConstraint.NONE;
            }
            return new CollectionConstraint.Contains(pc, card1);
        }
        if (cc1 instanceof CollectionConstraint.AllValuesIn && cc2 instanceof CollectionConstraint.Contains) {
            return AnnotationTools.intersection(cc2, cc1);
        }
        return new CollectionConstraint.And(cc1, cc2);
    }

    public static CollectionConstraint union(CollectionConstraint cc1, CollectionConstraint cc2) {
        if (cc1.subConstraintOf(cc2)) {
            return cc1;
        }
        if (cc2.subConstraintOf(cc1)) {
            return cc2;
        }
        return new CollectionConstraint.Or(cc1, cc2);
    }
}

