/*
 * Decompiled with CFR 0.152.
 */
package fing.model;

import cytoscape.graph.dynamic.DynamicGraph;
import cytoscape.graph.dynamic.util.DynamicGraphFactory;
import cytoscape.util.intr.ArrayIntIterator;
import cytoscape.util.intr.IntArray;
import cytoscape.util.intr.IntEnumerator;
import cytoscape.util.intr.IntHash;
import cytoscape.util.intr.IntIntHash;
import cytoscape.util.intr.IntIterator;
import cytoscape.util.intr.IntStack;
import cytoscape.util.intr.MinIntHeap;
import fing.model.EdgeArray;
import fing.model.EdgeDepository;
import fing.model.FGraphPerspective;
import fing.model.FingEdgeDepot;
import fing.model.FingNodeDepot;
import fing.model.NodeArray;
import fing.model.NodeDepository;
import fing.model.RootGraphChangeListenerChain;
import fing.model.RootGraphEdgesRemovedEvent;
import fing.model.RootGraphNodesRemovedEvent;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.model.RootGraph;
import giny.model.RootGraphChangeEvent;
import giny.model.RootGraphChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class FRootGraph
implements RootGraph,
DynamicGraph {
    private final IntHash m_hash2 = new IntHash();
    private final IntStack m_stack = new IntStack();
    private final DynamicGraph m_graph = DynamicGraphFactory.instantiateDynamicGraph();
    private RootGraphChangeListener m_lis = new RootGraphChangeListener(){

        public void rootGraphChanged(RootGraphChangeEvent event) {
        }
    };
    private final IntHash m_hash = new IntHash();
    private final MinIntHeap m_heap = new MinIntHeap();
    private final FingNodeDepot m_nodeDepot;
    private final FingEdgeDepot m_edgeDepot;
    private final NodeArray m_nodes = new NodeArray();
    private final EdgeArray m_edges = new EdgeArray();
    private final DynamicGraph m_metaGraph = DynamicGraphFactory.instantiateDynamicGraph();
    private final IntArray m_metaToNativeInxMap = new IntArray();
    private final IntIntHash m_nativeToMetaNodeInxMap = new IntIntHash();
    private final IntIntHash m_nativeToMetaEdgeInxMap = new IntIntHash();

    public IntEnumerator nodes() {
        return this.m_graph.nodes();
    }

    public IntEnumerator edges() {
        return this.m_graph.edges();
    }

    public int nodeCreate() {
        return ~this.createNode();
    }

    public boolean nodeRemove(int node) {
        return this.removeNode(~node) != 0;
    }

    public int edgeCreate(int sourceNode, int targetNode, boolean directed) {
        return ~this.createEdge(~sourceNode, ~targetNode, directed);
    }

    public boolean edgeRemove(int edge) {
        return this.removeEdge(~edge) != 0;
    }

    public boolean nodeExists(int node) {
        return this.m_graph.nodeExists(node);
    }

    public byte edgeType(int edge) {
        return this.m_graph.edgeType(edge);
    }

    public int edgeSource(int edge) {
        return this.m_graph.edgeSource(edge);
    }

    public int edgeTarget(int edge) {
        return this.m_graph.edgeTarget(edge);
    }

    public IntEnumerator edgesAdjacent(int node, boolean outgoing, boolean incoming, boolean undirected) {
        return this.m_graph.edgesAdjacent(node, outgoing, incoming, undirected);
    }

    public IntIterator edgesConnecting(int node0, int node1, boolean outgoing, boolean incoming, boolean undirected) {
        return this.m_graph.edgesConnecting(node0, node1, outgoing, incoming, undirected);
    }

    void addRootGraphChangeListener(RootGraphChangeListener listener) {
        this.m_lis = RootGraphChangeListenerChain.add(this.m_lis, listener);
    }

    void removeRootGraphChangeListener(RootGraphChangeListener listener) {
        this.m_lis = RootGraphChangeListenerChain.remove(this.m_lis, listener);
    }

    public GraphPerspective createGraphPerspective(Node[] nodes, Edge[] edges) {
        final Node[] nodeArr = nodes != null ? nodes : new Node[]{};
        final Edge[] edgeArr = edges != null ? edges : new Edge[]{};
        final FRootGraph root = this;
        try {
            return new FGraphPerspective(this, new IntIterator(){
                private int index = 0;

                public boolean hasNext() {
                    return this.index < nodeArr.length;
                }

                public int nextInt() {
                    if (nodeArr[this.index] == null || nodeArr[this.index].getRootGraph() != root) {
                        throw new IllegalArgumentException();
                    }
                    return nodeArr[this.index++].getRootGraphIndex();
                }
            }, new IntIterator(){
                private int index = 0;

                public boolean hasNext() {
                    return this.index < edgeArr.length;
                }

                public int nextInt() {
                    if (edgeArr[this.index] == null || edgeArr[this.index].getRootGraph() != root) {
                        throw new IllegalArgumentException();
                    }
                    return edgeArr[this.index++].getRootGraphIndex();
                }
            });
        }
        catch (IllegalArgumentException exc) {
            return null;
        }
    }

    public GraphPerspective createGraphPerspective(int[] nodeInx, int[] edgeInx) {
        if (nodeInx == null) {
            nodeInx = new int[]{};
        }
        if (edgeInx == null) {
            edgeInx = new int[]{};
        }
        try {
            return new FGraphPerspective(this, new ArrayIntIterator(nodeInx, 0, nodeInx.length), new ArrayIntIterator(edgeInx, 0, edgeInx.length));
        }
        catch (IllegalArgumentException exc) {
            return null;
        }
    }

    public void ensureCapacity(int nodes, int edges) {
        System.out.println("The secret easter egg module has been activated.");
    }

    public int getNodeCount() {
        return this.m_graph.nodes().numRemaining();
    }

    public int getEdgeCount() {
        return this.m_graph.edges().numRemaining();
    }

    public Iterator nodesIterator() {
        final IntEnumerator nodes = this.m_graph.nodes();
        final FRootGraph rootGraph = this;
        return new Iterator(){

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return nodes.numRemaining() > 0;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return rootGraph.getNode(~nodes.nextInt());
            }
        };
    }

    public List nodesList() {
        int nodeCount = this.getNodeCount();
        ArrayList returnThis = new ArrayList(nodeCount);
        Iterator iter = this.nodesIterator();
        for (int i = 0; i < nodeCount; ++i) {
            returnThis.add(iter.next());
        }
        return returnThis;
    }

    public int[] getNodeIndicesArray() {
        IntEnumerator nodes = this.m_graph.nodes();
        int[] returnThis = new int[nodes.numRemaining()];
        for (int i = 0; i < returnThis.length; ++i) {
            returnThis[i] = ~nodes.nextInt();
        }
        return returnThis;
    }

    public Iterator edgesIterator() {
        final IntEnumerator edges = this.m_graph.edges();
        final FRootGraph rootGraph = this;
        return new Iterator(){

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return edges.numRemaining() > 0;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return rootGraph.getEdge(~edges.nextInt());
            }
        };
    }

    public List edgesList() {
        int edgeCount = this.getEdgeCount();
        ArrayList returnThis = new ArrayList(edgeCount);
        Iterator iter = this.edgesIterator();
        for (int i = 0; i < edgeCount; ++i) {
            returnThis.add(iter.next());
        }
        return returnThis;
    }

    public int[] getEdgeIndicesArray() {
        IntEnumerator edges = this.m_graph.edges();
        int[] returnThis = new int[edges.numRemaining()];
        for (int i = 0; i < returnThis.length; ++i) {
            returnThis[i] = ~edges.nextInt();
        }
        return returnThis;
    }

    public Node removeNode(Node node) {
        if (node.getRootGraph() == this && this.removeNode(node.getRootGraphIndex()) != 0) {
            return node;
        }
        return null;
    }

    public int removeNode(int nodeInx) {
        int i;
        int nativeNodeInx = ~nodeInx;
        if (!this.m_graph.nodeExists(nativeNodeInx)) {
            return 0;
        }
        int metaElement = this.m_nativeToMetaNodeInxMap.get(nativeNodeInx);
        if (this.m_metaGraph.nodeExists(metaElement)) {
            MinIntHeap bucket = new MinIntHeap();
            IntEnumerator nativeEdgeEnum = this.m_graph.edgesAdjacent(nativeNodeInx, true, true, true);
            while (nativeEdgeEnum.numRemaining() > 0) {
                int nativeEdgeInx = nativeEdgeEnum.nextInt();
                int metaEdge = this.m_nativeToMetaEdgeInxMap.get(nativeEdgeInx);
                IntEnumerator metaRelationships = this.m_metaGraph.edgesAdjacent(metaEdge, false, true, false);
                if (metaRelationships == null) continue;
                bucket.empty();
                while (metaRelationships.numRemaining() > 0) {
                    bucket.toss(metaRelationships.nextInt());
                }
                metaRelationships = bucket.elements();
                while (metaRelationships.numRemaining() > 0) {
                    int metaRelationship = metaRelationships.nextInt();
                    int metaParent = this.m_metaGraph.edgeSource(metaRelationship);
                    this.m_metaGraph.edgeRemove(metaRelationship);
                    if (this.m_metaGraph.edgesAdjacent(metaParent, true, true, false).numRemaining() != 0) continue;
                    int nativeNodeParent = this.m_metaToNativeInxMap.getIntAtIndex(metaParent) - 1;
                    this.m_nativeToMetaNodeInxMap.put(nativeNodeParent, Integer.MAX_VALUE);
                    this.m_metaToNativeInxMap.setIntAtIndex(0, metaParent);
                    this.m_metaGraph.nodeRemove(metaParent);
                }
                this.m_nativeToMetaEdgeInxMap.put(nativeEdgeInx, Integer.MAX_VALUE);
                this.m_metaToNativeInxMap.setIntAtIndex(0, metaEdge);
                this.m_metaGraph.nodeRemove(metaEdge);
            }
            IntEnumerator metaRelationships = this.m_metaGraph.edgesAdjacent(metaElement, true, true, false);
            bucket.empty();
            while (metaRelationships.numRemaining() > 0) {
                bucket.toss(metaRelationships.nextInt());
            }
            metaRelationships = bucket.elements();
            while (metaRelationships.numRemaining() > 0) {
                int metaRelationship = metaRelationships.nextInt();
                int otherMetaElement = metaElement ^ this.m_metaGraph.edgeTarget(metaRelationship) ^ this.m_metaGraph.edgeSource(metaRelationship);
                this.m_metaGraph.edgeRemove(metaRelationship);
                if (this.m_metaGraph.edgesAdjacent(otherMetaElement, true, true, false).numRemaining() != 0) continue;
                int f = this.m_metaToNativeInxMap.getIntAtIndex(otherMetaElement);
                if (f > 0) {
                    this.m_nativeToMetaNodeInxMap.put(f - 1, Integer.MAX_VALUE);
                } else {
                    this.m_nativeToMetaEdgeInxMap.put(~f, Integer.MAX_VALUE);
                }
                this.m_metaToNativeInxMap.setIntAtIndex(0, otherMetaElement);
                this.m_metaGraph.nodeRemove(otherMetaElement);
            }
            this.m_nativeToMetaNodeInxMap.put(nativeNodeInx, Integer.MAX_VALUE);
            this.m_metaToNativeInxMap.setIntAtIndex(0, metaElement);
            this.m_metaGraph.nodeRemove(metaElement);
        }
        IntEnumerator nativeEdgeEnum = this.m_graph.edgesAdjacent(nativeNodeInx, true, true, true);
        Edge[] removedEdgeArr = new Edge[nativeEdgeEnum.numRemaining()];
        for (i = 0; i < removedEdgeArr.length; ++i) {
            removedEdgeArr[i] = this.m_edges.getEdgeAtIndex(nativeEdgeEnum.nextInt());
        }
        for (i = 0; i < removedEdgeArr.length; ++i) {
            int nativeEdgeInx = ~removedEdgeArr[i].getRootGraphIndex();
            this.m_graph.edgeRemove(nativeEdgeInx);
            Edge removedEdge = this.m_edges.getEdgeAtIndex(nativeEdgeInx);
            this.m_edges.setEdgeAtIndex(null, nativeEdgeInx);
            this.m_edgeDepot.recycleEdge(removedEdge);
        }
        Node removedNode = this.m_nodes.getNodeAtIndex(nativeNodeInx);
        this.m_graph.nodeRemove(nativeNodeInx);
        this.m_nodes.setNodeAtIndex(null, nativeNodeInx);
        this.m_nodeDepot.recycleNode(removedNode);
        if (removedEdgeArr.length > 0) {
            this.m_lis.rootGraphChanged(new RootGraphEdgesRemovedEvent(this, removedEdgeArr));
        }
        this.m_lis.rootGraphChanged(new RootGraphNodesRemovedEvent(this, new Node[]{removedNode}));
        return nodeInx;
    }

    public List removeNodes(List nodes) {
        ArrayList returnThis = new ArrayList();
        for (int i = 0; i < nodes.size(); ++i) {
            if (this.removeNode((Node)nodes.get(i)) == null) continue;
            returnThis.add(nodes.get(i));
        }
        return returnThis;
    }

    public int[] removeNodes(int[] nodeIndices) {
        int[] returnThis = new int[nodeIndices.length];
        for (int i = 0; i < returnThis.length; ++i) {
            returnThis[i] = this.removeNode(nodeIndices[i]);
        }
        return returnThis;
    }

    public int createNode() {
        int nativeNodeInx = this.m_graph.nodeCreate();
        int returnThis = ~nativeNodeInx;
        Node newNode = this.m_nodeDepot.getNode(this, returnThis, null);
        this.m_nodes.setNodeAtIndex(newNode, nativeNodeInx);
        return returnThis;
    }

    public int createNode(Node[] nodes, Edge[] edges) {
        GraphPerspective persp = this.createGraphPerspective(nodes, edges);
        if (persp == null) {
            return 0;
        }
        return this.createNode(persp);
    }

    public int createNode(GraphPerspective perspective) {
        int i;
        if (((FGraphPerspective)perspective).getRootGraph() != this) {
            return 0;
        }
        int returnThis = this.createNode();
        int nativeParentNodeInx = ~returnThis;
        int[] perspEdgeInxArr = perspective.getEdgeIndicesArray();
        int[] perspNodeInxArr = perspective.getNodeIndicesArray();
        if (perspEdgeInxArr.length == 0 && perspNodeInxArr.length == 0) {
            return returnThis;
        }
        int metaParentNodeInx = this.m_metaGraph.nodeCreate();
        this.m_metaToNativeInxMap.setIntAtIndex(nativeParentNodeInx + 1, metaParentNodeInx);
        this.m_nativeToMetaNodeInxMap.put(nativeParentNodeInx, metaParentNodeInx);
        for (i = 0; i < perspNodeInxArr.length; ++i) {
            int nativeChildNodeInx = ~perspNodeInxArr[i];
            int metaChildNodeInx = this.m_nativeToMetaNodeInxMap.get(nativeChildNodeInx);
            if (metaChildNodeInx < 0 || metaChildNodeInx == Integer.MAX_VALUE) {
                metaChildNodeInx = this.m_metaGraph.nodeCreate();
                this.m_metaToNativeInxMap.setIntAtIndex(nativeChildNodeInx + 1, metaChildNodeInx);
                this.m_nativeToMetaNodeInxMap.put(nativeChildNodeInx, metaChildNodeInx);
            }
            this.m_metaGraph.edgeCreate(metaParentNodeInx, metaChildNodeInx, true);
        }
        for (i = 0; i < perspEdgeInxArr.length; ++i) {
            int nativeChildEdgeInx = ~perspEdgeInxArr[i];
            int metaChildEdgeInx = this.m_nativeToMetaEdgeInxMap.get(nativeChildEdgeInx);
            if (metaChildEdgeInx < 0 || metaChildEdgeInx == Integer.MAX_VALUE) {
                metaChildEdgeInx = this.m_metaGraph.nodeCreate();
                this.m_metaToNativeInxMap.setIntAtIndex(~nativeChildEdgeInx, metaChildEdgeInx);
                this.m_nativeToMetaEdgeInxMap.put(nativeChildEdgeInx, metaChildEdgeInx);
            }
            this.m_metaGraph.edgeCreate(metaParentNodeInx, metaChildEdgeInx, true);
        }
        return returnThis;
    }

    public int createNode(int[] nodeIndices, int[] edgeIndices) {
        GraphPerspective persp = this.createGraphPerspective(nodeIndices, edgeIndices);
        if (persp == null) {
            return 0;
        }
        return this.createNode(persp);
    }

    public int[] createNodes(int numNewNodes) {
        int[] returnThis = new int[numNewNodes];
        for (int i = 0; i < returnThis.length; ++i) {
            returnThis[i] = this.createNode();
        }
        return returnThis;
    }

    public Edge removeEdge(Edge edge) {
        if (edge.getRootGraph() == this && this.removeEdge(edge.getRootGraphIndex()) != 0) {
            return edge;
        }
        return null;
    }

    public int removeEdge(int edgeInx) {
        int nativeEdgeInx = ~edgeInx;
        if (this.m_graph.edgeType(nativeEdgeInx) < 0) {
            return 0;
        }
        int metaEdge = this.m_nativeToMetaEdgeInxMap.get(nativeEdgeInx);
        if (this.m_metaGraph.nodeExists(metaEdge)) {
            MinIntHeap bucket = new MinIntHeap();
            IntEnumerator metaRelationships = this.m_metaGraph.edgesAdjacent(metaEdge, false, true, false);
            while (metaRelationships.numRemaining() > 0) {
                bucket.toss(metaRelationships.nextInt());
            }
            metaRelationships = bucket.elements();
            while (metaRelationships.numRemaining() > 0) {
                int metaRelationship = metaRelationships.nextInt();
                int metaParent = this.m_metaGraph.edgeSource(metaRelationship);
                this.m_metaGraph.edgeRemove(metaRelationship);
                if (this.m_metaGraph.edgesAdjacent(metaParent, true, true, false).numRemaining() != 0) continue;
                int nativeNodeParent = this.m_metaToNativeInxMap.getIntAtIndex(metaParent) - 1;
                this.m_nativeToMetaNodeInxMap.put(nativeNodeParent, Integer.MAX_VALUE);
                this.m_metaToNativeInxMap.setIntAtIndex(0, metaParent);
                this.m_metaGraph.nodeRemove(metaParent);
            }
            this.m_nativeToMetaEdgeInxMap.put(nativeEdgeInx, Integer.MAX_VALUE);
            this.m_metaToNativeInxMap.setIntAtIndex(0, metaEdge);
            this.m_metaGraph.nodeRemove(metaEdge);
        }
        this.m_graph.edgeRemove(nativeEdgeInx);
        Edge removedEdge = this.m_edges.getEdgeAtIndex(nativeEdgeInx);
        this.m_edges.setEdgeAtIndex(null, nativeEdgeInx);
        this.m_edgeDepot.recycleEdge(removedEdge);
        this.m_lis.rootGraphChanged(new RootGraphEdgesRemovedEvent(this, new Edge[]{removedEdge}));
        return edgeInx;
    }

    public List removeEdges(List edges) {
        ArrayList returnThis = new ArrayList();
        for (int i = 0; i < edges.size(); ++i) {
            if (this.removeEdge((Edge)edges.get(i)) == null) continue;
            returnThis.add(edges.get(i));
        }
        return returnThis;
    }

    public int[] removeEdges(int[] edgeIndices) {
        int[] returnThis = new int[edgeIndices.length];
        for (int i = 0; i < returnThis.length; ++i) {
            returnThis[i] = this.removeEdge(edgeIndices[i]);
        }
        return returnThis;
    }

    public int createEdge(Node source, Node target) {
        return this.createEdge(source, target, source.getRootGraphIndex() != target.getRootGraphIndex());
    }

    public int createEdge(Node source, Node target, boolean directed) {
        if (source.getRootGraph() == this && target.getRootGraph() == this) {
            return this.createEdge(source.getRootGraphIndex(), target.getRootGraphIndex(), directed);
        }
        return 0;
    }

    public int createEdge(int sourceNodeIndex, int targetNodeIndex) {
        return this.createEdge(sourceNodeIndex, targetNodeIndex, sourceNodeIndex != targetNodeIndex);
    }

    public int createEdge(int sourceNodeIndex, int targetNodeIndex, boolean directed) {
        int nativeEdgeInx = this.m_graph.edgeCreate(~sourceNodeIndex, ~targetNodeIndex, directed);
        if (nativeEdgeInx < 0) {
            return 0;
        }
        int returnThis = ~nativeEdgeInx;
        Edge newEdge = this.m_edgeDepot.getEdge(this, returnThis, null);
        this.m_edges.setEdgeAtIndex(newEdge, nativeEdgeInx);
        return returnThis;
    }

    public int[] createEdges(int[] sourceNodeIndices, int[] targetNodeIndices, boolean directed) {
        if (sourceNodeIndices.length != targetNodeIndices.length) {
            throw new IllegalArgumentException("input arrays not same length");
        }
        int[] returnThis = new int[sourceNodeIndices.length];
        for (int i = 0; i < returnThis.length; ++i) {
            returnThis[i] = this.createEdge(sourceNodeIndices[i], targetNodeIndices[i], directed);
        }
        return returnThis;
    }

    public boolean containsNode(Node node) {
        return node.getRootGraph() == this && this.getNode(node.getRootGraphIndex()) != null;
    }

    public boolean containsEdge(Edge edge) {
        return edge.getRootGraph() == this && this.getEdge(edge.getRootGraphIndex()) != null;
    }

    public List neighborsList(Node node) {
        if (node.getRootGraph() == this) {
            int nodeIndex = node.getRootGraphIndex();
            int[] adjacentEdgeIndices = this.getAdjacentEdgeIndicesArray(nodeIndex, true, true, true);
            if (adjacentEdgeIndices == null) {
                return null;
            }
            this.m_hash.empty();
            IntHash neighbors = this.m_hash;
            for (int i = 0; i < adjacentEdgeIndices.length; ++i) {
                int neighborIndex = nodeIndex ^ this.getEdgeSourceIndex(adjacentEdgeIndices[i]) ^ this.getEdgeTargetIndex(adjacentEdgeIndices[i]);
                neighbors.put(~neighborIndex);
            }
            IntEnumerator enumx = neighbors.elements();
            ArrayList<Node> list = new ArrayList<Node>(enumx.numRemaining());
            while (enumx.numRemaining() > 0) {
                list.add(this.getNode(~enumx.nextInt()));
            }
            return list;
        }
        return null;
    }

    public boolean isNeighbor(Node a, Node b) {
        if (a.getRootGraph() == this && b.getRootGraph() == this) {
            return this.isNeighbor(a.getRootGraphIndex(), b.getRootGraphIndex());
        }
        return false;
    }

    public boolean isNeighbor(int nodeInxA, int nodeInxB) {
        IntIterator connectingEdges = this.m_graph.edgesConnecting(~nodeInxA, ~nodeInxB, true, true, true);
        if (connectingEdges == null) {
            return false;
        }
        return connectingEdges.hasNext();
    }

    public boolean edgeExists(Node from, Node to) {
        if (from.getRootGraph() == this && to.getRootGraph() == this) {
            return this.edgeExists(from.getRootGraphIndex(), to.getRootGraphIndex());
        }
        return false;
    }

    public boolean edgeExists(int fromNodeInx, int toNodeInx) {
        IntIterator connectingEdges = this.m_graph.edgesConnecting(~fromNodeInx, ~toNodeInx, true, false, true);
        if (connectingEdges == null) {
            return false;
        }
        return connectingEdges.hasNext();
    }

    public int getEdgeCount(Node from, Node to, boolean countUndirectedEdges) {
        if (from.getRootGraph() == this && to.getRootGraph() == this) {
            return this.getEdgeCount(from.getRootGraphIndex(), to.getRootGraphIndex(), countUndirectedEdges);
        }
        return -1;
    }

    public int getEdgeCount(int fromNodeInx, int toNodeInx, boolean countUndirectedEdges) {
        int[] connEdges = this.getEdgeIndicesArray(fromNodeInx, toNodeInx, countUndirectedEdges);
        if (connEdges == null) {
            return -1;
        }
        return connEdges.length;
    }

    public int[] getAdjacentEdgeIndicesArray(int nodeInx, boolean undirected, boolean incomingDirected, boolean outgoingDirected) {
        IntEnumerator adj = this.m_graph.edgesAdjacent(~nodeInx, outgoingDirected, incomingDirected, undirected);
        if (adj == null) {
            return null;
        }
        int[] returnThis = new int[adj.numRemaining()];
        for (int i = 0; i < returnThis.length; ++i) {
            returnThis[i] = ~adj.nextInt();
        }
        return returnThis;
    }

    public int[] getConnectingEdgeIndicesArray(int[] nodeInx) {
        this.m_hash2.empty();
        IntHash nodeBucket = this.m_hash2;
        for (int i = 0; i < nodeInx.length; ++i) {
            int positiveNodeIndex = ~nodeInx[i];
            if (!this.m_graph.nodeExists(positiveNodeIndex)) {
                return null;
            }
            nodeBucket.put(positiveNodeIndex);
        }
        this.m_hash.empty();
        IntHash edgeBucket = this.m_hash;
        IntEnumerator nodeIter = nodeBucket.elements();
        while (nodeIter.numRemaining() > 0) {
            int thePositiveNode = nodeIter.nextInt();
            IntEnumerator edgeIter = this.m_graph.edgesAdjacent(thePositiveNode, true, false, true);
            while (edgeIter.numRemaining() > 0) {
                int candidateEdge = edgeIter.nextInt();
                int otherEdgeNode = thePositiveNode ^ this.m_graph.edgeSource(candidateEdge) ^ this.m_graph.edgeTarget(candidateEdge);
                if (otherEdgeNode != nodeBucket.get(otherEdgeNode)) continue;
                edgeBucket.put(candidateEdge);
            }
        }
        IntEnumerator returnEdges = edgeBucket.elements();
        int[] returnThis = new int[returnEdges.numRemaining()];
        for (int i = 0; i < returnThis.length; ++i) {
            returnThis[i] = ~returnEdges.nextInt();
        }
        return returnThis;
    }

    public int[] getConnectingNodeIndicesArray(int[] edgeInx) {
        this.m_hash.empty();
        IntHash nodeBucket = this.m_hash;
        for (int i = 0; i < edgeInx.length; ++i) {
            int positiveEdge = ~edgeInx[i];
            if (this.m_graph.edgeType(positiveEdge) < 0) {
                return null;
            }
            nodeBucket.put(this.m_graph.edgeSource(positiveEdge));
            nodeBucket.put(this.m_graph.edgeTarget(positiveEdge));
        }
        IntEnumerator nodes = nodeBucket.elements();
        int[] returnThis = new int[nodes.numRemaining()];
        for (int i = 0; i < returnThis.length; ++i) {
            returnThis[i] = ~nodes.nextInt();
        }
        return returnThis;
    }

    public int[] getEdgeIndicesArray(int fromNodeInx, int toNodeInx, boolean undirectedEdges, boolean bothDirections) {
        IntIterator connectingEdges = this.m_graph.edgesConnecting(~fromNodeInx, ~toNodeInx, true, bothDirections, undirectedEdges);
        if (connectingEdges == null) {
            return null;
        }
        this.m_heap.empty();
        MinIntHeap edgeBucket = this.m_heap;
        while (connectingEdges.hasNext()) {
            edgeBucket.toss(~connectingEdges.nextInt());
        }
        int[] returnThis = new int[edgeBucket.size()];
        edgeBucket.copyInto(returnThis, 0);
        return returnThis;
    }

    public List edgesList(Node from, Node to) {
        if (from.getRootGraph() == this && to.getRootGraph() == this) {
            return this.edgesList(from.getRootGraphIndex(), to.getRootGraphIndex(), true);
        }
        return null;
    }

    public List edgesList(int fromNodeInx, int toNodeInx, boolean includeUndirectedEdges) {
        int[] edgeInx = this.getEdgeIndicesArray(fromNodeInx, toNodeInx, includeUndirectedEdges);
        if (edgeInx == null) {
            return null;
        }
        ArrayList<Edge> returnList = new ArrayList<Edge>(edgeInx.length);
        for (int i = 0; i < edgeInx.length; ++i) {
            returnList.add(this.getEdge(edgeInx[i]));
        }
        return returnList;
    }

    public int[] getEdgeIndicesArray(int fromNodeInx, int toNodeInx, boolean includeUndirectedEdges) {
        return this.getEdgeIndicesArray(fromNodeInx, toNodeInx, includeUndirectedEdges, false);
    }

    public int getInDegree(Node node) {
        if (node.getRootGraph() == this) {
            return this.getInDegree(node.getRootGraphIndex());
        }
        return -1;
    }

    public int getInDegree(int nodeInx) {
        return this.getInDegree(nodeInx, true);
    }

    public int getInDegree(Node node, boolean countUndirectedEdges) {
        if (node.getRootGraph() == this) {
            return this.getInDegree(node.getRootGraphIndex(), countUndirectedEdges);
        }
        return -1;
    }

    public int getInDegree(int nodeInx, boolean countUndirectedEdges) {
        IntEnumerator adj = this.m_graph.edgesAdjacent(~nodeInx, false, true, countUndirectedEdges);
        if (adj == null) {
            return -1;
        }
        return adj.numRemaining();
    }

    public int getOutDegree(Node node) {
        if (node.getRootGraph() == this) {
            return this.getOutDegree(node.getRootGraphIndex());
        }
        return -1;
    }

    public int getOutDegree(int nodeInx) {
        return this.getOutDegree(nodeInx, true);
    }

    public int getOutDegree(Node node, boolean countUndirectedEdges) {
        if (node.getRootGraph() == this) {
            return this.getOutDegree(node.getRootGraphIndex(), countUndirectedEdges);
        }
        return -1;
    }

    public int getOutDegree(int nodeInx, boolean countUndirectedEdges) {
        IntEnumerator adj = this.m_graph.edgesAdjacent(~nodeInx, true, false, countUndirectedEdges);
        if (adj == null) {
            return -1;
        }
        return adj.numRemaining();
    }

    public int getDegree(Node node) {
        if (node.getRootGraph() == this) {
            return this.getDegree(node.getRootGraphIndex());
        }
        return -1;
    }

    public int getDegree(int nodeInx) {
        IntEnumerator adj = this.m_graph.edgesAdjacent(~nodeInx, true, true, true);
        if (adj == null) {
            return -1;
        }
        return adj.numRemaining();
    }

    public int getIndex(Node node) {
        if (node.getRootGraph() == this) {
            return node.getRootGraphIndex();
        }
        return 0;
    }

    public Node getNode(int nodeInx) {
        if (nodeInx < 0 && nodeInx != Integer.MIN_VALUE) {
            return this.m_nodes.getNodeAtIndex(~nodeInx);
        }
        return null;
    }

    public int getIndex(Edge edge) {
        if (edge.getRootGraph() == this) {
            return edge.getRootGraphIndex();
        }
        return 0;
    }

    public Edge getEdge(int edgeInx) {
        if (edgeInx < 0 && edgeInx != Integer.MIN_VALUE) {
            return this.m_edges.getEdgeAtIndex(~edgeInx);
        }
        return null;
    }

    public int getEdgeSourceIndex(int edgeInx) {
        return ~this.m_graph.edgeSource(~edgeInx);
    }

    public int getEdgeTargetIndex(int edgeInx) {
        return ~this.m_graph.edgeTarget(~edgeInx);
    }

    public boolean isEdgeDirected(int edgeInx) {
        return this.m_graph.edgeType(~edgeInx) == 1;
    }

    public boolean addMetaChild(Node parent, Node child) {
        if (parent.getRootGraph() != this || child.getRootGraph() != this) {
            return false;
        }
        return this.addNodeMetaChild(parent.getRootGraphIndex(), child.getRootGraphIndex());
    }

    public boolean addNodeMetaChild(int parentNodeInx, int childNodeInx) {
        int metaChildNode;
        int nativeParent = ~parentNodeInx;
        int nativeChildNode = ~childNodeInx;
        if (!this.m_graph.nodeExists(nativeParent) || !this.m_graph.nodeExists(nativeChildNode)) {
            return false;
        }
        int metaParent = this.m_nativeToMetaNodeInxMap.get(nativeParent);
        if (metaParent < 0 || metaParent == Integer.MAX_VALUE) {
            metaParent = this.m_metaGraph.nodeCreate();
            this.m_metaToNativeInxMap.setIntAtIndex(nativeParent + 1, metaParent);
            this.m_nativeToMetaNodeInxMap.put(nativeParent, metaParent);
        }
        if ((metaChildNode = this.m_nativeToMetaNodeInxMap.get(nativeChildNode)) < 0 || metaChildNode == Integer.MAX_VALUE) {
            metaChildNode = this.m_metaGraph.nodeCreate();
            this.m_metaToNativeInxMap.setIntAtIndex(nativeChildNode + 1, metaChildNode);
            this.m_nativeToMetaNodeInxMap.put(nativeChildNode, metaChildNode);
        }
        if (this.m_metaGraph.edgesConnecting(metaParent, metaChildNode, true, false, false).hasNext()) {
            return false;
        }
        this.m_metaGraph.edgeCreate(metaParent, metaChildNode, true);
        return true;
    }

    public boolean removeNodeMetaChild(int parentNodeInx, int childNodeInx) {
        int metaChildNode;
        int nativeParent = ~parentNodeInx;
        int nativeChildNode = ~childNodeInx;
        if (!this.m_graph.nodeExists(nativeParent) || !this.m_graph.nodeExists(nativeChildNode)) {
            return false;
        }
        int metaParent = this.m_nativeToMetaNodeInxMap.get(nativeParent);
        IntIterator metaRelationships = this.m_metaGraph.edgesConnecting(metaParent, metaChildNode = this.m_nativeToMetaNodeInxMap.get(nativeChildNode), true, false, false);
        if (metaRelationships == null || !metaRelationships.hasNext()) {
            return false;
        }
        IntEnumerator nativeEdgesTouchingChild = this.m_graph.edgesAdjacent(nativeChildNode, true, true, true);
        while (nativeEdgesTouchingChild.numRemaining() > 0) {
            this.removeEdgeMetaChild(parentNodeInx, ~nativeEdgesTouchingChild.nextInt());
        }
        metaRelationships = this.m_metaGraph.edgesConnecting(metaParent, metaChildNode, true, false, false);
        int relationshipToRemove = metaRelationships.nextInt();
        if (metaRelationships.hasNext()) {
            throw new IllegalStateException("internal error - need to debug");
        }
        this.m_metaGraph.edgeRemove(relationshipToRemove);
        if (this.m_metaGraph.edgesAdjacent(metaParent, true, true, false).numRemaining() == 0) {
            this.m_nativeToMetaNodeInxMap.put(nativeParent, Integer.MAX_VALUE);
            this.m_metaToNativeInxMap.setIntAtIndex(0, metaParent);
            this.m_metaGraph.nodeRemove(metaParent);
        }
        if (this.m_metaGraph.edgesAdjacent(metaChildNode, true, true, false).numRemaining() == 0) {
            this.m_nativeToMetaNodeInxMap.put(nativeChildNode, Integer.MAX_VALUE);
            this.m_metaToNativeInxMap.setIntAtIndex(0, metaChildNode);
            this.m_metaGraph.nodeRemove(metaChildNode);
        }
        return true;
    }

    public boolean isMetaParent(Node child, Node parent) {
        if (child.getRootGraph() != this || parent.getRootGraph() != this) {
            return false;
        }
        return this.isNodeMetaParent(child.getRootGraphIndex(), parent.getRootGraphIndex());
    }

    public boolean isNodeMetaParent(int childNodeInx, int parentNodeInx) {
        return this.isNodeMetaChild(parentNodeInx, childNodeInx);
    }

    public List metaParentsList(Node node) {
        if (node.getRootGraph() != this) {
            return null;
        }
        return this.nodeMetaParentsList(node.getRootGraphIndex());
    }

    public List nodeMetaParentsList(int nodeInx) {
        int[] parentInxArr = this.getNodeMetaParentIndicesArray(nodeInx);
        if (parentInxArr == null) {
            return null;
        }
        ArrayList<Node> returnThis = new ArrayList<Node>(parentInxArr.length);
        for (int i = 0; i < parentInxArr.length; ++i) {
            returnThis.add(this.getNode(parentInxArr[i]));
        }
        return returnThis;
    }

    public int[] getNodeMetaParentIndicesArray(int nodeInx) {
        int nativeChildNode = ~nodeInx;
        if (!this.m_graph.nodeExists(nativeChildNode)) {
            return null;
        }
        int metaChildNode = this.m_nativeToMetaNodeInxMap.get(nativeChildNode);
        IntEnumerator metaRelationshipsEnum = this.m_metaGraph.edgesAdjacent(metaChildNode, false, true, false);
        if (metaRelationshipsEnum == null) {
            return new int[0];
        }
        int[] returnThis = new int[metaRelationshipsEnum.numRemaining()];
        for (int i = 0; i < returnThis.length; ++i) {
            int metaRelationship = metaRelationshipsEnum.nextInt();
            int metaParent = this.m_metaGraph.edgeSource(metaRelationship);
            returnThis[i] = ~(this.m_metaToNativeInxMap.getIntAtIndex(metaParent) - 1);
        }
        return returnThis;
    }

    public boolean isMetaChild(Node parent, Node child) {
        return this.isMetaParent(child, parent);
    }

    public boolean isNodeMetaChild(int parentNodeInx, int childNodeInx) {
        int metaChildNode;
        int nativeParent = ~parentNodeInx;
        int nativeChildNode = ~childNodeInx;
        if (!this.m_graph.nodeExists(nativeParent) || !this.m_graph.nodeExists(nativeChildNode)) {
            return false;
        }
        int metaParent = this.m_nativeToMetaNodeInxMap.get(nativeParent);
        IntIterator metaRelationshipsIter = this.m_metaGraph.edgesConnecting(metaParent, metaChildNode = this.m_nativeToMetaNodeInxMap.get(nativeChildNode), true, false, false);
        return metaRelationshipsIter != null && metaRelationshipsIter.hasNext();
    }

    public boolean isNodeMetaChild(int parentNodeInx, int childNodeInx, boolean recursive) {
        if (!recursive) {
            return this.isNodeMetaChild(parentNodeInx, childNodeInx);
        }
        int nativeParent = ~parentNodeInx;
        int nativeChildNode = ~childNodeInx;
        if (!this.m_graph.nodeExists(nativeParent) || !this.m_graph.nodeExists(nativeChildNode)) {
            return false;
        }
        int metaParent = this.m_nativeToMetaNodeInxMap.get(nativeParent);
        int metaChildNode = this.m_nativeToMetaNodeInxMap.get(nativeChildNode);
        if (metaParent < 0 || metaParent == Integer.MAX_VALUE || metaChildNode < 0 || metaChildNode == Integer.MAX_VALUE) {
            return false;
        }
        this.m_hash.empty();
        IntHash metaVisited = this.m_hash;
        this.m_stack.empty();
        IntStack metaPending = this.m_stack;
        metaVisited.put(metaParent);
        metaPending.push(metaParent);
        while (metaPending.size() > 0) {
            int currMeta = metaPending.pop();
            IntEnumerator relationships = this.m_metaGraph.edgesAdjacent(currMeta, true, false, false);
            while (relationships.numRemaining() > 0) {
                int aChild = this.m_metaGraph.edgeTarget(relationships.nextInt());
                if (aChild == metaChildNode) {
                    return true;
                }
                if (this.m_metaToNativeInxMap.getIntAtIndex(aChild) <= 0 || metaVisited.put(aChild) >= 0) continue;
                metaPending.push(aChild);
            }
        }
        return false;
    }

    public List nodeMetaChildrenList(Node node) {
        if (node.getRootGraph() != this) {
            return null;
        }
        return this.nodeMetaChildrenList(node.getRootGraphIndex());
    }

    public List nodeMetaChildrenList(int parentNodeInx) {
        int[] childInxArr = this.getNodeMetaChildIndicesArray(parentNodeInx);
        if (childInxArr == null) {
            return null;
        }
        ArrayList<Node> returnThis = new ArrayList<Node>(childInxArr.length);
        for (int i = 0; i < childInxArr.length; ++i) {
            returnThis.add(this.getNode(childInxArr[i]));
        }
        return returnThis;
    }

    public int[] getNodeMetaChildIndicesArray(int parentNodeInx) {
        int nativeParent = ~parentNodeInx;
        if (!this.m_graph.nodeExists(nativeParent)) {
            return null;
        }
        int metaParent = this.m_nativeToMetaNodeInxMap.get(nativeParent);
        IntEnumerator metaRelationshipsEnum = this.m_metaGraph.edgesAdjacent(metaParent, true, false, false);
        if (metaRelationshipsEnum == null) {
            return new int[0];
        }
        this.m_heap.empty();
        MinIntHeap childRootNodeBucket = this.m_heap;
        while (metaRelationshipsEnum.numRemaining() > 0) {
            int metaChild = this.m_metaGraph.edgeTarget(metaRelationshipsEnum.nextInt());
            if (this.m_metaToNativeInxMap.getIntAtIndex(metaChild) <= 0) continue;
            childRootNodeBucket.toss(~(this.m_metaToNativeInxMap.getIntAtIndex(metaChild) - 1));
        }
        int[] returnThis = new int[childRootNodeBucket.size()];
        childRootNodeBucket.copyInto(returnThis, 0);
        return returnThis;
    }

    int[] getNodeMetaChildIndicesArray(int[] parentIndices) {
        this.m_hash.empty();
        IntHash metaVisited = this.m_hash;
        this.m_stack.empty();
        IntStack metaPending = this.m_stack;
        this.m_hash2.empty();
        IntHash nativeChildNodeBucket = this.m_hash2;
        for (int i = 0; i < parentIndices.length; ++i) {
            int nativeParent = ~parentIndices[i];
            if (!this.m_graph.nodeExists(nativeParent)) {
                return null;
            }
            int metaParent = this.m_nativeToMetaNodeInxMap.get(nativeParent);
            if (metaParent < 0 || metaParent == Integer.MAX_VALUE || metaVisited.put(metaParent) >= 0) continue;
            metaPending.push(metaParent);
        }
        while (metaPending.size() > 0) {
            int currMeta = metaPending.pop();
            IntEnumerator relationships = this.m_metaGraph.edgesAdjacent(currMeta, true, false, false);
            while (relationships.numRemaining() > 0) {
                int aChild = this.m_metaGraph.edgeTarget(relationships.nextInt());
                if (this.m_metaToNativeInxMap.getIntAtIndex(aChild) <= 0) continue;
                nativeChildNodeBucket.put(this.m_metaToNativeInxMap.getIntAtIndex(aChild) - 1);
                if (metaVisited.put(aChild) >= 0) continue;
                metaPending.push(aChild);
            }
        }
        IntEnumerator returnElements = nativeChildNodeBucket.elements();
        int[] returnThis = new int[returnElements.numRemaining()];
        for (int i = 0; i < returnThis.length; ++i) {
            returnThis[i] = ~returnElements.nextInt();
        }
        return returnThis;
    }

    public int[] getNodeMetaChildIndicesArray(int parentNodeInx, boolean recursive) {
        if (!recursive) {
            return this.getNodeMetaChildIndicesArray(parentNodeInx);
        }
        return this.getNodeMetaChildIndicesArray(new int[]{parentNodeInx});
    }

    int[] getEdgeMetaChildIndicesArray(int[] parentIndices) {
        this.m_hash.empty();
        IntHash metaVisited = this.m_hash;
        this.m_stack.empty();
        IntStack metaPending = this.m_stack;
        this.m_hash2.empty();
        IntHash nativeChildEdgeBucket = this.m_hash2;
        for (int i = 0; i < parentIndices.length; ++i) {
            int nativeParent = ~parentIndices[i];
            if (!this.m_graph.nodeExists(nativeParent)) {
                return null;
            }
            int metaParent = this.m_nativeToMetaNodeInxMap.get(nativeParent);
            if (metaParent < 0 || metaParent == Integer.MAX_VALUE || metaVisited.put(metaParent) >= 0) continue;
            metaPending.push(metaParent);
        }
        while (metaPending.size() > 0) {
            int currMeta = metaPending.pop();
            IntEnumerator relationships = this.m_metaGraph.edgesAdjacent(currMeta, true, false, false);
            while (relationships.numRemaining() > 0) {
                int aChild = this.m_metaGraph.edgeTarget(relationships.nextInt());
                if (this.m_metaToNativeInxMap.getIntAtIndex(aChild) < 0) {
                    nativeChildEdgeBucket.put(~this.m_metaToNativeInxMap.getIntAtIndex(aChild));
                    continue;
                }
                if (metaVisited.put(aChild) >= 0) continue;
                metaPending.push(aChild);
            }
        }
        IntEnumerator returnElements = nativeChildEdgeBucket.elements();
        int[] returnThis = new int[returnElements.numRemaining()];
        for (int i = 0; i < returnThis.length; ++i) {
            returnThis[i] = ~returnElements.nextInt();
        }
        return returnThis;
    }

    public int[] getChildlessMetaDescendants(int nodeInx) {
        int nativeParent = ~nodeInx;
        if (!this.m_graph.nodeExists(nativeParent)) {
            return null;
        }
        int metaParent = this.m_nativeToMetaNodeInxMap.get(nativeParent);
        if (metaParent < 0 || metaParent == Integer.MAX_VALUE) {
            return new int[0];
        }
        this.m_hash.empty();
        IntHash metaVisited = this.m_hash;
        this.m_stack.empty();
        IntStack metaPending = this.m_stack;
        this.m_hash2.empty();
        IntHash nativeChildlessNodeBucket = this.m_hash2;
        metaVisited.put(metaParent);
        metaPending.push(metaParent);
        while (metaPending.size() > 0) {
            int currMeta = metaPending.pop();
            IntEnumerator relationships = this.m_metaGraph.edgesAdjacent(currMeta, true, false, false);
            while (relationships.numRemaining() > 0) {
                int aChild = this.m_metaGraph.edgeTarget(relationships.nextInt());
                if (this.m_metaToNativeInxMap.getIntAtIndex(aChild) <= 0 || metaVisited.put(aChild) >= 0) continue;
                metaPending.push(aChild);
                if (this.m_metaGraph.edgesAdjacent(aChild, true, false, false).numRemaining() != 0) continue;
                nativeChildlessNodeBucket.put(this.m_metaToNativeInxMap.getIntAtIndex(aChild) - 1);
            }
        }
        IntEnumerator returnElements = nativeChildlessNodeBucket.elements();
        int[] returnThis = new int[returnElements.numRemaining()];
        for (int i = 0; i < returnThis.length; ++i) {
            returnThis[i] = ~returnElements.nextInt();
        }
        return returnThis;
    }

    public boolean addMetaChild(Node parent, Edge child) {
        if (parent.getRootGraph() != this || child.getRootGraph() != this) {
            return false;
        }
        return this.addEdgeMetaChild(parent.getRootGraphIndex(), child.getRootGraphIndex());
    }

    public boolean addEdgeMetaChild(int parentNodeInx, int childEdgeInx) {
        int metaChildEdge;
        int nativeParent = ~parentNodeInx;
        int nativeChildEdge = ~childEdgeInx;
        if (!this.m_graph.nodeExists(nativeParent) || this.m_graph.edgeType(nativeChildEdge) < 0) {
            return false;
        }
        this.addNodeMetaChild(parentNodeInx, ~this.m_graph.edgeSource(nativeChildEdge));
        this.addNodeMetaChild(parentNodeInx, ~this.m_graph.edgeTarget(nativeChildEdge));
        int metaParent = this.m_nativeToMetaNodeInxMap.get(nativeParent);
        if (metaParent < 0 || metaParent == Integer.MAX_VALUE) {
            metaParent = this.m_metaGraph.nodeCreate();
            this.m_metaToNativeInxMap.setIntAtIndex(nativeParent + 1, metaParent);
            this.m_nativeToMetaNodeInxMap.put(nativeParent, metaParent);
        }
        if ((metaChildEdge = this.m_nativeToMetaEdgeInxMap.get(nativeChildEdge)) < 0 || metaChildEdge == Integer.MAX_VALUE) {
            metaChildEdge = this.m_metaGraph.nodeCreate();
            this.m_metaToNativeInxMap.setIntAtIndex(~nativeChildEdge, metaChildEdge);
            this.m_nativeToMetaEdgeInxMap.put(nativeChildEdge, metaChildEdge);
        }
        if (this.m_metaGraph.edgesConnecting(metaParent, metaChildEdge, true, false, false).hasNext()) {
            return false;
        }
        this.m_metaGraph.edgeCreate(metaParent, metaChildEdge, true);
        return true;
    }

    public boolean removeEdgeMetaChild(int parentNodeInx, int childEdgeInx) {
        int metaChildEdge;
        int nativeParent = ~parentNodeInx;
        int nativeChildEdge = ~childEdgeInx;
        if (!this.m_graph.nodeExists(nativeParent) || this.m_graph.edgeType(nativeChildEdge) < 0) {
            return false;
        }
        int metaParent = this.m_nativeToMetaNodeInxMap.get(nativeParent);
        IntIterator metaRelationships = this.m_metaGraph.edgesConnecting(metaParent, metaChildEdge = this.m_nativeToMetaEdgeInxMap.get(nativeChildEdge), true, false, false);
        if (metaRelationships == null || !metaRelationships.hasNext()) {
            return false;
        }
        int relationshipToRemove = metaRelationships.nextInt();
        if (metaRelationships.hasNext()) {
            throw new IllegalStateException("internal error - debug");
        }
        this.m_metaGraph.edgeRemove(relationshipToRemove);
        if (this.m_metaGraph.edgesAdjacent(metaParent, true, true, false).numRemaining() == 0) {
            this.m_nativeToMetaNodeInxMap.put(nativeParent, Integer.MAX_VALUE);
            this.m_metaToNativeInxMap.setIntAtIndex(0, metaParent);
            this.m_metaGraph.nodeRemove(metaParent);
        }
        if (this.m_metaGraph.edgesAdjacent(metaChildEdge, false, true, false).numRemaining() == 0) {
            this.m_nativeToMetaEdgeInxMap.put(nativeChildEdge, Integer.MAX_VALUE);
            this.m_metaToNativeInxMap.setIntAtIndex(0, metaChildEdge);
            this.m_metaGraph.nodeRemove(metaChildEdge);
        }
        return true;
    }

    public boolean isMetaParent(Edge child, Node parent) {
        if (child.getRootGraph() != this || parent.getRootGraph() != this) {
            return false;
        }
        return this.isEdgeMetaParent(child.getRootGraphIndex(), parent.getRootGraphIndex());
    }

    public boolean isEdgeMetaParent(int childEdgeInx, int parentNodeInx) {
        return this.isEdgeMetaChild(parentNodeInx, childEdgeInx);
    }

    public List metaParentsList(Edge edge) {
        if (edge.getRootGraph() != this) {
            return null;
        }
        return this.edgeMetaParentsList(edge.getRootGraphIndex());
    }

    public List edgeMetaParentsList(int edgeInx) {
        int[] metaParentInx = this.getEdgeMetaParentIndicesArray(edgeInx);
        if (metaParentInx == null) {
            return null;
        }
        ArrayList<Node> returnThis = new ArrayList<Node>(metaParentInx.length);
        for (int i = 0; i < metaParentInx.length; ++i) {
            returnThis.add(this.getNode(metaParentInx[i]));
        }
        return returnThis;
    }

    public int[] getEdgeMetaParentIndicesArray(int edgeInx) {
        int nativeChildEdge = ~edgeInx;
        if (this.m_graph.edgeType(nativeChildEdge) < 0) {
            return null;
        }
        int metaChildEdge = this.m_nativeToMetaEdgeInxMap.get(nativeChildEdge);
        IntEnumerator metaRelationshipsEnum = this.m_metaGraph.edgesAdjacent(metaChildEdge, false, true, false);
        if (metaRelationshipsEnum == null) {
            return new int[0];
        }
        int[] returnThis = new int[metaRelationshipsEnum.numRemaining()];
        for (int i = 0; i < returnThis.length; ++i) {
            int metaRelationship = metaRelationshipsEnum.nextInt();
            int metaParent = this.m_metaGraph.edgeSource(metaRelationship);
            returnThis[i] = ~(this.m_metaToNativeInxMap.getIntAtIndex(metaParent) - 1);
        }
        return returnThis;
    }

    public boolean isMetaChild(Node parent, Edge child) {
        return this.isMetaParent(child, parent);
    }

    public boolean isEdgeMetaChild(int parentNodeInx, int childEdgeInx) {
        int metaChildEdge;
        int nativeParent = ~parentNodeInx;
        int nativeChildEdge = ~childEdgeInx;
        if (!this.m_graph.nodeExists(nativeParent) || this.m_graph.edgeType(nativeChildEdge) < 0) {
            return false;
        }
        int metaParent = this.m_nativeToMetaNodeInxMap.get(nativeParent);
        IntIterator metaRelationshipsIter = this.m_metaGraph.edgesConnecting(metaParent, metaChildEdge = this.m_nativeToMetaEdgeInxMap.get(nativeChildEdge), true, false, false);
        return metaRelationshipsIter != null && metaRelationshipsIter.hasNext();
    }

    public List edgeMetaChildrenList(Node node) {
        if (node.getRootGraph() != this) {
            return null;
        }
        return this.edgeMetaChildrenList(node.getRootGraphIndex());
    }

    public List edgeMetaChildrenList(int parentNodeInx) {
        int[] edgeChildrenArr = this.getEdgeMetaChildIndicesArray(parentNodeInx);
        if (edgeChildrenArr == null) {
            return null;
        }
        ArrayList<Edge> returnThis = new ArrayList<Edge>(edgeChildrenArr.length);
        for (int i = 0; i < edgeChildrenArr.length; ++i) {
            returnThis.add(this.getEdge(edgeChildrenArr[i]));
        }
        return returnThis;
    }

    public int[] getEdgeMetaChildIndicesArray(int parentNodeInx) {
        int nativeParent = ~parentNodeInx;
        if (!this.m_graph.nodeExists(nativeParent)) {
            return null;
        }
        int metaParent = this.m_nativeToMetaNodeInxMap.get(nativeParent);
        IntEnumerator metaRelationshipsEnum = this.m_metaGraph.edgesAdjacent(metaParent, true, false, false);
        if (metaRelationshipsEnum == null) {
            return new int[0];
        }
        this.m_heap.empty();
        MinIntHeap childRootEdgeBucket = this.m_heap;
        while (metaRelationshipsEnum.numRemaining() > 0) {
            int metaChild = this.m_metaGraph.edgeTarget(metaRelationshipsEnum.nextInt());
            if (this.m_metaToNativeInxMap.getIntAtIndex(metaChild) >= 0) continue;
            childRootEdgeBucket.toss(this.m_metaToNativeInxMap.getIntAtIndex(metaChild));
        }
        int[] returnThis = new int[childRootEdgeBucket.size()];
        childRootEdgeBucket.copyInto(returnThis, 0);
        return returnThis;
    }

    FRootGraph() {
        this(new NodeDepository(), new EdgeDepository());
    }

    FRootGraph(FingNodeDepot nodeDepot, FingEdgeDepot edgeDepot) {
        if (nodeDepot == null) {
            throw new NullPointerException("nodeDepot is null");
        }
        this.m_nodeDepot = nodeDepot;
        if (edgeDepot == null) {
            throw new NullPointerException("edgeDepot is null");
        }
        this.m_edgeDepot = edgeDepot;
    }
}

