/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.visual.VisualPropertyDependency;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.properties.OpacityValidator;
import cytoscape.visual.ui.icon.LineTypeIcon;
import giny.view.EdgeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;

public class EdgeLabelOpacityProp
extends AbstractVisualProperty {
    public EdgeLabelOpacityProp() {
        this.validator = new OpacityValidator();
    }

    public VisualPropertyType getType() {
        return VisualPropertyType.EDGE_LABEL_OPACITY;
    }

    public Icon getIcon(final Object value) {
        LineTypeIcon icon = new LineTypeIcon(){

            public void paintIcon(Component c, Graphics g, int x, int y) {
                super.setColor(new Color(10, 10, 10, 0));
                super.paintIcon(c, g, x, y);
                this.g2d.setFont(new Font("SansSerif", 1, 24));
                this.g2d.setColor(Color.DARK_GRAY);
                this.g2d.drawString(value.toString(), c.getX() + 48, c.getHeight() / 2 + 7);
                this.g2d.setFont(new Font("SansSerif", 1, 12));
            }
        };
        return icon;
    }

    public void applyToEdgeView(EdgeView ev, Object o, VisualPropertyDependency dep) {
        Integer newTp;
        if (o == null || ev == null) {
            return;
        }
        Integer tp = ((Color)ev.getLabel().getTextPaint()).getAlpha();
        if (tp != (newTp = Integer.valueOf(((Number)o).intValue()))) {
            Color oldPaint = (Color)ev.getLabel().getTextPaint();
            ev.getLabel().setTextPaint(new Color(oldPaint.getRed(), oldPaint.getGreen(), oldPaint.getBlue(), newTp));
        }
    }

    public Object getDefaultAppearanceObject() {
        return new Integer(255);
    }
}

