/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.CyAttributesUtils;
import cytoscape.data.readers.InteractionsReader;
import cytoscape.visual.mappings.PassThroughMapping;
import java.awt.Color;
import java.util.Map;
import junit.framework.TestCase;

public class PassthroughMappingTest
extends TestCase {
    private CyAttributes nodeAttr;
    private CyAttributes edgeAttr;

    protected void setUp() throws Exception {
        super.setUp();
        this.nodeAttr = Cytoscape.getNodeAttributes();
        this.edgeAttr = Cytoscape.getEdgeAttributes();
        InteractionsReader reader = new InteractionsReader("testData/galFiltered.sif");
        reader.read();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPassThrough() throws Exception {
        PassthroughMappingTest.assertNotNull(this.nodeAttr);
        Color color1 = new Color(100, 100, 100);
        Color color2 = new Color(200, 150, 0);
        this.nodeAttr.setAttribute("?", "Color", color1.getRed() + "," + color1.getGreen() + "," + color1.getBlue());
        this.nodeAttr.setAttribute("YNL050C", "Color", color2.getRed() + "," + color2.getGreen() + "," + color2.getBlue());
        this.nodeAttr.setAttribute("YIL061C", "Color", "300,-1,10");
        this.nodeAttr.setAttribute("?", "Node Size", "100");
        this.nodeAttr.setAttribute("YNL050C", "Node Size", "-10");
        this.edgeAttr.setAttribute("YNL216W (pd) YIL069C", "Width", "10");
        this.edgeAttr.setAttribute("YNL216W (pd) YAL038W", "Width", "abcd");
        PassThroughMapping pm = new PassThroughMapping(Color.class, "Color");
        Map<String, Object> bundle = CyAttributesUtils.getAttributes("?", this.nodeAttr);
        Object rangeVal = pm.calculateRangeValue(bundle);
        PassthroughMappingTest.assertNotNull(rangeVal);
        PassthroughMappingTest.assertEquals(rangeVal.getClass(), Color.class);
        PassthroughMappingTest.assertEquals(rangeVal, color1);
        bundle = CyAttributesUtils.getAttributes("YNL050C", this.nodeAttr);
        rangeVal = pm.calculateRangeValue(bundle);
        PassthroughMappingTest.assertNotNull(rangeVal);
        PassthroughMappingTest.assertEquals(rangeVal.getClass(), Color.class);
        PassthroughMappingTest.assertEquals(rangeVal, color2);
        bundle = CyAttributesUtils.getAttributes("YIL061C", this.nodeAttr);
        rangeVal = pm.calculateRangeValue(bundle);
        PassthroughMappingTest.assertNull(rangeVal);
        pm = new PassThroughMapping(Double.class, "Node Size");
        bundle = CyAttributesUtils.getAttributes("?", this.nodeAttr);
        rangeVal = pm.calculateRangeValue(bundle);
        PassthroughMappingTest.assertNotNull(rangeVal);
        PassthroughMappingTest.assertEquals(rangeVal.getClass(), Double.class);
        PassthroughMappingTest.assertEquals(rangeVal, 100.0);
        bundle = CyAttributesUtils.getAttributes("YNL050C", this.nodeAttr);
        rangeVal = pm.calculateRangeValue(bundle);
        PassthroughMappingTest.assertNotNull(rangeVal);
        PassthroughMappingTest.assertEquals(rangeVal.getClass(), Double.class);
        PassthroughMappingTest.assertEquals(-10.0, rangeVal);
        pm = new PassThroughMapping(Float.class, "Width");
        bundle = CyAttributesUtils.getAttributes("YNL216W (pd) YIL069C", this.edgeAttr);
        rangeVal = pm.calculateRangeValue(bundle);
        PassthroughMappingTest.assertNotNull(rangeVal);
        PassthroughMappingTest.assertEquals(rangeVal.getClass(), Float.class);
        PassthroughMappingTest.assertEquals(Float.valueOf(10.0f), rangeVal);
        bundle = CyAttributesUtils.getAttributes("YNL216W (pd) YAL038W", this.edgeAttr);
        rangeVal = pm.calculateRangeValue(bundle);
        PassthroughMappingTest.assertNull(rangeVal);
    }
}

