/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.logger.CyLogger;
import cytoscape.view.CyNetworkView;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.view.InternalFrameComponent;
import ding.view.DGraphView;
import ding.view.InnerCanvas;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.SwingPropertyChangeSupport;

public class NetworkViewManager
implements PropertyChangeListener,
InternalFrameListener,
WindowFocusListener,
ChangeListener {
    private static CyLogger logger = CyLogger.getLogger(NetworkViewManager.class);
    private JDesktopPane desktopPane;
    private Map<String, JInternalFrame> networkViewMap;
    private Map<JInternalFrame, String> componentMap;
    private Map<String, InternalFrameComponent> internalFrameComponentMap;
    protected final CytoscapeDesktop cytoscapeDesktop;
    protected final SwingPropertyChangeSupport pcs;
    protected int MINIMUM_WIN_WIDTH = 200;
    protected int MINIMUM_WIN_HEIGHT = 200;

    public NetworkViewManager(CytoscapeDesktop desktop, int view_type) {
        this(desktop);
    }

    public NetworkViewManager(CytoscapeDesktop desktop) {
        this.cytoscapeDesktop = desktop;
        this.desktopPane = new JDesktopPane();
        this.pcs = new SwingPropertyChangeSupport(this);
        Cytoscape.getPropertyChangeSupport().addPropertyChangeListener(this);
        this.networkViewMap = new HashMap<String, JInternalFrame>();
        this.componentMap = new HashMap<JInternalFrame, String>();
        this.internalFrameComponentMap = new HashMap<String, InternalFrameComponent>();
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }

    public JTabbedPane getTabbedPane() {
        return null;
    }

    public JDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    public InternalFrameComponent getInternalFrameComponent(CyNetworkView view) throws IllegalArgumentException {
        if (view == null) {
            throw new IllegalArgumentException("NetworkViewManager.getInternalFrameComponent(), argument is null");
        }
        return this.internalFrameComponentMap.get(view.getIdentifier());
    }

    public JInternalFrame getInternalFrame(CyNetworkView view) throws IllegalArgumentException {
        if (view == null) {
            throw new IllegalArgumentException("NetworkViewManager.getInternalFrame(), argument is null");
        }
        return this.networkViewMap.get(view.getIdentifier());
    }

    public void updateNetworkTitle(CyNetwork network) {
        JInternalFrame frame = this.networkViewMap.get(network.getIdentifier());
        if (frame != null) {
            frame.setTitle(network.getTitle());
            frame.repaint();
        }
    }

    public void updateNetworkTitle(CyNetwork network, String title) {
        JInternalFrame frame = this.networkViewMap.get(network.getIdentifier());
        if (frame != null) {
            frame.setTitle(title);
            frame.repaint();
        }
    }

    public void stateChanged(ChangeEvent e) {
    }

    public void internalFrameActivated(InternalFrameEvent e) {
        String network_id = this.componentMap.get(e.getInternalFrame());
        if (network_id == null) {
            return;
        }
        this.firePropertyChange("NETWORK_VIEW_FOCUSED", null, network_id);
    }

    public void internalFrameOpened(InternalFrameEvent e) {
        this.internalFrameActivated(e);
    }

    public void internalFrameClosed(InternalFrameEvent e) {
    }

    public void internalFrameClosing(InternalFrameEvent e) {
    }

    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    public void internalFrameIconified(InternalFrameEvent e) {
    }

    public void windowGainedFocus(WindowEvent e) {
    }

    public void windowLostFocus(WindowEvent e) {
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("NETWORK_VIEW_FOCUS".equals(e.getPropertyName())) {
            String network_id = (String)e.getNewValue();
            e = null;
            this.unsetFocus();
            this.setFocus(network_id);
            InnerCanvas canvas = ((DGraphView)((Object)Cytoscape.getCurrentNetworkView())).getCanvas();
            if (this.getDesktopPane() != null) {
                canvas.addTransferComponent(this.getDesktopPane());
            }
        } else if ("NETWORK_VIEW_CREATED".equals(e.getPropertyName())) {
            CyNetworkView new_view = (CyNetworkView)e.getNewValue();
            this.createContainer(new_view);
            e = null;
        } else if ("NETWORK_VIEW_DESTROYED".equals(e.getPropertyName())) {
            CyNetworkView view = (CyNetworkView)e.getNewValue();
            this.removeView(view);
            e = null;
        }
    }

    public void firePropertyChange(String property_type, Object old_value, Object new_value) {
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, property_type, old_value, new_value));
    }

    protected void unsetFocus() {
        for (JInternalFrame f : this.networkViewMap.values()) {
            try {
                f.setSelected(false);
            }
            catch (PropertyVetoException pve) {
                logger.info("NetworkViewManager: Couldn't unset focus for internal frame.");
            }
        }
    }

    protected void setFocus(String network_id) {
        if (this.networkViewMap.containsKey(network_id)) {
            try {
                this.networkViewMap.get(network_id).setIcon(false);
                this.networkViewMap.get(network_id).show();
                this.networkViewMap.get(network_id).setSelected(true);
            }
            catch (Exception e) {
                logger.warn("Network View unable to be focused");
            }
        }
    }

    protected void removeView(CyNetworkView view) {
        try {
            String targetID = view.getIdentifier();
            if (targetID != null && this.networkViewMap.get(targetID) != null) {
                this.networkViewMap.get(targetID).dispose();
                JInternalFrame target = this.networkViewMap.remove(targetID);
                target.removeAll();
                Object var3_4 = null;
            }
        }
        catch (Exception e) {
            logger.warn("Network View unable to be killed: " + view.getIdentifier(), e);
        }
        view = null;
    }

    protected void createContainer(final CyNetworkView view) {
        if (this.networkViewMap.containsKey(view.getNetwork().getIdentifier())) {
            return;
        }
        JInternalFrame iframe = new JInternalFrame(view.getTitle(), true, true, true, true);
        iframe.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
                Cytoscape.destroyNetworkView(view);
            }
        });
        this.desktopPane.add(iframe);
        if (view instanceof DGraphView) {
            InternalFrameComponent internalFrameComp = new InternalFrameComponent(iframe.getLayeredPane(), (DGraphView)((Object)view));
            iframe.getContentPane().add(internalFrameComp);
            this.internalFrameComponentMap.put(view.getNetwork().getIdentifier(), internalFrameComp);
        } else {
            logger.info("NetworkViewManager.createContainer() - DGraphView not found!");
            iframe.getContentPane().add(view.getComponent());
        }
        iframe.pack();
        int x = 0;
        int y = 0;
        JInternalFrame refFrame = null;
        JInternalFrame[] allFrames = this.desktopPane.getAllFrames();
        if (allFrames.length > 1) {
            refFrame = allFrames[0];
        }
        if (refFrame != null) {
            x = refFrame.getLocation().x + 20;
            y = refFrame.getLocation().y + 20;
        }
        if (x > this.desktopPane.getWidth() - this.MINIMUM_WIN_WIDTH) {
            x = this.desktopPane.getWidth() - this.MINIMUM_WIN_WIDTH;
        }
        if (y > this.desktopPane.getHeight() - this.MINIMUM_WIN_HEIGHT) {
            y = this.desktopPane.getHeight() - this.MINIMUM_WIN_HEIGHT;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        iframe.setBounds(x, y, 400, 400);
        try {
            String max = CytoscapeInit.getProperties().getProperty("maximizeViewOnCreate");
            if (max != null && Boolean.parseBoolean(max)) {
                iframe.setMaximum(true);
            }
        }
        catch (PropertyVetoException pve) {
            logger.warn("Unable to maximize internal frame: " + pve.getMessage());
        }
        iframe.setVisible(true);
        iframe.addInternalFrameListener(this);
        iframe.setResizable(true);
        this.networkViewMap.put(view.getNetwork().getIdentifier(), iframe);
        this.componentMap.put(iframe, view.getNetwork().getIdentifier());
        this.firePropertyChange("NETWORK_VIEW_FOCUSED", null, view.getNetwork().getIdentifier());
    }
}

