/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.logger.CyLogger;
import java.util.Properties;
import java.util.regex.Pattern;

public class PropUtil {
    private static CyLogger logger = CyLogger.getLogger(PropUtil.class);
    private static Pattern truePattern = Pattern.compile("^\\s*true\\s*$", 2);
    private static Pattern falsePattern = Pattern.compile("^\\s*false\\s*$", 2);
    private static Pattern yesPattern = Pattern.compile("^\\s*yes\\s*$", 2);
    private static Pattern noPattern = Pattern.compile("^\\s*no\\s*$", 2);

    private PropUtil() {
    }

    public static int getInt(Properties props, String key, int defaultValue) {
        String val = props.getProperty(key);
        if (val == null) {
            return defaultValue;
        }
        int ret = defaultValue;
        try {
            ret = Integer.parseInt(val);
        }
        catch (Exception e) {
            logger.warn("Property value for " + key + " must be an integer");
        }
        return ret;
    }

    public static float getFloat(Properties props, String key, float defaultValue) {
        String val = props.getProperty(key);
        if (val == null) {
            return defaultValue;
        }
        float ret = defaultValue;
        try {
            ret = Float.parseFloat(val);
        }
        catch (Exception e) {
            logger.warn("Property value for " + key + " must be a float");
        }
        return ret;
    }

    public static boolean getBoolean(Properties props, String key, boolean defaultValue) {
        String val = props.getProperty(key);
        if (val == null) {
            return defaultValue;
        }
        boolean ret = defaultValue;
        try {
            ret = truePattern.matcher(val).matches() || yesPattern.matcher(val).matches() ? true : (falsePattern.matcher(val).matches() || noPattern.matcher(val).matches() ? false : defaultValue);
        }
        catch (Exception e) {
            logger.warn("Property value for " + key + " must be a boolean");
        }
        return ret;
    }
}

