/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.AllTests;
import cytoscape.util.ColorUtil;
import cytoscape.util.Misc;
import java.awt.Color;
import java.util.Properties;
import java.util.Vector;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class MiscTest
extends TestCase {
    private boolean runAll = false;

    public MiscTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testParseRGBTest() throws Exception {
        AllTests.standardOut("testRGBParseText");
        Color result = ColorUtil.parseColorText("0,0,0");
        MiscTest.assertTrue(result.equals(Color.black));
        result = ColorUtil.parseColorText("27,39,121");
        MiscTest.assertTrue(result.getRed() == 27);
        MiscTest.assertTrue(result.getGreen() == 39);
        MiscTest.assertTrue(result.getBlue() == 121);
        result = ColorUtil.parseColorText(" 27 , 39 , 121 ");
        MiscTest.assertTrue(result.getRed() == 27);
        MiscTest.assertTrue(result.getGreen() == 39);
        MiscTest.assertTrue(result.getBlue() == 121);
        result = ColorUtil.parseColorText("255,255,255");
        MiscTest.assertTrue(result.equals(Color.white));
    }

    public void testParseList() throws Exception {
        AllTests.standardOut("testParseList");
        String delimiter = "::";
        String startToken = "(";
        String endToken = ")";
        String a = "abcd";
        String b = "efgh";
        String c = "dog";
        String d = "cat";
        StringBuffer sb = new StringBuffer();
        sb.append("  ");
        sb.append(startToken);
        sb.append(a + delimiter);
        sb.append(b + delimiter);
        sb.append(c + delimiter);
        sb.append(d);
        sb.append(endToken);
        sb.append("   ");
        String[] tokens = Misc.parseList(sb.toString(), startToken, endToken, delimiter);
        MiscTest.assertTrue(tokens.length == 4);
        MiscTest.assertTrue(tokens[0].equals(a));
        MiscTest.assertTrue(tokens[1].equals(b));
        MiscTest.assertTrue(tokens[2].equals(c));
        MiscTest.assertTrue(tokens[3].equals(d));
        a = "((abcd))";
        b = "ef()gh";
        c = "do))((g";
        d = "c*())*at";
        sb = new StringBuffer();
        sb.append("  ");
        sb.append(startToken);
        sb.append(a + delimiter);
        sb.append(b + delimiter);
        sb.append(c + delimiter);
        sb.append(d);
        sb.append(endToken);
        sb.append("  ");
        tokens = Misc.parseList(sb.toString(), startToken, endToken, delimiter);
        MiscTest.assertTrue(tokens.length == 4);
        MiscTest.assertTrue(tokens[0].equals(a));
        MiscTest.assertTrue(tokens[1].equals(b));
        MiscTest.assertTrue(tokens[2].equals(c));
        MiscTest.assertTrue(tokens[3].equals(d));
        a = "abcd))";
        b = "ef()gh";
        c = "do))((g";
        d = "c*())*at";
        sb = new StringBuffer();
        sb.append(a + delimiter);
        sb.append(b + delimiter);
        sb.append(c + delimiter);
        sb.append(d);
        sb.append(endToken);
        sb.append("   ");
        tokens = Misc.parseList(sb.toString(), startToken, endToken, delimiter);
        MiscTest.assertTrue(tokens.length == 1);
        a = "abcd))";
        b = "ef()gh";
        c = "do))((g";
        d = "c*())*at";
        sb = new StringBuffer();
        sb.append(startToken);
        sb.append(a + delimiter);
        sb.append(b + delimiter);
        sb.append(c + delimiter);
        sb.append(d);
        sb.append("   ");
        tokens = Misc.parseList(sb.toString(), startToken, endToken, delimiter);
        MiscTest.assertTrue(tokens.length == 1);
        a = "http://www.genome.ad.jp/dbget-bin/get_pathway?org_name=hsa&mapno=00600";
        b = "http://www.genome.ad.jp/dbget-bin/get_pathway?org_name=hsa&mapno=00562";
        c = "http://www.genome.ad.jp/dbget-bin/get_pathway?org_name=hsa&mapno=00500";
        d = "http://www.genome.ad.jp/dbget-bin/get_pathway?org_name=hsa&mapno=00860";
        String e = "http://www.genome.ad.jp/dbget-bin/get_pathway?org_name=hsa&mapno=00760";
        sb = new StringBuffer();
        sb.append(startToken);
        sb.append(a + delimiter);
        sb.append(b + delimiter);
        sb.append(c + delimiter);
        sb.append(d + delimiter);
        sb.append(e);
        sb.append(endToken);
        tokens = Misc.parseList(sb.toString(), startToken, endToken, delimiter);
        MiscTest.assertTrue(tokens.length == 5);
        MiscTest.assertTrue(tokens[0].equals(a));
        MiscTest.assertTrue(tokens[1].equals(b));
        MiscTest.assertTrue(tokens[2].equals(c));
        MiscTest.assertTrue(tokens[3].equals(d));
        MiscTest.assertTrue(tokens[4].equals(e));
    }

    public void testGetPropertyValues() throws Exception {
        AllTests.standardOut("testGetPropertyValues");
        Properties props = new Properties();
        props.put("dog", "dozer");
        props.put("cat", "(ernie::louie)");
        Vector dogs = Misc.getPropertyValues(props, "dog");
        MiscTest.assertTrue(dogs.size() == 1);
        Vector cats = Misc.getPropertyValues(props, "cat");
        MiscTest.assertTrue(cats.size() == 2);
        String[] catNames = cats.toArray(new String[0]);
        MiscTest.assertTrue(catNames.length == 2);
        MiscTest.assertTrue(catNames[0].equals("ernie"));
        MiscTest.assertTrue(catNames[1].equals("louie"));
    }

    public static void main(String[] args) {
        TestRunner.run(new TestSuite(MiscTest.class));
    }
}

