/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.task.ui;

import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.task.ui.JErrorPanel;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.ui.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class JTask
extends JDialog
implements TaskMonitor,
ActionListener {
    private static final long serialVersionUID = 333614801L;
    private JProgressBar pBar;
    private static final int TIME_INTERVAL = 500;
    private JLabel descriptionValue;
    private JTextArea statusValue;
    private JLabel timeRemainingValue;
    private JLabel timeElapsedValue;
    private JLabel progressValue;
    private Timer timer;
    private static final String ACTION_CANCEL = "CANCEL";
    private static final String ACTION_CLOSE = "CLOSE";
    private JButton cancelButton;
    private JButton closeButton;
    private Date startTime;
    private String taskTitle;
    private JTaskConfig config;
    private Task task;
    private JPanel progressPanel;
    private boolean haltRequested = false;
    private boolean errorOccurred = false;
    private long timeRemaining;

    public JTask(Task task, JTaskConfig config) {
        super((Frame)config.getOwner(), task.getTitle(), config.getModal());
        this.task = task;
        this.taskTitle = task.getTitle();
        this.config = config;
        this.init();
    }

    public void setPercentCompleted(final int percent) {
        if (!this.haltRequested) {
            if (percent < -1 || percent > 100) {
                throw new IllegalArgumentException("percent parameter is outside range:  [-1, 100]");
            }
            if (percent != this.pBar.getValue()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (percent == -1) {
                            JTask.this.pBar.setIndeterminate(true);
                        } else {
                            if (JTask.this.pBar.isIndeterminate()) {
                                JTask.this.pBar.setIndeterminate(false);
                            }
                            JTask.this.pBar.setValue(percent);
                        }
                    }
                });
            }
        }
    }

    public void setEstimatedTimeRemaining(final long time) {
        if (!this.haltRequested) {
            if (this.timeRemaining != time) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JTask.this.timeRemainingValue.setText(StringUtils.getTimeString(time));
                    }
                });
            }
            this.timeRemaining = time;
        }
    }

    public void setException(Throwable t, String userErrorMessage) {
        if (!this.haltRequested) {
            this.errorOccurred = true;
            this.stopTimer();
            this.showErrorPanel(t, userErrorMessage, null);
        }
    }

    public void setException(Throwable t, String userErrorMessage, String recoveryTip) throws IllegalThreadStateException {
        if (!this.haltRequested) {
            this.errorOccurred = true;
            this.stopTimer();
            this.showErrorPanel(t, userErrorMessage, recoveryTip);
        }
    }

    private void showErrorPanel(final Throwable t, final String userErrorMessage, final String recoveryTip) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Container c = JTask.this.getContentPane();
                JTask.this.closeButton.setVisible(false);
                JTask.this.cancelButton.setVisible(false);
                JTask.this.progressPanel.setVisible(false);
                JErrorPanel errorPanel = new JErrorPanel(JTask.this, t, userErrorMessage, recoveryTip);
                c.add((Component)errorPanel, "Center");
                JTask.this.config.setAutoDispose(false);
                JTask.this.pack();
                JTask.this.setTitle("An Error Has Occurred");
                if (!JTask.this.isShowing()) {
                    JTask.this.setVisible(true);
                }
            }
        });
    }

    public void setDone() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JTask.this.stopTimer();
                if (JTask.this.config.getAutoDispose()) {
                    JTask.this.dispose();
                } else {
                    JTask.this.setDefaultCloseOperation(2);
                    JTask.this.removeProgressBar();
                    JTask.this.cancelButton.setEnabled(false);
                    JTask.this.closeButton.setEnabled(true);
                    if (JTask.this.haltRequested) {
                        JTask.this.setCancelStatusMsg("Canceled by User");
                    }
                    JTask.this.pack();
                }
            }
        });
    }

    public void setCancel(boolean enable) {
        this.cancelButton.setEnabled(enable);
    }

    public void setStatus(final String message) {
        if (!this.haltRequested) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JTask.this.statusValue.setText(message);
                    JTask.this.pack();
                }
            });
        }
    }

    public boolean errorOccurred() {
        return this.errorOccurred;
    }

    public boolean haltRequested() {
        return this.haltRequested;
    }

    private void init() {
        this.setTitle(this.taskTitle);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.progressPanel = new JPanel(new GridBagLayout());
        this.progressPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int y = 0;
        this.addLabel("Description:  ", this.progressPanel, 0, y, 12, true);
        this.descriptionValue = this.addLabel(StringUtils.truncateOrPadString(this.taskTitle), this.progressPanel, 1, y, 18, true);
        this.addLabel("Status:  ", this.progressPanel, 0, ++y, 12, this.config.getStatusFlag());
        this.statusValue = this.addTextArea(StringUtils.truncateOrPadString("Starting..."), this.progressPanel, 1, y, 18, this.config.getStatusFlag());
        this.addLabel("Time Left:  ", this.progressPanel, 0, ++y, 12, this.config.getTimeRemainingFlag());
        this.timeRemainingValue = this.addLabel("", this.progressPanel, 1, y, 18, this.config.getTimeRemainingFlag());
        this.addLabel("Time Elapsed:  ", this.progressPanel, 0, ++y, 12, this.config.getTimeElapsedFlag());
        this.timeElapsedValue = this.addLabel(StringUtils.getTimeString(0L), this.progressPanel, 1, y, 18, this.config.getTimeElapsedFlag());
        this.progressValue = this.addLabel("Progress:  ", this.progressPanel, 0, ++y, 12, true);
        this.initProgressBar(this.progressPanel, y);
        container.add((Component)this.progressPanel, "Center");
        this.createFooter(container);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JTask.this.stopTimer();
            }
        });
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.config.getOwner());
        if (this.config.getTimeElapsedFlag()) {
            this.initTimer();
        }
    }

    private void createFooter(Container container) {
        JPanel footer = new JPanel();
        footer.setBorder(new EmptyBorder(5, 5, 5, 5));
        footer.setLayout(new BoxLayout(footer, 1));
        this.closeButton = new JButton("    Close    ");
        this.closeButton.setEnabled(false);
        this.closeButton.setActionCommand(ACTION_CLOSE);
        this.closeButton.addActionListener(this);
        this.cancelButton = new JButton("    Cancel   ");
        this.cancelButton.setActionCommand(ACTION_CANCEL);
        this.cancelButton.addActionListener(this);
        if (this.config.getCloseButtonFlag()) {
            footer.add(this.closeButton);
            footer.add(Box.createHorizontalGlue());
        }
        if (this.config.getCancelButtonFlag()) {
            footer.add(this.cancelButton);
        }
        container.add((Component)footer, "East");
    }

    private void initProgressBar(JPanel progressPanel, int y) {
        GridBagConstraints c = new GridBagConstraints();
        this.pBar = new JProgressBar();
        this.pBar.setIndeterminate(true);
        this.pBar.setMaximum(100);
        this.pBar.setValue(0);
        this.pBar.setBorder(new EmptyBorder(5, 0, 5, 0));
        this.pBar.setDoubleBuffered(true);
        c.gridx = 1;
        c.gridy = y;
        c.fill = 2;
        progressPanel.add((Component)this.pBar, c);
    }

    private JLabel addLabel(String text, JPanel panel, int gridx, int gridy, int alignment, boolean addToPanel) {
        JLabel label = new JLabel(text);
        label.setHorizontalAlignment(2);
        label.setBorder(new EmptyBorder(5, 5, 5, 5));
        label.setFont(new Font(null, 0, 13));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = gridx;
        c.gridy = gridy;
        c.anchor = alignment;
        if (addToPanel) {
            panel.add((Component)label, c);
        }
        return label;
    }

    private JTextArea addTextArea(String text, JPanel panel, int gridx, int gridy, int alignment, boolean addToPanel) {
        JTextArea textArea = new JTextArea(text, 1, 25);
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setBorder(new EmptyBorder(5, 5, 5, 5));
        textArea.setBackground((Color)UIManager.get("Label.background"));
        textArea.setForeground((Color)UIManager.get("Label.foreground"));
        textArea.setFont(new Font(null, 0, 13));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = gridx;
        c.gridy = gridy;
        c.anchor = alignment;
        if (addToPanel) {
            panel.add((Component)textArea, c);
        }
        return textArea;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() != null) {
            if (e.getActionCommand().equals(ACTION_CANCEL)) {
                this.haltRequested = true;
                this.cancelButton.setEnabled(false);
                this.setCancelStatusMsg("Canceling...");
                this.task.halt();
            } else if (e.getActionCommand().equals(ACTION_CLOSE)) {
                this.dispose();
            }
        }
    }

    private void initTimer() {
        this.startTime = new Date();
        this.timer = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Date currentTime = new Date();
                long timeElapsed = currentTime.getTime() - JTask.this.startTime.getTime();
                JTask.this.timeElapsedValue.setText(StringUtils.getTimeString(timeElapsed));
            }
        });
        this.timer.start();
    }

    private void stopTimer() {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    private void setCancelStatusMsg(String msg) {
        if (this.config.getStatusFlag()) {
            this.statusValue.setText(msg);
        } else {
            this.descriptionValue.setText(msg);
        }
    }

    private void removeProgressBar() {
        this.progressPanel.remove(this.pBar);
        this.progressPanel.remove(this.progressValue);
        this.progressPanel.validate();
    }
}

