/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.util;

import com.sun.glf.Composition;
import com.sun.glf.PaintProgressListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class CompositionComponent
extends JComponent {
    private BufferedImage offscreen;
    private boolean doScale = false;
    private Object scaleHint;
    private Dimension dim;
    private Composition composition;

    public BufferedImage getOffscreen() {
        BufferedImage bufferedImage = new BufferedImage(this.offscreen.getWidth(), this.offscreen.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)this.offscreen, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public CompositionComponent(Composition composition, boolean bl, Object object) {
        this.setComposition(composition);
        this.doScale = bl;
        this.scaleHint = object;
        if (object != null && object != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR && object != RenderingHints.VALUE_INTERPOLATION_BILINEAR && object != RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
            throw new IllegalArgumentException("Invalid scaleHint");
        }
    }

    public CompositionComponent(Composition composition) {
        this.setComposition(composition);
    }

    public synchronized void setComposition(Composition composition) {
        if (composition == null) {
            throw new IllegalArgumentException();
        }
        this.dim = composition.getSize();
        this.composition = composition;
        this.offscreen = null;
        this.setPreferredSize(this.dim);
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.offscreen == null) {
            this.prepareOffscreen();
        }
        Dimension dimension = this.getSize();
        Dimension dimension2 = (Dimension)this.dim.clone();
        if (this.doScale) {
            float f = (float)dimension.width / (float)this.dim.width;
            float f2 = (float)dimension.height / (float)this.dim.height;
            float f3 = Math.min(f, f2);
            dimension2.width = (int)((float)dimension2.width * f3);
            dimension2.height = (int)((float)dimension2.height * f3);
        }
        if (this.scaleHint != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.scaleHint);
        }
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        graphics2D.drawImage(this.offscreen, n, n2, dimension2.width, dimension2.height, null);
    }

    public void prepareOffscreen() {
        if (this.offscreen == null) {
            this.offscreen = new BufferedImage(this.dim.width, this.dim.height, 2);
            Graphics2D graphics2D = this.offscreen.createGraphics();
            this.composition.paint(graphics2D);
            this.composition = null;
        }
    }

    public static void main(String[] stringArray) {
        Composition composition = new Composition(){
            Color paint = new Color(174, 174, 232);

            public Dimension getSize() {
                return new Dimension(40, 40);
            }

            public void addPaintProgressListener(PaintProgressListener paintProgressListener) {
            }

            public void removePaintProgressListener(PaintProgressListener paintProgressListener) {
            }

            public void paint(Graphics2D graphics2D) {
                graphics2D.setPaint(this.paint);
                graphics2D.fillRect(0, 0, 40, 40);
                graphics2D.setPaint(Color.black);
                graphics2D.drawLine(0, 0, 40, 40);
                graphics2D.drawLine(0, 40, 40, 0);
            }
        };
        CompositionComponent compositionComponent = new CompositionComponent(composition);
        compositionComponent.setToolTipText("Square Shape, no scale");
        CompositionComponent compositionComponent2 = new CompositionComponent(composition, true, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        compositionComponent2.setToolTipText("Square Shape, scale, Nearest Neighbor interpolation");
        CompositionComponent compositionComponent3 = new CompositionComponent(composition, true, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        compositionComponent3.setToolTipText("Square Shape, scale, Bilinear interpolation");
        CompositionComponent compositionComponent4 = new CompositionComponent(composition, true, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        compositionComponent4.setToolTipText("Square Shape, scale, Bicubic interpolation");
        CompositionComponent compositionComponent5 = new CompositionComponent(composition, true, null);
        compositionComponent5.setToolTipText("Square Shape, scale, null interpolation (unspecified)");
        final Frame frame = new Frame("CompositionComponent Unit testing");
        frame.setLayout(new GridLayout(0, 1));
        frame.add(compositionComponent);
        frame.add(compositionComponent2);
        frame.add(compositionComponent3);
        frame.add(compositionComponent4);
        frame.add(compositionComponent5);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                frame.setVisible(false);
                frame.dispose();
                System.exit(0);
            }
        });
        frame.pack();
        frame.show();
    }
}

