/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.goodies;

import com.sun.glf.ImageLayer;
import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.goodies.DirectionalLight;
import com.sun.glf.goodies.ElevationMap;
import com.sun.glf.goodies.LightOp;
import com.sun.glf.goodies.LitSurfaceType;
import com.sun.glf.goodies.SpotLight;
import com.sun.glf.util.CompositionComponent;
import com.sun.glf.util.Toolbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JFrame;

public final class LitSurface {
    static final String ERROR_INVALID_AMBIANT_LIGHT = "Ambiant light should be positive";
    static final String ERROR_INVALID_DIFFUSION_FACTOR = "Diffusion factor should be between 0 and 1";
    static final String ERROR_INVALID_SPECULAR_FACTOR = "Specular factor should be between 0 and 1";
    static final String ERROR_INVALID_SPECULAR_EXPONENT = "Specular exponent should be two or more";
    private double Ia = 0.2;
    double ks = 1.0;
    double kd = 1.0;
    int ns = 2;
    ElevationMap elevationMap;
    private SpotLight[] warnLights;
    private DirectionalLight[] dirLights;
    private double[] IDir = new double[3];
    private boolean textured;
    static final String USAGE = "java com.sun.glf.goodies.LitSurface <textureFile>. Test Surface types";

    public LitSurface(double d) {
        this(d, 1.0, 1.0, 2, null);
    }

    public LitSurface(double d, double d2, double d3, int n, ElevationMap elevationMap) {
        this.setIa(d);
        this.setKd(d2);
        this.setKs(d3);
        this.setNs(n);
        this.setElevationMap(elevationMap);
    }

    public double getIa() {
        return this.Ia;
    }

    public void setIa(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(ERROR_INVALID_AMBIANT_LIGHT);
        }
        this.Ia = d;
    }

    public double getKd() {
        return this.kd;
    }

    public void setKd(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException(ERROR_INVALID_DIFFUSION_FACTOR);
        }
        this.kd = d;
    }

    public double getKs() {
        return this.ks;
    }

    public void setKs(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException(ERROR_INVALID_SPECULAR_FACTOR);
        }
        this.ks = d;
    }

    public int getNs() {
        return this.ns;
    }

    public void setNs(int n) {
        if (n < 2) {
            throw new IllegalArgumentException(ERROR_INVALID_SPECULAR_EXPONENT);
        }
        this.ns = n;
    }

    public LitSurface(double d, LitSurfaceType litSurfaceType, ElevationMap elevationMap) {
        if (d < 0.0 || litSurfaceType == null) {
            throw new IllegalArgumentException();
        }
        this.Ia = d;
        this.elevationMap = elevationMap;
        if (this.elevationMap != null) {
            this.textured = true;
        }
        this.kd = litSurfaceType.getKd();
        this.ks = litSurfaceType.getKs();
        this.ns = litSurfaceType.getNs();
    }

    public void setElevationMap(ElevationMap elevationMap) {
        this.elevationMap = elevationMap;
        this.textured = elevationMap != null;
    }

    public boolean isTextured() {
        return this.elevationMap != null;
    }

    public void addLight(DirectionalLight directionalLight) {
        Object[] objectArray;
        if (directionalLight == null) {
            throw new IllegalArgumentException();
        }
        if (this.dirLights != null) {
            objectArray = new DirectionalLight[this.dirLights.length + 1];
            System.arraycopy(this.dirLights, 0, objectArray, 0, this.dirLights.length);
            this.dirLights = objectArray;
        } else {
            this.dirLights = new DirectionalLight[1];
        }
        this.dirLights[this.dirLights.length - 1] = directionalLight;
        objectArray = new double[3];
        directionalLight.getIntensity(this, (double[])objectArray);
        this.IDir[0] = this.IDir[0] + objectArray[0];
        this.IDir[1] = this.IDir[1] + objectArray[1];
        this.IDir[2] = this.IDir[2] + objectArray[2];
    }

    public void addLight(SpotLight spotLight) {
        if (spotLight == null) {
            throw new IllegalArgumentException();
        }
        if (this.warnLights != null) {
            SpotLight[] spotLightArray = new SpotLight[this.warnLights.length + 1];
            System.arraycopy(this.warnLights, 0, spotLightArray, 0, this.warnLights.length);
            this.warnLights = spotLightArray;
        } else {
            this.warnLights = new SpotLight[1];
        }
        this.warnLights[this.warnLights.length - 1] = spotLight;
    }

    public void addLights(SpotLight[] spotLightArray) {
        int n;
        if (spotLightArray == null) {
            throw new IllegalArgumentException();
        }
        int n2 = n = this.warnLights != null ? this.warnLights.length : 0;
        if (this.warnLights != null) {
            SpotLight[] spotLightArray2 = new SpotLight[this.warnLights.length + spotLightArray.length];
            System.arraycopy(this.warnLights, 0, spotLightArray2, 0, this.warnLights.length);
            this.warnLights = spotLightArray2;
        } else {
            this.warnLights = new SpotLight[spotLightArray.length];
        }
        System.arraycopy(spotLightArray, 0, this.warnLights, n, spotLightArray.length);
    }

    public void removeAllLights() {
        this.warnLights = null;
        this.dirLights = null;
        this.IDir[0] = 0.0;
        this.IDir[1] = 0.0;
        this.IDir[2] = 0.0;
    }

    public final void getFlatIntensity(int n, int n2, double[] dArray, double[] dArray2) {
        dArray[0] = this.Ia;
        dArray[1] = this.Ia;
        dArray[2] = this.Ia;
        int n3 = this.warnLights != null ? this.warnLights.length : 0;
        for (int i = 0; i < n3; ++i) {
            this.warnLights[i].getFlatIntensity(this, n, n2, dArray2);
            dArray[0] = dArray[0] + dArray2[0];
            dArray[1] = dArray[1] + dArray2[1];
            dArray[2] = dArray[2] + dArray2[2];
        }
        dArray[0] = dArray[0] + this.IDir[0];
        dArray[1] = dArray[1] + this.IDir[1];
        dArray[2] = dArray[2] + this.IDir[2];
    }

    public final void getTexturedIntensity(int n, int n2, double[] dArray, double[] dArray2) {
        int n3;
        dArray[0] = this.Ia;
        dArray[1] = this.Ia;
        dArray[2] = this.Ia;
        int n4 = this.warnLights != null ? this.warnLights.length : 0;
        for (n3 = 0; n3 < n4; ++n3) {
            this.warnLights[n3].getTexturedIntensity(this, n, n2, dArray2);
            dArray[0] = dArray[0] + dArray2[0];
            dArray[1] = dArray[1] + dArray2[1];
            dArray[2] = dArray[2] + dArray2[2];
        }
        n3 = this.dirLights != null ? this.dirLights.length : 0;
        for (int i = 0; i < n3; ++i) {
            this.dirLights[i].getTexturedIntensity(this, n, n2, dArray2);
            dArray[0] = dArray[0] + dArray2[0];
            dArray[1] = dArray[1] + dArray2[1];
            dArray[2] = dArray[2] + dArray2[2];
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println(USAGE);
            System.exit(0);
        }
        String string = stringArray[0];
        JFrame jFrame = new JFrame("LitSurface unit testing");
        jFrame.getContentPane().setLayout(new GridLayout(0, 1));
        Component component = new Component(){};
        BufferedImage bufferedImage = Toolbox.loadImage(string, 1);
        ElevationMap elevationMap = new ElevationMap(bufferedImage, true, 10);
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setPaint(new Color(153, 153, 204));
        graphics2D.fillRect(0, 0, n, n2);
        LitSurface litSurface = new LitSurface(0.2, LitSurfaceType.NORMAL, elevationMap);
        LitSurface litSurface2 = new LitSurface(0.2, LitSurfaceType.MATTE, elevationMap);
        LitSurface litSurface3 = new LitSurface(0.2, LitSurfaceType.SHINY, elevationMap);
        LitSurface litSurface4 = new LitSurface(0.2, LitSurfaceType.METALLIC, elevationMap);
        litSurface.addLight(new DirectionalLight(new double[]{-40.0, -40.0, 40.0}, 1.0, Color.white));
        litSurface2.addLight(new DirectionalLight(new double[]{-40.0, -40.0, 40.0}, 1.0, Color.white));
        litSurface3.addLight(new DirectionalLight(new double[]{-40.0, -40.0, 40.0}, 1.0, Color.white));
        litSurface4.addLight(new DirectionalLight(new double[]{-40.0, -40.0, 40.0}, 1.0, Color.white));
        long l = System.currentTimeMillis();
        BufferedImage bufferedImage3 = new LightOp(litSurface).filter(bufferedImage2, null);
        System.out.println("Surface processing took : " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        BufferedImage bufferedImage4 = new LightOp(litSurface2).filter(bufferedImage2, null);
        System.out.println("Surface processing took : " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        BufferedImage bufferedImage5 = new LightOp(litSurface3).filter(bufferedImage2, null);
        System.out.println("Surface processing took : " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        BufferedImage bufferedImage6 = new LightOp(litSurface4).filter(bufferedImage2, null);
        System.out.println("Surface processing took : " + (System.currentTimeMillis() - l));
        jFrame.getContentPane().add(LitSurface.makeNewComponent(bufferedImage3, "Default surface settings"));
        jFrame.getContentPane().add(LitSurface.makeNewComponent(bufferedImage4, "Matt surface"));
        jFrame.getContentPane().add(LitSurface.makeNewComponent(bufferedImage5, "Shiny surface"));
        jFrame.getContentPane().add(LitSurface.makeNewComponent(bufferedImage6, "Metallic surface"));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private static JComponent makeNewComponent(Image image, String string) {
        Dimension dimension = new Dimension(image.getWidth(null), image.getHeight(null));
        LayerComposition layerComposition = new LayerComposition(dimension);
        ImageLayer imageLayer = new ImageLayer(layerComposition, image, null);
        layerComposition.setLayers(new Layer[]{imageLayer});
        CompositionComponent compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText(string);
        return compositionComponent;
    }
}

