/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.ComponentTuple;
import com.install4j.api.formcomponents.FormComponent;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.beans.formcomponents.FormEnvironmentImpl;
import com.install4j.runtime.beans.screens.components.ScrollablePanel;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.FormComponentBeanConfig;
import com.install4j.runtime.installer.config.FormComponentProvider;
import com.install4j.runtime.installer.frontend.ComponentTupleImpl;
import com.install4j.runtime.installer.frontend.GUIHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FormPanel
extends JPanel {
    private static final int[][] ANCHOR_MATRIX = new int[][]{{18, 11, 12}, {17, 10, 13}, {16, 15, 14}};
    private List formComponentConfigs;
    private Context context;
    private boolean banner;
    private Screen screen;
    private JScrollPane scpComponents;
    protected JPanel componentsPanel;
    private Set initializedComponents = new HashSet();
    private FormEnvironment formEnvironment;

    public FormPanel(List list, Context context, boolean bl, Screen screen) {
        this.formComponentConfigs = list;
        this.context = context;
        this.banner = bl;
        this.screen = screen;
        this.setupControls();
        this.setupComponent();
    }

    public FormEnvironment getFormEnvironment() {
        return this.formEnvironment;
    }

    public Screen getScreen() {
        return this.screen;
    }

    protected List getFormComponentConfigs() {
        return this.formComponentConfigs;
    }

    public void previous() {
        Iterator iterator = this.formComponentConfigs.iterator();
        while (iterator.hasNext()) {
            FormComponentProvider formComponentProvider = (FormComponentProvider)iterator.next();
            if (!formComponentProvider.isResetInitOnPrevious()) continue;
            this.initializedComponents.remove(formComponentProvider.getFormComponent());
        }
    }

    public boolean checkCompleted() {
        Iterator iterator = this.formComponentConfigs.iterator();
        while (iterator.hasNext()) {
            FormComponentProvider formComponentProvider = (FormComponentProvider)iterator.next();
            if (formComponentProvider.getFormComponent().checkCompleted()) continue;
            return false;
        }
        return true;
    }

    public void willActivate() {
        this.initializeComponents();
        Iterator iterator = this.formComponentConfigs.iterator();
        while (iterator.hasNext()) {
            FormComponentProvider formComponentProvider = (FormComponentProvider)iterator.next();
            formComponentProvider.getFormComponent().formWillActivate();
        }
    }

    public void activated() {
        Iterator iterator = this.formComponentConfigs.iterator();
        while (iterator.hasNext()) {
            FormComponentProvider formComponentProvider = (FormComponentProvider)iterator.next();
            formComponentProvider.getFormComponent().formActivated();
        }
    }

    public void deactivated() {
        Iterator iterator = this.formComponentConfigs.iterator();
        while (iterator.hasNext()) {
            FormComponentProvider formComponentProvider = (FormComponentProvider)iterator.next();
            formComponentProvider.getFormComponent().formDeactivated();
        }
    }

    public boolean handleUnattended() {
        this.initializeComponents();
        Iterator iterator = this.formComponentConfigs.iterator();
        while (iterator.hasNext()) {
            FormComponentProvider formComponentProvider = (FormComponentProvider)iterator.next();
            if (formComponentProvider.getFormComponent().handleUnattended()) continue;
            return false;
        }
        return this.checkCompleted();
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        this.initializeComponents();
        do {
            Iterator iterator = this.formComponentConfigs.iterator();
            while (iterator.hasNext()) {
                FormComponentProvider formComponentProvider = (FormComponentProvider)iterator.next();
                FormComponent formComponent = formComponentProvider.getFormComponent();
                if (!formComponent.isVisible() || !formComponent.isEnabled() || formComponent.handleConsole(console)) continue;
                return false;
            }
        } while (!this.checkCompleted());
        return true;
    }

    protected void initializeComponents() {
        Iterator iterator = this.formComponentConfigs.iterator();
        while (iterator.hasNext()) {
            FormComponentProvider formComponentProvider = (FormComponentProvider)iterator.next();
            FormComponent formComponent = formComponentProvider.getFormComponent();
            if (this.initializedComponents.contains(formComponent)) continue;
            this.initializeComponent(formComponent, formComponentProvider);
            this.initializedComponents.add(formComponent);
        }
    }

    protected void initializeComponent(FormComponent formComponent, FormComponentProvider formComponentProvider) {
        formComponent.initalize();
        Object[] objectArray = formComponent.getConfigurationObjectClass() != null ? new Object[]{formComponent.getConfigurationObject(), this.formEnvironment} : new Object[]{this.formEnvironment};
        if (this.context != null && this.context instanceof ContextImpl) {
            ((ContextImpl)this.context).runBooleanScript(((FormComponentBeanConfig)formComponentProvider).getInitClassName(), formComponent, objectArray);
        }
    }

    private void setupControls() {
        this.componentsPanel = new ScrollablePanel();
        this.scpComponents = new JScrollPane(this.componentsPanel);
        this.scpComponents.setHorizontalScrollBarPolicy(31);
        if (this.banner) {
            this.componentsPanel.setBackground(Color.white);
            this.scpComponents.getViewport().setBackground(Color.white);
        } else if (!GUIHelper.isGtkLaF()) {
            this.scpComponents.getViewport().setBackground(this.componentsPanel.getBackground());
        } else {
            this.scpComponents.getViewport().setOpaque(false);
        }
        this.scpComponents.setViewportBorder(null);
        this.scpComponents.setBorder(null);
    }

    private void setupComponent() {
        String[] stringArray;
        FormComponent[] formComponentArray;
        this.setLayout(new BorderLayout());
        this.componentsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.formEnvironment = this.createFormEnvironment(new FormComponent[0], new String[0], new ComponentTuple[0]);
        ArrayList<FormComponent> arrayList = new ArrayList<FormComponent>(this.formComponentConfigs.size());
        ArrayList<String> arrayList2 = new ArrayList<String>(this.formComponentConfigs.size());
        ArrayList<String[]> arrayList3 = new ArrayList<String[]>(this.formComponentConfigs.size());
        Iterator iterator = this.formComponentConfigs.iterator();
        while (iterator.hasNext()) {
            formComponentArray = (FormComponent[])iterator.next();
            stringArray = this.addFormComponent((FormComponentProvider)formComponentArray, gridBagConstraints);
            arrayList.add(formComponentArray.getFormComponent());
            arrayList2.add(formComponentArray.getId());
            arrayList3.add(stringArray);
            if (!this.banner) continue;
            this.makeTransparent(stringArray.getLeftComponent());
            this.makeTransparent(stringArray.getCenterComponent());
            this.makeTransparent(stringArray.getRightComponent());
        }
        formComponentArray = arrayList.toArray(new FormComponent[arrayList.size()]);
        stringArray = arrayList2.toArray(new String[arrayList2.size()]);
        ComponentTuple[] componentTupleArray = arrayList3.toArray(new ComponentTuple[arrayList3.size()]);
        this.formEnvironment = this.createFormEnvironment(formComponentArray, stringArray, componentTupleArray);
        for (int i = 0; i < formComponentArray.length; ++i) {
            formComponentArray[i].setFormEnvironment(this.formEnvironment);
        }
        this.add((Component)this.scpComponents, "Center");
    }

    private void makeTransparent(JComponent jComponent) {
        if (jComponent != null) {
            jComponent.setOpaque(false);
        }
    }

    protected FormEnvironmentImpl createFormEnvironment(FormComponent[] formComponentArray, String[] stringArray, ComponentTuple[] componentTupleArray) {
        return new FormEnvironmentImpl(this, formComponentArray, stringArray, componentTupleArray);
    }

    private ComponentTuple addFormComponent(FormComponentProvider formComponentProvider, GridBagConstraints gridBagConstraints) {
        FormComponent formComponent = formComponentProvider.getFormComponent();
        formComponent.setContext(this.context);
        formComponent.setFormEnvironment(this.formEnvironment);
        JComponent jComponent = formComponent.createLeftComponent();
        JComponent jComponent2 = formComponent.createCenterComponent();
        JComponent jComponent3 = formComponent.createRightComponent();
        gridBagConstraints.insets.top = formComponentProvider.getInsetTop();
        gridBagConstraints.insets.bottom = formComponentProvider.getInsetBottom();
        gridBagConstraints.insets.left = formComponentProvider.getInsetLeft();
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        if (jComponent != null) {
            gridBagConstraints.anchor = this.getAnchor(jComponent);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            this.componentsPanel.add((Component)jComponent, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets.left = 0;
        } else {
            ++gridBagConstraints.gridwidth;
        }
        if (jComponent3 == null) {
            ++gridBagConstraints.gridwidth;
            gridBagConstraints.insets.right = formComponentProvider.getInsetRight();
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = formComponent.isFillCenterHorizontal() ? 2 : 0;
        gridBagConstraints.anchor = this.getAnchor(jComponent2);
        this.componentsPanel.add((Component)jComponent2, gridBagConstraints);
        if (jComponent3 != null) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = this.getAnchor(jComponent3);
            gridBagConstraints.insets.right = formComponentProvider.getInsetRight();
            gridBagConstraints.insets.left = 0;
            this.componentsPanel.add((Component)jComponent3, gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        return new ComponentTupleImpl(jComponent, jComponent2, jComponent3);
    }

    private int getAnchor(JComponent jComponent) {
        float f = jComponent.getAlignmentY();
        int n = f < 0.5f ? 0 : (f > 0.5f ? 2 : 1);
        float f2 = jComponent.getAlignmentX();
        int n2 = f2 < 0.5f ? 0 : (f > 0.5f ? 2 : 1);
        return ANCHOR_MATRIX[n][n2];
    }
}

