\name{externalize}
\alias{externalize}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
create R package with decomposable smlSet representation
}
\description{
create R package with decomposable smlSet representation
}
\usage{
externalize(smlSet, 
  packname, 
  author = "Replace Me <auth@a.b.com>", 
  maintainer = "Replace Me <repl@a.b.com>")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{smlSet}{
instance of \code{\link[GGBase]{smlSet-class}}
}
  \item{packname}{
arbitrary string naming the package that will hold the
externalized representation -- this should not coincide with
the name of any installed package, as such would be overwritten
}
  \item{author}{
string that should be a valid Author: entry for  a DESCRIPTION file
}
  \item{maintainer}{
string that should be a valid Maintainer: entry for  a DESCRIPTION file
}
}
\details{
Each \code{\link[snpStats]{SnpMatrix-class}} instance in the
\code{smlEnv} slot of \code{smlSet} is written to disk
in a folder inst/parts of the source package generated by this
function.  The \code{\link[Biobase]{ExpressionSet-class}} instance
in the \code{smlSet} is isolated and saved as \code{eset.rda} 
to the data folder
of the source package generated by this function.  

\code{\link[GGBase]{getSS}} will construct an \code{\link[GGBase]{smlSet-class}}
instance with the expression data and selected chromosomes
}
\value{
instance of \code{\link[GGBase]{smlSet-class}}
}
%\references{
%%% ~put references to the literature/web site here ~
%}
\author{
VJ Carey <stvjc@channing.harvard.edu>
}
\note{
The purpose is to avoid loading very large objects as
SNP panels grow into the millions.  With this approach 
in-memory images can be chromosome-size, or smaller if desired,
depending on the structure of \code{smList(smlSet)}.
}

\seealso{
\code{\link[GGBase]{getSS}}
}
\examples{
\dontrun{
 if (!exists("hmceuB36.2021")) hmceuB36.2021 <- getSS("GGtools", c("20", "21"))
 owd = getwd()
 setwd(tempdir())
 externalize(hmceuB36.2021, "hmdemo")
 system("tar zcvf hmdemo.tar.gz hmdemo")
 install.packages("hmdemo.tar.gz", repos=NULL)
 library(hmdemo)
 getSS("hmdemo", "20")
 setwd(owd)
 }
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ models }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
