## --------------------------------------------------------------------------
library(CATALYST)
data(raw_data)
ff <- concatFCS(raw_data)

## ----fig.width=17, fig.height=8.5------------------------------------------
normCytof(x=ff, y="dvs", k=300)

## ----results='hide'--------------------------------------------------------
data(sample_ff)
sample_ff

## --------------------------------------------------------------------------
data(sample_key)
sample_key

## ----messages=FALSE--------------------------------------------------------
re <- assignPrelim(x=sample_ff, y=sample_key, verbose=FALSE)
re

## --------------------------------------------------------------------------
re <- estCutoffs(x=re, verbose=FALSE)
re

## ----results = 'hide'------------------------------------------------------
# use global separation cutoff
applyCutoffs(x=re, sep_cutoffs=0.35)

# use population-specific cutoffs
re <- applyCutoffs(x=re)

## ----results='hide'--------------------------------------------------------
outFCS(x=re)

## ----fig.width=9, fig.height=5---------------------------------------------
plotYields(x=re, which="C1")

## ----fig.width=9, fig.height=5---------------------------------------------
plotYields(x=re, which=0, legend=FALSE)

## ----fig.width=9, fig.height=5---------------------------------------------
# event plot for unassigned events
plotEvents(x=re, which=0, n_events=1000)

## ----fig.width=9, fig.height=5---------------------------------------------
plotEvents(x=re, which="D1", n_events=500)

## ----warning=FALSE, fig.width=6, fig.height=6.5----------------------------
plotMahal(x=re, which="A5")

## --------------------------------------------------------------------------
# get single-stained control samples
data(ss_exp)
# specify mass channels stained for
bc_ms <- c(139, 141:156, 158:176)
# debarcode
re <- assignPrelim(x=ss_exp, y=bc_ms, verbose=FALSE)
re <- estCutoffs(x=re, verbose=FALSE)
re <- applyCutoffs(x=re)
# compute spillover matrix
spillMat <- computeSpillmat(x=re)

## ----fig.width=8, fig.height=6---------------------------------------------
# estimate trim value minimizing sum of squared 
# population- and channel-wise medians upon compensation
estTrim(x=re, min=0.05, max=0.11)

## ----fig.width=7.5, fig.height=7.5-----------------------------------------
spillMat <- computeSpillmat(x=re, trim=0.08)
plotSpillmat(bc_ms=bc_ms, SM=spillMat) 

## --------------------------------------------------------------------------
data(mp_cells)
comped_cells <- compCytof(x=mp_cells, y=spillMat)

## ----echo=FALSE, message=FALSE, results='hide'-----------------------------
cf <- 20
ss_t <- asinh(exprs(ss_exp)/cf)
ss_comped_t <- asinh(exprs(compCytof(ss_exp, spillMat))/cf)
cells_t <- asinh(exprs(mp_cells)/cf)
comped_cells_t <- asinh(exprs(comped_cells)/cf)

## ----echo=FALSE, fig.width=9, fig.height=9---------------------------------
par(mfrow=c(2,2), pty="s")
which <- c("La139Di", "Gd155Di")
#which <- c("Yb171Di", "Yb172Di")
which <- c("Er167Di", "Er168Di")
cols <- colorRampPalette(rev(RColorBrewer::brewer.pal(10, "Spectral")))
bw <- .25; n <- 64
smoothScatter(ss_t[, which],           nrpoints=0, nbin=n, bandwidth=bw, colramp=cols, main='Single stains')
smoothScatter(ss_comped_t[, which],    nrpoints=0, nbin=n, bandwidth=bw, colramp=cols, main='Compensated')
smoothScatter(cells_t[, which],        nrpoints=0, nbin=n, bandwidth=bw, colramp=cols, main='Multiplexed cells')
smoothScatter(comped_cells_t[, which], nrpoints=0, nbin=n, bandwidth=bw, colramp=cols, main='Compensated')

