/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.RoleDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class CreateRoleConstantAction
extends DDLConstantAction {
    private String roleName;

    public CreateRoleConstantAction(String string) {
        this.roleName = string;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        String string = languageConnectionContext.getAuthorizationId();
        dataDictionary.startWriting(languageConnectionContext);
        RoleDescriptor roleDescriptor = dataDictionary.getRoleDefinitionDescriptor(this.roleName);
        if (roleDescriptor != null) {
            throw StandardException.newException("X0Y68.S", (Object)"Role", (Object)this.roleName);
        }
        roleDescriptor = dataDescriptorGenerator.newRoleDescriptor(dataDictionary.getUUIDFactory().createUUID(), this.roleName, string, "_SYSTEM", true, true);
        dataDictionary.addDescriptor(roleDescriptor, null, 19, false, transactionController);
    }

    public String toString() {
        return "CREATE ROLE " + this.roleName;
    }
}

