/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ResultColumnList;

public class ReplaceAggregatesWithCRVisitor
implements Visitor {
    private ResultColumnList rcl;
    private Class skipOverClass;
    private int tableNumber;

    public ReplaceAggregatesWithCRVisitor(ResultColumnList resultColumnList, int n) {
        this(resultColumnList, n, null);
    }

    public ReplaceAggregatesWithCRVisitor(ResultColumnList resultColumnList, int n, Class clazz) {
        this.rcl = resultColumnList;
        this.tableNumber = n;
        this.skipOverClass = clazz;
    }

    public ReplaceAggregatesWithCRVisitor(ResultColumnList resultColumnList, Class clazz) {
        this.rcl = resultColumnList;
        this.skipOverClass = clazz;
    }

    public Visitable visit(Visitable visitable) throws StandardException {
        if (visitable instanceof AggregateNode) {
            visitable = ((AggregateNode)visitable).replaceAggregatesWithColumnReferences(this.rcl, this.tableNumber);
        }
        return visitable;
    }

    public boolean skipChildren(Visitable visitable) {
        return this.skipOverClass == null ? false : this.skipOverClass.isInstance(visitable);
    }

    public boolean stopTraversal() {
        return false;
    }
}

