/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.load.ColumnInfo;
import org.apache.derby.impl.load.ControlInfo;
import org.apache.derby.impl.load.ImportBlob;
import org.apache.derby.impl.load.ImportClob;
import org.apache.derby.impl.load.ImportReadData;
import org.apache.derby.impl.load.ImportResultSetMetaData;
import org.apache.derby.impl.load.LoadError;
import org.apache.derby.vti.VTITemplate;

abstract class ImportAbstract
extends VTITemplate {
    ControlInfo controlFileReader;
    ImportReadData importReadData;
    String[] columnNames;
    int numberOfColumns;
    int[] columnWidths;
    int lineNumber = 0;
    String[] nextRow;
    ResultSetMetaData importResultSetMetaData;
    int noOfColumnsExpected;
    protected boolean lobsInExtFile = false;
    String tableColumnTypesStr;
    int[] tableColumnTypes;
    private boolean wasNull;
    static final String COLUMNNAMEPREFIX = "COLUMN";

    ImportAbstract() {
    }

    abstract ImportReadData getImportReadData() throws Exception;

    void doAllTheWork() throws Exception {
        this.importReadData = this.getImportReadData();
        this.numberOfColumns = this.importReadData.getNumberOfColumns();
        if (this.numberOfColumns == 0) {
            this.numberOfColumns = this.noOfColumnsExpected;
        }
        this.columnWidths = this.controlFileReader.getColumnWidths();
        this.columnNames = new String[this.numberOfColumns];
        this.loadColumnNames();
        this.nextRow = new String[this.numberOfColumns];
        this.tableColumnTypes = ColumnInfo.getExpectedVtiColumnTypes(this.tableColumnTypesStr, this.numberOfColumns);
        this.importResultSetMetaData = new ImportResultSetMetaData(this.numberOfColumns, this.columnNames, this.columnWidths, this.tableColumnTypes);
    }

    void loadColumnNames() {
        for (int i = 1; i <= this.numberOfColumns; ++i) {
            this.columnNames[i - 1] = COLUMNNAMEPREFIX + i;
        }
    }

    public ResultSetMetaData getMetaData() {
        return this.importResultSetMetaData;
    }

    public int getRow() throws SQLException {
        return this.importReadData.getCurrentRowNumber();
    }

    public int getCurrentLineNumber() {
        return this.lineNumber;
    }

    public boolean next() throws SQLException {
        try {
            ++this.lineNumber;
            return this.importReadData.readNextRow(this.nextRow);
        }
        catch (Exception exception) {
            throw this.importError(exception);
        }
    }

    public void close() throws SQLException {
        try {
            if (this.importReadData != null) {
                this.importReadData.closeStream();
            }
        }
        catch (Exception exception) {
            throw LoadError.unexpectedError(exception);
        }
    }

    public boolean wasNull() {
        return this.wasNull;
    }

    public String getString(int n) throws SQLException {
        if (n <= this.numberOfColumns) {
            String string = this.nextRow[n - 1];
            if (this.isColumnInExtFile(n)) {
                string = this.importReadData.getClobColumnFromExtFileAsString(string, n);
            }
            this.wasNull = string == null;
            return string;
        }
        throw LoadError.invalidColumnNumber(this.numberOfColumns);
    }

    public Clob getClob(int n) throws SQLException {
        Clob clob = null;
        if (this.lobsInExtFile) {
            clob = this.importReadData.getClobColumnFromExtFile(this.nextRow[n - 1], n);
        } else {
            String string = this.nextRow[n - 1];
            if (string != null) {
                clob = new ImportClob(string);
            }
        }
        this.wasNull = clob == null;
        return clob;
    }

    public Blob getBlob(int n) throws SQLException {
        Blob blob = null;
        if (this.lobsInExtFile) {
            blob = this.importReadData.getBlobColumnFromExtFile(this.nextRow[n - 1], n);
        } else {
            String string = this.nextRow[n - 1];
            byte[] byArray = null;
            if (string != null) {
                byArray = StringUtil.fromHexString(string, 0, string.length());
                if (byArray == null) {
                    throw PublicAPI.wrapStandardException(StandardException.newException("XIE0N.S", string));
                }
                blob = new ImportBlob(byArray);
            }
        }
        this.wasNull = blob == null;
        return blob;
    }

    public byte[] getBytes(int n) throws SQLException {
        String string = this.nextRow[n - 1];
        this.wasNull = string == null;
        byte[] byArray = null;
        if (string != null && (byArray = StringUtil.fromHexString(string, 0, string.length())) == null) {
            throw PublicAPI.wrapStandardException(StandardException.newException("XIE0N.S", string));
        }
        return byArray;
    }

    private boolean isColumnInExtFile(int n) {
        return this.lobsInExtFile && (this.tableColumnTypes[n - 1] == 2004 || this.tableColumnTypes[n - 1] == 2005);
    }

    public SQLException importError(Exception exception) {
        Exception exception2 = null;
        if (this.importReadData != null) {
            try {
                this.importReadData.closeStream();
            }
            catch (Exception exception3) {
                exception2 = exception3;
            }
        }
        SQLException sQLException = LoadError.unexpectedError(exception);
        if (exception2 != null) {
            sQLException.setNextException(LoadError.unexpectedError(exception2));
        }
        return sQLException;
    }
}

