/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.file;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.file.IDMappingReader;
import org.bridgedb.impl.InternalUtils;

public class IDMappingReaderFromDelimitedReader
implements IDMappingReader {
    private boolean transitivity;
    private List<DataSource> dataSources;
    private Map<Xref, Set<Xref>> mapXrefs;
    private List<String> data;
    protected String regExDataSourceDelimiter;
    protected String regExIDDelimiter;
    protected boolean dsValid;
    protected boolean idMappingValid;

    public IDMappingReaderFromDelimitedReader(Reader reader, String regExDataSourceDelimiter, String regExIDDelimiter, boolean transitivity) throws IDMapperException {
        if (reader == null || regExDataSourceDelimiter == null) {
            throw new IllegalArgumentException("reader and regExDataSourceDelimiter cannot be null");
        }
        this.readData(reader);
        this.regExDataSourceDelimiter = regExDataSourceDelimiter;
        this.regExIDDelimiter = regExIDDelimiter;
        this.transitivity = transitivity;
        this.dsValid = false;
        this.idMappingValid = false;
    }

    protected void readData(Reader reader) throws IDMapperException {
        this.data = new ArrayList<String>();
        BufferedReader bfdrd = new BufferedReader(reader);
        try {
            String line = bfdrd.readLine();
            while (line != null) {
                this.data.add(line);
                line = bfdrd.readLine();
            }
            bfdrd.close();
            reader.close();
        }
        catch (IOException e) {
            throw new IDMapperException(e);
        }
    }

    public void setTransitivity(boolean transitivity) {
        this.transitivity = transitivity;
    }

    public boolean getTransitivity() {
        return this.transitivity;
    }

    public void setDataSources(List<DataSource> dataSources) {
        this.dataSources = dataSources;
        this.dsValid = dataSources == null;
    }

    @Override
    public Set<DataSource> getDataSources() throws IDMapperException {
        if (!this.dsValid) {
            try {
                this.readDataSources();
            }
            catch (IOException ex) {
                throw new IDMapperException(ex);
            }
        }
        return new HashSet<DataSource>(this.dataSources);
    }

    @Override
    public Map<Xref, Set<Xref>> getIDMappings() throws IDMapperException {
        if (!this.idMappingValid) {
            try {
                this.readIDMappings();
            }
            catch (IOException ex) {
                throw new IDMapperException(ex);
            }
        }
        return this.mapXrefs;
    }

    protected void readDataSources() throws IOException {
        this.dataSources = new ArrayList<DataSource>();
        if (this.data.isEmpty()) {
            System.err.println("Empty file");
            return;
        }
        String[] types = this.data.get(0).split(this.regExDataSourceDelimiter);
        int nds = types.length;
        DataSource[] dss = new DataSource[nds];
        for (int ids = 0; ids < nds; ++ids) {
            String type = types[ids];
            if (type.length() == 0) {
                return;
            }
            dss[ids] = DataSource.getByFullName(type);
            this.dataSources.add(dss[ids]);
        }
        this.dsValid = true;
    }

    protected void readIDMappings() throws IOException {
        this.mapXrefs = new HashMap<Xref, Set<Xref>>();
        int nline = this.data.size();
        if (nline < 2) {
            System.err.println("No ID mapping data");
            return;
        }
        for (int iline = 1; iline < nline; ++iline) {
            String line = this.data.get(iline);
            String[] strs = line.split(this.regExDataSourceDelimiter);
            if (strs.length > this.dataSources.size()) {
                System.err.println("The number of ID is larger than the number of types at row " + iline);
            }
            int n = Math.min(strs.length, this.dataSources.size());
            HashSet<Xref> xrefs = new HashSet<Xref>();
            for (int i = 0; i < n; ++i) {
                String[] ids;
                String str = strs[i];
                if (this.regExIDDelimiter == null) {
                    xrefs.add(new Xref(str, this.dataSources.get(i)));
                    continue;
                }
                for (String id : ids = str.split(this.regExIDDelimiter)) {
                    xrefs.add(new Xref(id, this.dataSources.get(i)));
                }
            }
            this.addIDMapping(xrefs);
        }
        this.idMappingValid = true;
    }

    protected void addIDMapping(Set<Xref> xrefs) {
        if (xrefs == null) {
            throw new NullPointerException();
        }
        if (this.transitivity) {
            HashSet<Xref> newXrefs = new HashSet<Xref>(xrefs);
            for (Xref xref : xrefs) {
                Set<Xref> oldXrefs = this.mapXrefs.get(xref);
                if (oldXrefs == null) continue;
                newXrefs.addAll(oldXrefs);
            }
            for (Xref xref : newXrefs) {
                this.mapXrefs.put(xref, newXrefs);
            }
        } else {
            for (Xref ref : xrefs) {
                InternalUtils.multiMapPutAll(this.mapXrefs, ref, xrefs);
            }
        }
    }
}

