/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.rdb.SimpleGdb;
import org.bridgedb.rdb.SimpleGdbImplCommon;

class SimpleGdbImpl2
extends SimpleGdbImplCommon {
    private static final int GDB_COMPAT_VERSION = 2;
    private final SimpleGdb.QueryLifeCycle qBackpage = new SimpleGdb.QueryLifeCycle("SELECT backpageText FROM datanode  WHERE id = ? AND code = ?");
    private static final Map<String, String> ATTRIBUTES_FROM_BACKPAGE = new HashMap<String, String>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getBpInfo(Xref ref) throws IDMapperException {
        SimpleGdb.QueryLifeCycle pst;
        SimpleGdb.QueryLifeCycle queryLifeCycle = pst = this.qBackpage;
        synchronized (queryLifeCycle) {
            try {
                pst.init();
                pst.setString(1, ref.getId());
                pst.setString(2, ref.getDataSource().getSystemCode());
                ResultSet r = pst.executeQuery();
                String result = null;
                if (r.next()) {
                    result = r.getString(1);
                }
                String string = result;
                return string;
            }
            catch (SQLException e) {
                throw new IDMapperException(e);
            }
            finally {
                pst.cleanup();
            }
        }
    }

    public SimpleGdbImpl2(String dbName, String connectionString) throws IDMapperException {
        super(dbName, connectionString);
        if (dbName == null) {
            throw new NullPointerException();
        }
        this.checkSchemaVersion();
    }

    private void checkSchemaVersion() throws IDMapperException {
        int version = 0;
        try {
            ResultSet r = this.getConnection().createStatement().executeQuery("SELECT schemaversion FROM info");
            if (r.next()) {
                version = r.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (version != 2) {
            throw new IDMapperException("Implementation and schema version mismatch");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<String> getAttributes(Xref ref, String attrname) throws IDMapperException {
        Pattern pat;
        Matcher matcher;
        String bpInfo;
        HashSet<String> result = new HashSet<String>();
        SimpleGdb.QueryLifeCycle pst = this.qAttribute;
        if (ATTRIBUTES_FROM_BACKPAGE.containsKey(attrname) && (bpInfo = this.getBpInfo(ref)) != null && (matcher = (pat = Pattern.compile(ATTRIBUTES_FROM_BACKPAGE.get(attrname))).matcher(bpInfo)).find()) {
            result.add(matcher.group(1));
        }
        SimpleGdb.QueryLifeCycle queryLifeCycle = pst;
        synchronized (queryLifeCycle) {
            try {
                pst.init();
                pst.setString(1, ref.getId());
                pst.setString(2, ref.getDataSource().getSystemCode());
                pst.setString(3, attrname);
                ResultSet r = pst.executeQuery();
                if (r.next()) {
                    result.add(r.getString(1));
                }
                HashSet<String> hashSet = result;
                return hashSet;
            }
            catch (SQLException e) {
                throw new IDMapperException("Xref:" + ref + ", Attribute: " + attrname, e);
            }
            finally {
                pst.cleanup();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Set<String>> getAttributes(Xref ref) throws IDMapperException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        SimpleGdb.QueryLifeCycle pst = this.qAllAttributes;
        String bpInfo = this.getBpInfo(ref);
        if (bpInfo != null) {
            for (String attrname : ATTRIBUTES_FROM_BACKPAGE.keySet()) {
                Pattern pat = Pattern.compile(ATTRIBUTES_FROM_BACKPAGE.get(attrname));
                Matcher matcher = pat.matcher(bpInfo);
                if (!matcher.find()) continue;
                HashSet<String> attrSet = new HashSet<String>();
                attrSet.add(matcher.group(1));
                result.put(attrname, attrSet);
            }
        }
        SimpleGdb.QueryLifeCycle queryLifeCycle = pst;
        synchronized (queryLifeCycle) {
            try {
                pst.init();
                pst.setString(1, ref.getId());
                pst.setString(2, ref.getDataSource().getSystemCode());
                ResultSet r = pst.executeQuery();
                if (r.next()) {
                    String key = r.getString(1);
                    String value = r.getString(2);
                    if (result.containsKey(key)) {
                        ((Set)result.get(key)).add(value);
                    } else {
                        HashSet<String> valueSet = new HashSet<String>();
                        valueSet.add(value);
                        result.put(key, valueSet);
                    }
                }
                HashMap<String, Set<String>> hashMap = result;
                return hashMap;
            }
            catch (SQLException e) {
                throw new IDMapperException("Xref:" + ref, e);
            }
            finally {
                pst.cleanup();
            }
        }
    }

    static {
        ATTRIBUTES_FROM_BACKPAGE.put("Chromosome", "<TH>Chr:<TH>([^<]*)<");
        ATTRIBUTES_FROM_BACKPAGE.put("Description", "<TH>Description:<TH>([^<]*)<");
        ATTRIBUTES_FROM_BACKPAGE.put("Synonyms", "<TH>Synonyms:<TH>([^<]*)<");
        ATTRIBUTES_FROM_BACKPAGE.put("Symbol", "<TH>(?:Gene Symbol|Metabolite):<TH>([^<]*)<");
        ATTRIBUTES_FROM_BACKPAGE.put("BrutoFormula", "<TH>Bruto Formula:<TH>([^<]*)<");
    }
}

