/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapperCapabilities;
import org.bridgedb.IDMapperException;

public abstract class AbstractIDMapperCapabilities
implements IDMapperCapabilities {
    private final Set<DataSource> supportedDataSources;
    private final Map<String, String> properties;
    private final boolean freeSearchSupported;

    @Override
    public Set<String> getKeys() {
        return this.properties.keySet();
    }

    @Override
    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public AbstractIDMapperCapabilities(Set<DataSource> supportedDataSources, boolean freeSearchSupported, Map<String, String> props) {
        this.supportedDataSources = supportedDataSources;
        this.freeSearchSupported = freeSearchSupported;
        this.properties = props == null ? Collections.emptyMap() : props;
    }

    @Override
    public Set<DataSource> getSupportedSrcDataSources() throws IDMapperException {
        return this.supportedDataSources;
    }

    @Override
    public Set<DataSource> getSupportedTgtDataSources() throws IDMapperException {
        return this.supportedDataSources;
    }

    @Override
    public boolean isMappingSupported(DataSource src, DataSource tgt) throws IDMapperException {
        return this.getSupportedSrcDataSources().contains(src) && this.getSupportedTgtDataSources().contains(tgt);
    }

    @Override
    public boolean isFreeSearchSupported() {
        return this.freeSearchSupported;
    }
}

