/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import weka.gui.visualize.PrintableComponent;

public class ResultHistoryPanel
extends JPanel {
    protected JTextComponent m_SingleText;
    protected String m_SingleName;
    protected DefaultListModel m_Model = new DefaultListModel();
    protected JList m_List = new JList(this.m_Model);
    protected Hashtable m_Results = new Hashtable();
    protected Hashtable m_FramedOutput = new Hashtable();
    protected Hashtable m_Objs = new Hashtable();
    protected boolean m_HandleRightClicks = true;
    protected PrintableComponent m_Printer = null;

    public ResultHistoryPanel(JTextComponent jTextComponent) {
        this.m_SingleText = jTextComponent;
        if (jTextComponent != null) {
            this.m_Printer = new PrintableComponent(this.m_SingleText);
        }
        this.m_List.addMouseListener(new RMouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if ((mouseEvent.getModifiers() & 0x10) == 16) {
                    int n2;
                    if ((mouseEvent.getModifiers() & 0x40) == 0 && (mouseEvent.getModifiers() & 0x80) == 0 && (n2 = ResultHistoryPanel.this.m_List.locationToIndex(mouseEvent.getPoint())) != -1 && ResultHistoryPanel.this.m_SingleText != null) {
                        ResultHistoryPanel.this.setSingle((String)ResultHistoryPanel.this.m_Model.elementAt(n2));
                    }
                } else if (ResultHistoryPanel.this.m_HandleRightClicks && (n = ResultHistoryPanel.this.m_List.locationToIndex(mouseEvent.getPoint())) != -1) {
                    String string = (String)ResultHistoryPanel.this.m_Model.elementAt(n);
                    ResultHistoryPanel.this.openFrame(string);
                }
            }
        });
        this.m_List.addKeyListener(new RKeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                int n;
                if (keyEvent.getKeyCode() == 127 && (n = ResultHistoryPanel.this.m_List.getSelectedIndex()) != -1) {
                    ResultHistoryPanel.this.removeResult((String)ResultHistoryPanel.this.m_Model.elementAt(n));
                }
            }
        });
        this.m_List.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    for (int i = listSelectionEvent.getFirstIndex(); i <= listSelectionEvent.getLastIndex(); ++i) {
                        if (!listSelectionModel.isSelectedIndex(i)) continue;
                        if (i == -1 || ResultHistoryPanel.this.m_SingleText == null) break;
                        ResultHistoryPanel.this.setSingle((String)ResultHistoryPanel.this.m_Model.elementAt(i));
                        break;
                    }
                }
            }
        });
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.m_List);
        jScrollPane.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            public void stateChanged(ChangeEvent changeEvent) {
                JViewport jViewport = (JViewport)changeEvent.getSource();
                int n = jViewport.getViewSize().height;
                if (n != this.lastHeight) {
                    this.lastHeight = n;
                    int n2 = n - jViewport.getExtentSize().height;
                    jViewport.setViewPosition(new Point(0, n2));
                }
            }
        });
        this.add((Component)jScrollPane, "Center");
    }

    public void addResult(String string, StringBuffer stringBuffer) {
        this.m_Model.addElement(string);
        this.m_Results.put(string, stringBuffer);
    }

    public void removeResult(String string) {
        StringBuffer stringBuffer = (StringBuffer)this.m_Results.get(string);
        if (stringBuffer != null) {
            this.m_Results.remove(string);
            this.m_Model.removeElement(string);
            this.m_Objs.remove(string);
            System.gc();
        }
    }

    public void addObject(String string, Object object) {
        this.m_Objs.put(string, object);
    }

    public Object getNamedObject(String string) {
        Object var2_2 = null;
        var2_2 = this.m_Objs.get(string);
        return var2_2;
    }

    public Object getSelectedObject() {
        Object var1_1 = null;
        int n = this.m_List.getSelectedIndex();
        if (n != -1) {
            String string = (String)this.m_Model.elementAt(n);
            var1_1 = this.m_Objs.get(string);
        }
        return var1_1;
    }

    public StringBuffer getNamedBuffer(String string) {
        StringBuffer stringBuffer = null;
        stringBuffer = (StringBuffer)this.m_Results.get(string);
        return stringBuffer;
    }

    public StringBuffer getSelectedBuffer() {
        StringBuffer stringBuffer = null;
        int n = this.m_List.getSelectedIndex();
        if (n != -1) {
            String string = (String)this.m_Model.elementAt(n);
            stringBuffer = (StringBuffer)this.m_Results.get(string);
        }
        return stringBuffer;
    }

    public String getSelectedName() {
        int n = this.m_List.getSelectedIndex();
        if (n != -1) {
            return (String)this.m_Model.elementAt(n);
        }
        return null;
    }

    public String getNameAtIndex(int n) {
        if (n != -1) {
            return (String)this.m_Model.elementAt(n);
        }
        return null;
    }

    public void setSingle(String string) {
        StringBuffer stringBuffer = (StringBuffer)this.m_Results.get(string);
        if (stringBuffer != null) {
            this.m_SingleName = string;
            this.m_SingleText.setText(stringBuffer.toString());
            this.m_List.setSelectedValue(string, true);
        }
    }

    public void openFrame(String string) {
        StringBuffer stringBuffer = (StringBuffer)this.m_Results.get(string);
        JTextComponent jTextComponent = (JTextComponent)this.m_FramedOutput.get(string);
        if (stringBuffer != null && jTextComponent == null) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jTextArea.setFont(new Font("Monospaced", 0, 12));
            jTextArea.setEditable(false);
            jTextArea.setText(stringBuffer.toString());
            this.m_FramedOutput.put(string, jTextArea);
            final JFrame jFrame = new JFrame(string);
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    ResultHistoryPanel.this.m_FramedOutput.remove(jFrame.getTitle());
                    jFrame.dispose();
                }
            });
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)new JScrollPane(jTextArea), "Center");
            jFrame.pack();
            jFrame.setSize(450, 350);
            jFrame.setVisible(true);
        }
    }

    public void updateResult(String string) {
        JTextComponent jTextComponent;
        StringBuffer stringBuffer = (StringBuffer)this.m_Results.get(string);
        if (stringBuffer == null) {
            return;
        }
        if (this.m_SingleName == string) {
            this.m_SingleText.setText(stringBuffer.toString());
        }
        if ((jTextComponent = (JTextComponent)this.m_FramedOutput.get(string)) != null) {
            jTextComponent.setText(stringBuffer.toString());
        }
    }

    public ListSelectionModel getSelectionModel() {
        return this.m_List.getSelectionModel();
    }

    public JList getList() {
        return this.m_List;
    }

    public void setHandleRightClicks(boolean bl) {
        this.m_HandleRightClicks = bl;
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame("Weka Explorer: Classifier");
            jFrame.getContentPane().setLayout(new BorderLayout());
            ResultHistoryPanel resultHistoryPanel = new ResultHistoryPanel(null);
            resultHistoryPanel.addResult("blah", new StringBuffer("Nothing to see here"));
            resultHistoryPanel.addResult("blah1", new StringBuffer("Nothing to see here1"));
            resultHistoryPanel.addResult("blah2", new StringBuffer("Nothing to see here2"));
            resultHistoryPanel.addResult("blah3", new StringBuffer("Nothing to see here3"));
            jFrame.getContentPane().add((Component)resultHistoryPanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    public static class RKeyAdapter
    extends KeyAdapter
    implements Serializable {
    }

    public static class RMouseAdapter
    extends MouseAdapter
    implements Serializable {
    }
}

