/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.experiment.CSVResultListener;
import weka.experiment.CrossValidationResultProducer;
import weka.experiment.DatabaseResultListener;
import weka.experiment.DatabaseUtils;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;

public class DatabaseResultProducer
extends DatabaseResultListener
implements ResultProducer,
OptionHandler,
AdditionalMeasureProducer {
    protected Instances m_Instances;
    protected ResultListener m_ResultListener = new CSVResultListener();
    protected ResultProducer m_ResultProducer = new CrossValidationResultProducer();
    protected String[] m_AdditionalMeasures = null;

    public String globalInfo() {
        return "Examines a database and extracts out the results produced by the specified ResultProducer and submits them to the specified ResultListener. If a result needs to be generated, the ResultProducer is used to obtain the result.";
    }

    public void doRunKeys(int n) throws Exception {
        if (this.m_ResultProducer == null) {
            throw new Exception("No ResultProducer set");
        }
        if (this.m_ResultListener == null) {
            throw new Exception("No ResultListener set");
        }
        if (this.m_Instances == null) {
            throw new Exception("No Instances set");
        }
        this.m_ResultProducer.setResultListener(this);
        this.m_ResultProducer.setInstances(this.m_Instances);
        this.m_ResultProducer.doRunKeys(n);
    }

    public void doRun(int n) throws Exception {
        if (this.m_ResultProducer == null) {
            throw new Exception("No ResultProducer set");
        }
        if (this.m_ResultListener == null) {
            throw new Exception("No ResultListener set");
        }
        if (this.m_Instances == null) {
            throw new Exception("No Instances set");
        }
        this.m_ResultProducer.setResultListener(this);
        this.m_ResultProducer.setInstances(this.m_Instances);
        this.m_ResultProducer.doRun(n);
    }

    public void preProcess(ResultProducer resultProducer) throws Exception {
        super.preProcess(resultProducer);
        if (this.m_ResultListener == null) {
            throw new Exception("No ResultListener set");
        }
        this.m_ResultListener.preProcess(this);
    }

    public void postProcess(ResultProducer resultProducer) throws Exception {
        super.postProcess(resultProducer);
        this.m_ResultListener.postProcess(this);
    }

    public void preProcess() throws Exception {
        if (this.m_ResultProducer == null) {
            throw new Exception("No ResultProducer set");
        }
        this.m_ResultProducer.setResultListener(this);
        this.m_ResultProducer.preProcess();
    }

    public void postProcess() throws Exception {
        this.m_ResultProducer.postProcess();
    }

    public void acceptResult(ResultProducer resultProducer, Object[] objectArray, Object[] objectArray2) throws Exception {
        if (this.m_ResultProducer != resultProducer) {
            throw new Error("Unrecognized ResultProducer sending results!!");
        }
        boolean bl = this.m_ResultListener.isResultRequired(this, objectArray);
        boolean bl2 = super.isResultRequired(resultProducer, objectArray);
        if (bl2 && objectArray2 != null) {
            super.acceptResult(resultProducer, objectArray, objectArray2);
        }
        if (bl) {
            this.m_ResultListener.acceptResult(this, objectArray, objectArray2);
        }
    }

    public boolean isResultRequired(ResultProducer resultProducer, Object[] objectArray) throws Exception {
        if (this.m_ResultProducer != resultProducer) {
            throw new Error("Unrecognized ResultProducer sending results!!");
        }
        boolean bl = this.m_ResultListener.isResultRequired(this, objectArray);
        boolean bl2 = super.isResultRequired(resultProducer, objectArray);
        if (!bl2 && bl) {
            Object[] objectArray2 = this.getResultFromTable(this.m_ResultsTableName, resultProducer, objectArray);
            System.err.println("Got result from database: " + DatabaseUtils.arrayToString(objectArray2));
            this.m_ResultListener.acceptResult(this, objectArray, objectArray2);
            return false;
        }
        return bl || bl2;
    }

    public String[] getKeyNames() throws Exception {
        return this.m_ResultProducer.getKeyNames();
    }

    public Object[] getKeyTypes() throws Exception {
        return this.m_ResultProducer.getKeyTypes();
    }

    public String[] getResultNames() throws Exception {
        return this.m_ResultProducer.getResultNames();
    }

    public Object[] getResultTypes() throws Exception {
        return this.m_ResultProducer.getResultTypes();
    }

    public String getCompatibilityState() {
        String string = "";
        string = this.m_ResultProducer == null ? string + "<null ResultProducer>" : string + "-W " + this.m_ResultProducer.getClass().getName();
        string = string + " -- " + this.m_ResultProducer.getCompatibilityState();
        return string.trim();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tThe name of the database field to cache over.\n\teg: \"Fold\" (default none)", "F", 1, "-F <field name>"));
        vector.addElement(new Option("\tThe full class name of a ResultProducer.\n\teg: weka.experiment.CrossValidationResultProducer", "W", 1, "-W <class name>"));
        if (this.m_ResultProducer != null && this.m_ResultProducer instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to result producer " + this.m_ResultProducer.getClass().getName() + ":"));
            Enumeration enumeration = ((OptionHandler)((Object)this.m_ResultProducer)).listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setCacheKeyName(Utils.getOption('F', stringArray));
        String string = Utils.getOption('W', stringArray);
        if (string.length() == 0) {
            throw new Exception("A ResultProducer must be specified with the -W option.");
        }
        this.setResultProducer((ResultProducer)Utils.forName(ResultProducer.class, string, null));
        if (this.getResultProducer() instanceof OptionHandler) {
            ((OptionHandler)((Object)this.getResultProducer())).setOptions(Utils.partitionOptions(stringArray));
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{};
        if (this.m_ResultProducer != null && this.m_ResultProducer instanceof OptionHandler) {
            stringArray = ((OptionHandler)((Object)this.m_ResultProducer)).getOptions();
        }
        String[] stringArray2 = new String[stringArray.length + 8];
        int n = 0;
        if (!this.getCacheKeyName().equals("")) {
            stringArray2[n++] = "-F";
            stringArray2[n++] = this.getCacheKeyName();
        }
        if (this.getResultProducer() != null) {
            stringArray2[n++] = "-W";
            stringArray2[n++] = this.getResultProducer().getClass().getName();
        }
        stringArray2[n++] = "--";
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public void setAdditionalMeasures(String[] stringArray) {
        this.m_AdditionalMeasures = stringArray;
        if (this.m_ResultProducer != null) {
            System.err.println("DatabaseResultProducer: setting additional measures for ResultProducer");
            this.m_ResultProducer.setAdditionalMeasures(this.m_AdditionalMeasures);
        }
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>();
        if (this.m_ResultProducer instanceof AdditionalMeasureProducer) {
            Enumeration enumeration = ((AdditionalMeasureProducer)((Object)this.m_ResultProducer)).enumerateMeasures();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                vector.addElement(string);
            }
        }
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (this.m_ResultProducer instanceof AdditionalMeasureProducer) {
            return ((AdditionalMeasureProducer)((Object)this.m_ResultProducer)).getMeasure(string);
        }
        throw new IllegalArgumentException("DatabaseResultProducer: Can't return value for : " + string + ". " + this.m_ResultProducer.getClass().getName() + " " + "is not an AdditionalMeasureProducer");
    }

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
    }

    public void setResultListener(ResultListener resultListener) {
        this.m_ResultListener = resultListener;
    }

    public String resultProducerTipText() {
        return "Set the result producer to use. If some results are not found in the source database then this result producer is used to generate them.";
    }

    public ResultProducer getResultProducer() {
        return this.m_ResultProducer;
    }

    public void setResultProducer(ResultProducer resultProducer) {
        this.m_ResultProducer = resultProducer;
    }

    public String toString() {
        String string = "DatabaseResultProducer: ";
        string = string + this.getCompatibilityState();
        string = this.m_Instances == null ? string + ": <null Instances>" : string + ": " + Utils.backQuoteChars(this.m_Instances.relationName());
        return string;
    }
}

