/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Drawable;
import weka.core.Instances;
import weka.gui.Logger;
import weka.gui.beans.BatchClassifierEvent;
import weka.gui.beans.BatchClassifierListener;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.GraphEvent;
import weka.gui.beans.GraphListener;
import weka.gui.beans.IncrementalClassifierEvent;
import weka.gui.beans.IncrementalClassifierListener;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TextEvent;
import weka.gui.beans.TextListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.beans.WekaWrapper;

public class Classifier
extends JPanel
implements BeanCommon,
Visible,
WekaWrapper,
EventConstraints,
Serializable,
UserRequestAcceptor,
TrainingSetListener,
TestSetListener,
InstanceListener {
    private static final long serialVersionUID = 659603893917736008L;
    protected BeanVisual m_visual = new BeanVisual("Classifier", "weka/gui/beans/icons/DefaultClassifier.gif", "weka/gui/beans/icons/DefaultClassifier_animated.gif");
    private static int IDLE = 0;
    private static int BUILDING_MODEL = 1;
    private static int CLASSIFYING = 2;
    private int m_state = IDLE;
    private Thread m_buildThread = null;
    protected String m_globalInfo;
    private Hashtable m_listenees = new Hashtable();
    private Vector m_batchClassifierListeners = new Vector();
    private Vector m_incrementalClassifierListeners = new Vector();
    private Vector m_graphListeners = new Vector();
    private Vector m_textListeners = new Vector();
    private Instances m_trainingSet;
    private transient Instances m_testingSet;
    private weka.classifiers.Classifier m_Classifier = new ZeroR();
    private IncrementalClassifierEvent m_ie = new IncrementalClassifierEvent(this);
    private boolean m_updateIncrementalClassifier = true;
    private transient Logger m_log = null;
    private InstanceEvent m_incrementalEvent;
    private Double m_dummy = new Double(0.0);

    public String globalInfo() {
        return this.m_globalInfo;
    }

    public Classifier() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.setClassifier(this.m_Classifier);
    }

    public void setClassifier(weka.classifiers.Classifier classifier) {
        boolean bl = true;
        if (classifier.getClass().getName().compareTo(this.m_Classifier.getClass().getName()) == 0) {
            bl = false;
        } else {
            this.m_trainingSet = null;
        }
        this.m_Classifier = classifier;
        String string = classifier.getClass().toString();
        string = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (bl && !this.m_visual.loadIcons("weka/gui/beans/icons/" + string + ".gif", "weka/gui/beans/icons/" + string + "_animated.gif")) {
            this.useDefaultVisual();
        }
        this.m_visual.setText(string);
        if (!(this.m_Classifier instanceof UpdateableClassifier) && this.m_listenees.containsKey("instance") && this.m_log != null) {
            this.m_log.logMessage("WARNING : " + this.m_Classifier.getClass().getName() + " is not an incremental classifier (Classifier)");
        }
        this.m_globalInfo = KnowledgeFlowApp.getGlobalInfo(this.m_Classifier);
    }

    public boolean hasIncomingStreamInstances() {
        if (this.m_listenees.size() == 0) {
            return false;
        }
        return this.m_listenees.containsKey("instance");
    }

    public boolean hasIncomingBatchInstances() {
        if (this.m_listenees.size() == 0) {
            return false;
        }
        return this.m_listenees.containsKey("trainingSet") || this.m_listenees.containsKey("testSet");
    }

    public weka.classifiers.Classifier getClassifier() {
        return this.m_Classifier;
    }

    public void setWrappedAlgorithm(Object object) {
        if (!(object instanceof weka.classifiers.Classifier)) {
            throw new IllegalArgumentException(object.getClass() + " : incorrect " + "type of algorithm (Classifier)");
        }
        this.setClassifier((weka.classifiers.Classifier)object);
    }

    public Object getWrappedAlgorithm() {
        return this.getClassifier();
    }

    public boolean getUpdateIncrementalClassifier() {
        return this.m_updateIncrementalClassifier;
    }

    public void setUpdateIncrementalClassifier(boolean bl) {
        this.m_updateIncrementalClassifier = bl;
    }

    public void acceptInstance(InstanceEvent instanceEvent) {
        this.m_incrementalEvent = instanceEvent;
        this.handleIncrementalEvent();
    }

    private void handleIncrementalEvent() {
        if (this.m_buildThread != null) {
            String string = "Classifier is currently batch training!";
            if (this.m_log != null) {
                this.m_log.logMessage(string);
            } else {
                System.err.println(string);
            }
            return;
        }
        if (this.m_incrementalEvent.getStatus() == 0) {
            Instances instances = this.m_incrementalEvent.getStructure();
            if (instances.classIndex() < 0) {
                instances.setClassIndex(instances.numAttributes() - 1);
            }
            try {
                if (this.m_trainingSet == null || !instances.equalHeaders(this.m_trainingSet)) {
                    if (!(this.m_Classifier instanceof UpdateableClassifier)) {
                        if (this.m_log != null) {
                            String string = this.m_trainingSet == null ? "ERROR : " + this.m_Classifier.getClass().getName() + " has not been batch " + "trained; can't process instance events." : "ERROR : instance event's structure is different from the data that was used to batch train this classifier; can't continue.";
                            this.m_log.logMessage(string);
                        }
                        return;
                    }
                    if (this.m_trainingSet != null && !instances.equalHeaders(this.m_trainingSet)) {
                        if (this.m_log != null) {
                            this.m_log.logMessage("Warning : structure of instance events differ from data used in batch training this classifier. Resetting classifier...");
                        }
                        this.m_trainingSet = null;
                    }
                    if (this.m_trainingSet == null) {
                        this.m_trainingSet = new Instances(instances, 0);
                        this.m_Classifier.buildClassifier(this.m_trainingSet);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.err.println("NOTIFYING NEW BATCH");
            this.m_ie.setStructure(instances);
            this.m_ie.setClassifier(this.m_Classifier);
            this.notifyIncrementalClassifierListeners(this.m_ie);
            return;
        }
        if (this.m_trainingSet == null) {
            return;
        }
        try {
            int n = 1;
            if (this.m_incrementalEvent.getStatus() == 2) {
                n = 2;
            }
            this.m_ie.setStatus(n);
            this.m_ie.setClassifier(this.m_Classifier);
            this.m_ie.setCurrentInstance(this.m_incrementalEvent.getInstance());
            this.notifyIncrementalClassifierListeners(this.m_ie);
            if (this.m_Classifier instanceof UpdateableClassifier && this.m_updateIncrementalClassifier && !this.m_incrementalEvent.getInstance().isMissing(this.m_incrementalEvent.getInstance().dataset().classIndex())) {
                ((UpdateableClassifier)((Object)this.m_Classifier)).updateClassifier(this.m_incrementalEvent.getInstance());
            }
            if (this.m_incrementalEvent.getStatus() == 2 && this.m_textListeners.size() > 0) {
                String string = this.m_Classifier.toString();
                String string2 = this.m_Classifier.getClass().getName();
                string2 = string2.substring(string2.lastIndexOf(46) + 1, string2.length());
                string = "=== Classifier model ===\n\nScheme:   " + string2 + "\n" + "Relation: " + this.m_trainingSet.relationName() + "\n\n" + string;
                string2 = "Model: " + string2;
                TextEvent textEvent = new TextEvent(this, string, string2);
                this.notifyTextListeners(textEvent);
            }
        }
        catch (Exception exception) {
            if (this.m_log != null) {
                this.m_log.logMessage(exception.toString());
            }
            exception.printStackTrace();
        }
    }

    private void startIncrementalHandler() {
        if (this.m_buildThread == null) {
            this.m_buildThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (true) {
                        Double d = Classifier.this.m_dummy;
                        synchronized (d) {
                            try {
                                Classifier.this.m_dummy.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                return;
                            }
                        }
                        Classifier.this.handleIncrementalEvent();
                        Classifier.this.m_state = IDLE;
                        Classifier.this.block(false);
                    }
                }
            };
            this.m_buildThread.setPriority(1);
            this.m_buildThread.start();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptTrainingSet(final TrainingSetEvent trainingSetEvent) {
        block7: {
            if (trainingSetEvent.isStructureOnly()) {
                BatchClassifierEvent batchClassifierEvent = new BatchClassifierEvent(this, this.m_Classifier, new DataSetEvent(this, trainingSetEvent.getTrainingSet()), new DataSetEvent(this, trainingSetEvent.getTrainingSet()), trainingSetEvent.getSetNumber(), trainingSetEvent.getMaxSetNumber());
                this.notifyBatchClassifierListeners(batchClassifierEvent);
                return;
            }
            if (this.m_buildThread == null) {
                try {
                    if (this.m_state != IDLE) break block7;
                    Object object = this;
                    synchronized (object) {
                        this.m_state = BUILDING_MODEL;
                    }
                    this.m_trainingSet = trainingSetEvent.getTrainingSet();
                    object = this.m_visual.getText();
                    this.m_buildThread = new Thread((String)object){
                        private final /* synthetic */ String val$oldText;
                        {
                            this.val$oldText = string;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run() {
                            try {
                                block17: {
                                    try {
                                        Object object;
                                        String string;
                                        if (Classifier.this.m_trainingSet == null) break block17;
                                        if (Classifier.this.m_trainingSet.classIndex() < 0) {
                                            Classifier.this.m_trainingSet.setClassIndex(Classifier.this.m_trainingSet.numAttributes() - 1);
                                            if (Classifier.this.m_log != null) {
                                                Classifier.this.m_log.logMessage("Classifier : assuming last column is the class");
                                            }
                                        }
                                        Classifier.this.m_visual.setAnimated();
                                        Classifier.this.m_visual.setText("Building model...");
                                        if (Classifier.this.m_log != null) {
                                            Classifier.this.m_log.statusMessage("Classifier : building model...");
                                        }
                                        Classifier.this.buildClassifier();
                                        if (Classifier.this.m_Classifier instanceof Drawable && Classifier.this.m_graphListeners.size() > 0) {
                                            string = ((Drawable)((Object)Classifier.this.m_Classifier)).graph();
                                            int n = ((Drawable)((Object)Classifier.this.m_Classifier)).graphType();
                                            object = Classifier.this.m_Classifier.getClass().getName();
                                            object = ((String)object).substring(((String)object).lastIndexOf(46) + 1, ((String)object).length());
                                            object = "Set " + trainingSetEvent.getSetNumber() + " (" + trainingSetEvent.getTrainingSet().relationName() + ") " + (String)object;
                                            GraphEvent graphEvent = new GraphEvent(Classifier.this, string, (String)object, n);
                                            Classifier.this.notifyGraphListeners(graphEvent);
                                        }
                                        if (Classifier.this.m_textListeners.size() <= 0) break block17;
                                        string = Classifier.this.m_Classifier.toString();
                                        String string2 = Classifier.this.m_Classifier.getClass().getName();
                                        string2 = string2.substring(string2.lastIndexOf(46) + 1, string2.length());
                                        string = "=== Classifier model ===\n\nScheme:   " + string2 + "\n" + "Relation: " + Classifier.this.m_trainingSet.relationName() + (trainingSetEvent.getMaxSetNumber() > 1 ? "\nTraining Fold: " + trainingSetEvent.getSetNumber() : "") + "\n\n" + string;
                                        string2 = "Model: " + string2;
                                        object = new TextEvent(Classifier.this, string, string2);
                                        Classifier.this.notifyTextListeners((TextEvent)object);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                        Object var6_8 = null;
                                        Classifier.this.m_visual.setText(this.val$oldText);
                                        Classifier.this.m_visual.setStatic();
                                        Classifier.this.m_state = IDLE;
                                        if (this.isInterrupted()) {
                                            Classifier.this.m_trainingSet = null;
                                            if (Classifier.this.m_log != null) {
                                                Classifier.this.m_log.logMessage("Build classifier interrupted!");
                                                Classifier.this.m_log.statusMessage("OK");
                                            }
                                        }
                                        if (Classifier.this.m_log != null) {
                                            Classifier.this.m_log.statusMessage("OK");
                                        }
                                        Classifier.this.block(false);
                                        return;
                                    }
                                }
                                Object var6_7 = null;
                                Classifier.this.m_visual.setText(this.val$oldText);
                                Classifier.this.m_visual.setStatic();
                                Classifier.this.m_state = IDLE;
                                if (this.isInterrupted()) {
                                    Classifier.this.m_trainingSet = null;
                                    if (Classifier.this.m_log != null) {
                                        Classifier.this.m_log.logMessage("Build classifier interrupted!");
                                        Classifier.this.m_log.statusMessage("OK");
                                    }
                                }
                                if (Classifier.this.m_log != null) {
                                    Classifier.this.m_log.statusMessage("OK");
                                }
                                Classifier.this.block(false);
                                return;
                            }
                            catch (Throwable throwable) {
                                Object var6_9 = null;
                                Classifier.this.m_visual.setText(this.val$oldText);
                                Classifier.this.m_visual.setStatic();
                                Classifier.this.m_state = IDLE;
                                if (this.isInterrupted()) {
                                    Classifier.this.m_trainingSet = null;
                                    if (Classifier.this.m_log != null) {
                                        Classifier.this.m_log.logMessage("Build classifier interrupted!");
                                        Classifier.this.m_log.statusMessage("OK");
                                    }
                                }
                                if (Classifier.this.m_log != null) {
                                    Classifier.this.m_log.statusMessage("OK");
                                }
                                Classifier.this.block(false);
                                throw throwable;
                            }
                        }
                    };
                    this.m_buildThread.setPriority(1);
                    this.m_buildThread.start();
                    this.block(true);
                    this.m_buildThread = null;
                    this.m_state = IDLE;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptTestSet(TestSetEvent testSetEvent) {
        block8: {
            if (this.m_trainingSet != null) {
                try {
                    if (this.m_state != IDLE) break block8;
                    Serializable serializable = this;
                    synchronized (serializable) {
                        this.m_state = CLASSIFYING;
                    }
                    this.m_testingSet = testSetEvent.getTestSet();
                    if (this.m_testingSet != null && this.m_testingSet.classIndex() < 0) {
                        this.m_testingSet.setClassIndex(this.m_testingSet.numAttributes() - 1);
                    }
                    if (this.m_trainingSet.equalHeaders(this.m_testingSet)) {
                        serializable = new BatchClassifierEvent(this, this.m_Classifier, new DataSetEvent(this, this.m_trainingSet), new DataSetEvent(this, testSetEvent.getTestSet()), testSetEvent.getSetNumber(), testSetEvent.getMaxSetNumber());
                        this.notifyBatchClassifierListeners((BatchClassifierEvent)serializable);
                    }
                    this.m_state = IDLE;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private void buildClassifier() throws Exception {
        this.m_Classifier.buildClassifier(this.m_trainingSet);
    }

    public void setVisual(BeanVisual beanVisual) {
        this.m_visual = beanVisual;
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void useDefaultVisual() {
        String string = this.m_Classifier.getClass().toString();
        String string2 = string.substring(0, string.lastIndexOf(46));
        string2 = string2.substring(string2.lastIndexOf(46) + 1, string2.length());
        if (!this.m_visual.loadIcons("weka/gui/beans/icons/Default_" + string2 + "Classifier.gif", "weka/gui/beans/icons/Default_" + string2 + "Classifier_animated.gif")) {
            this.m_visual.loadIcons("weka/gui/beans/icons/DefaultClassifier.gif", "weka/gui/beans/icons/DefaultClassifier_animated.gif");
        }
    }

    public synchronized void addBatchClassifierListener(BatchClassifierListener batchClassifierListener) {
        this.m_batchClassifierListeners.addElement(batchClassifierListener);
    }

    public synchronized void removeBatchClassifierListener(BatchClassifierListener batchClassifierListener) {
        this.m_batchClassifierListeners.remove(batchClassifierListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyBatchClassifierListeners(BatchClassifierEvent batchClassifierEvent) {
        Vector vector;
        Classifier classifier = this;
        synchronized (classifier) {
            vector = (Vector)this.m_batchClassifierListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((BatchClassifierListener)vector.elementAt(i)).acceptClassifier(batchClassifierEvent);
            }
        }
    }

    public synchronized void addGraphListener(GraphListener graphListener) {
        this.m_graphListeners.addElement(graphListener);
    }

    public synchronized void removeGraphListener(GraphListener graphListener) {
        this.m_graphListeners.remove(graphListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyGraphListeners(GraphEvent graphEvent) {
        Vector vector;
        Classifier classifier = this;
        synchronized (classifier) {
            vector = (Vector)this.m_graphListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((GraphListener)vector.elementAt(i)).acceptGraph(graphEvent);
            }
        }
    }

    public synchronized void addTextListener(TextListener textListener) {
        this.m_textListeners.addElement(textListener);
    }

    public synchronized void removeTextListener(TextListener textListener) {
        this.m_textListeners.remove(textListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTextListeners(TextEvent textEvent) {
        Vector vector;
        Classifier classifier = this;
        synchronized (classifier) {
            vector = (Vector)this.m_textListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((TextListener)vector.elementAt(i)).acceptText(textEvent);
            }
        }
    }

    public synchronized void addIncrementalClassifierListener(IncrementalClassifierListener incrementalClassifierListener) {
        this.m_incrementalClassifierListeners.add(incrementalClassifierListener);
    }

    public synchronized void removeIncrementalClassifierListener(IncrementalClassifierListener incrementalClassifierListener) {
        this.m_incrementalClassifierListeners.remove(incrementalClassifierListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyIncrementalClassifierListeners(IncrementalClassifierEvent incrementalClassifierEvent) {
        Vector vector;
        Classifier classifier = this;
        synchronized (classifier) {
            vector = (Vector)this.m_incrementalClassifierListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((IncrementalClassifierListener)vector.elementAt(i)).acceptClassifier(incrementalClassifierEvent);
            }
        }
    }

    public boolean connectionAllowed(String string) {
        return !this.m_listenees.containsKey(string);
    }

    public boolean connectionAllowed(EventSetDescriptor eventSetDescriptor) {
        return this.connectionAllowed(eventSetDescriptor.getName());
    }

    public synchronized void connectionNotification(String string, Object object) {
        if (string.compareTo("instance") == 0 && !(this.m_Classifier instanceof UpdateableClassifier) && this.m_log != null) {
            this.m_log.logMessage("Warning : " + this.m_Classifier.getClass().getName() + " is not an updateable classifier. This " + "classifier will only be evaluated on incoming " + "instance events and not trained on them.");
        }
        if (this.connectionAllowed(string)) {
            this.m_listenees.put(string, object);
        }
    }

    public synchronized void disconnectionNotification(String string, Object object) {
        this.m_listenees.remove(string);
        if (string.compareTo("instance") == 0) {
            this.stop();
        }
    }

    private synchronized void block(boolean bl) {
        if (bl) {
            try {
                if (this.m_buildThread.isAlive() && this.m_state != IDLE) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    public void stop() {
        Enumeration enumeration = this.m_listenees.keys();
        while (enumeration.hasMoreElements()) {
            Object v = this.m_listenees.get(enumeration.nextElement());
            if (!(v instanceof BeanCommon)) continue;
            System.err.println("Listener is BeanCommon");
            ((BeanCommon)v).stop();
        }
        if (this.m_buildThread != null) {
            this.m_buildThread.interrupt();
            this.m_buildThread.stop();
            this.m_buildThread = null;
            this.m_visual.setStatic();
        }
    }

    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    public Enumeration enumerateRequests() {
        Vector<String> vector = new Vector<String>(0);
        if (this.m_buildThread != null) {
            vector.addElement("Stop");
        }
        return vector.elements();
    }

    public void performRequest(String string) {
        if (string.compareTo("Stop") != 0) {
            throw new IllegalArgumentException(string + " not supported (Classifier)");
        }
        this.stop();
    }

    public boolean eventGeneratable(EventSetDescriptor eventSetDescriptor) {
        String string = eventSetDescriptor.getName();
        return this.eventGeneratable(string);
    }

    private boolean generatableEvent(String string) {
        return string.compareTo("graph") == 0 || string.compareTo("text") == 0 || string.compareTo("batchClassifier") == 0 || string.compareTo("incrementalClassifier") == 0;
    }

    public boolean eventGeneratable(String string) {
        Object v;
        if (!this.generatableEvent(string)) {
            return false;
        }
        if (string.compareTo("graph") == 0) {
            if (!(this.m_Classifier instanceof Drawable)) {
                return false;
            }
            if (!this.m_listenees.containsKey("trainingSet")) {
                return false;
            }
            v = this.m_listenees.get("trainingSet");
            if (v instanceof EventConstraints && !((EventConstraints)v).eventGeneratable("trainingSet")) {
                return false;
            }
        }
        if (string.compareTo("batchClassifier") == 0) {
            if (!this.m_listenees.containsKey("testSet")) {
                return false;
            }
            if (!this.m_listenees.containsKey("trainingSet") && this.m_trainingSet == null) {
                return false;
            }
            v = this.m_listenees.get("testSet");
            if (v instanceof EventConstraints && !((EventConstraints)v).eventGeneratable("testSet")) {
                return false;
            }
        }
        if (string.compareTo("text") == 0) {
            if (!this.m_listenees.containsKey("trainingSet") && !this.m_listenees.containsKey("instance")) {
                return false;
            }
            v = this.m_listenees.get("trainingSet");
            if (v != null && v instanceof EventConstraints && !((EventConstraints)v).eventGeneratable("trainingSet")) {
                return false;
            }
            v = this.m_listenees.get("instance");
            if (v != null && v instanceof EventConstraints && !((EventConstraints)v).eventGeneratable("instance")) {
                return false;
            }
        }
        if (string.compareTo("incrementalClassifier") == 0) {
            if (!this.m_listenees.containsKey("instance")) {
                return false;
            }
            v = this.m_listenees.get("instance");
            if (v instanceof EventConstraints && !((EventConstraints)v).eventGeneratable("instance")) {
                return false;
            }
        }
        return true;
    }
}

