/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.FileReader;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import weka.core.AttributeStats;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.visualize.PrintableComponent;
import weka.gui.visualize.PrintablePanel;

public class AttributeVisualizationPanel
extends PrintablePanel {
    protected Instances m_data;
    protected AttributeStats m_as;
    protected int m_attribIndex;
    protected int m_maxValue;
    protected int[] m_histBarCounts;
    int[][] m_histBarClassCounts;
    protected double m_barRange;
    protected int m_classIndex;
    private Thread m_hc;
    private boolean m_threadRun = false;
    protected JComboBox m_colorAttrib;
    private FontMetrics m_fm;
    private Integer m_locker = new Integer(1);
    private FastVector m_colorList = new FastVector();
    private static final Color[] m_defaultColors = new Color[]{Color.blue, Color.red, Color.cyan, new Color(75, 123, 130), Color.pink, Color.green, Color.orange, new Color(255, 0, 255), new Color(255, 0, 0), new Color(0, 255, 0)};

    public AttributeVisualizationPanel() {
        this(false);
    }

    public AttributeVisualizationPanel(boolean bl) {
        this.setFont(new Font("Default", 0, 9));
        this.m_fm = this.getFontMetrics(this.getFont());
        this.setToolTipText("");
        FlowLayout flowLayout = new FlowLayout(0);
        this.setLayout(flowLayout);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (AttributeVisualizationPanel.this.m_data != null) {
                    AttributeVisualizationPanel.this.calcGraph();
                }
            }
        });
        this.m_colorAttrib = new JComboBox();
        this.m_colorAttrib.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    AttributeVisualizationPanel.this.m_classIndex = AttributeVisualizationPanel.this.m_colorAttrib.getSelectedIndex() - 1;
                    if (AttributeVisualizationPanel.this.m_as != null) {
                        AttributeVisualizationPanel.this.setAttribute(AttributeVisualizationPanel.this.m_attribIndex);
                    }
                }
            }
        });
        if (bl) {
            this.add(this.m_colorAttrib);
            this.validate();
        }
    }

    public void setInstances(Instances instances) {
        this.m_attribIndex = 0;
        this.m_as = null;
        this.m_data = instances;
        if (this.m_colorAttrib != null) {
            this.m_colorAttrib.removeAllItems();
            this.m_colorAttrib.addItem("No class");
            for (int i = 0; i < this.m_data.numAttributes(); ++i) {
                String string = "";
                switch (this.m_data.attribute(i).type()) {
                    case 1: {
                        string = "(Nom) ";
                        break;
                    }
                    case 0: {
                        string = "(Num) ";
                        break;
                    }
                    case 2: {
                        string = "(Str) ";
                        break;
                    }
                    case 3: {
                        string = "(Dat) ";
                        break;
                    }
                    default: {
                        string = "(???) ";
                    }
                }
                this.m_colorAttrib.addItem(new String("Class: " + this.m_data.attribute(i).name() + " " + string));
            }
            if (this.m_data.classIndex() >= 0) {
                this.m_colorAttrib.setSelectedIndex(this.m_data.classIndex() + 1);
            } else {
                this.m_colorAttrib.setSelectedIndex(this.m_data.numAttributes());
            }
        }
        this.m_classIndex = this.m_data.classIndex() >= 0 ? this.m_data.classIndex() : this.m_data.numAttributes() - 1;
    }

    public JComboBox getColorBox() {
        return this.m_colorAttrib;
    }

    public int getColoringIndex() {
        return this.m_classIndex;
    }

    public void setColoringIndex(int n) {
        this.m_classIndex = n;
        if (this.m_colorAttrib != null) {
            this.m_colorAttrib.setSelectedIndex(n + 1);
        } else {
            this.setAttribute(this.m_attribIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(int n) {
        Integer n2 = this.m_locker;
        synchronized (n2) {
            this.m_threadRun = true;
            this.m_attribIndex = n;
            this.m_as = this.m_data.attributeStats(this.m_attribIndex);
        }
        this.calcGraph();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calcGraph() {
        Integer n = this.m_locker;
        synchronized (n) {
            this.m_threadRun = true;
            if (this.m_as.nominalCounts != null) {
                this.m_hc = new BarCalc();
                this.m_hc.setPriority(1);
                this.m_hc.start();
            } else if (this.m_as.numericStats != null) {
                this.m_hc = new HistCalc();
                this.m_hc.setPriority(1);
                this.m_hc.start();
            } else {
                this.m_histBarCounts = null;
                this.m_histBarClassCounts = null;
                this.repaint();
                this.m_threadRun = false;
            }
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.m_as != null && this.m_as.nominalCounts != null) {
            float f = (float)this.getWidth() / (float)this.m_as.nominalCounts.length;
            int n = 0;
            int n2 = 0;
            int n3 = f > 5.0f ? (int)Math.floor(f * 0.8f) : 1;
            n += (int)(Math.floor(f * 0.1f) < 1.0 ? 1.0 : Math.floor(f * 0.1f));
            if (this.getWidth() - (this.m_as.nominalCounts.length * n3 + (int)(Math.floor(f * 0.2f) < 1.0 ? 1.0 : Math.floor(f * 0.2f)) * this.m_as.nominalCounts.length) > 2) {
                n += (this.getWidth() - (this.m_as.nominalCounts.length * n3 + (int)(Math.floor(f * 0.2f) < 1.0 ? 1.0 : Math.floor(f * 0.2f)) * this.m_as.nominalCounts.length)) / 2;
            }
            for (int i = 0; i < this.m_as.nominalCounts.length; ++i) {
                float f2 = ((float)this.getHeight() - (float)this.m_fm.getHeight()) / (float)this.m_maxValue;
                n2 = this.getHeight() - Math.round((float)this.m_as.nominalCounts[i] * f2);
                if (mouseEvent.getX() >= n && mouseEvent.getX() <= n + n3 && mouseEvent.getY() >= this.getHeight() - Math.round((float)this.m_as.nominalCounts[i] * f2)) {
                    return this.m_data.attribute(this.m_attribIndex).value(i) + " [" + this.m_as.nominalCounts[i] + "]";
                }
                n = n + n3 + (int)(Math.floor(f * 0.2f) < 1.0 ? 1.0 : Math.floor(f * 0.2f));
            }
        } else if (!(this.m_threadRun || this.m_histBarCounts == null && this.m_histBarClassCounts == null)) {
            int n = 0;
            boolean bl = false;
            double d = this.m_as.numericStats.min;
            if (this.m_classIndex >= 0 && this.m_data.attribute(this.m_classIndex).isNominal()) {
                int n4 = (this.getWidth() - 6) / this.m_histBarClassCounts.length < 1 ? 1 : (this.getWidth() - 6) / this.m_histBarClassCounts.length;
                n = 3;
                if (this.getWidth() - (n + this.m_histBarClassCounts.length * n4) > 5) {
                    n += (this.getWidth() - (n + this.m_histBarClassCounts.length * n4)) / 2;
                }
                float f = ((float)this.getHeight() - (float)this.m_fm.getHeight()) / (float)this.m_maxValue;
                if (mouseEvent.getX() - n >= 0) {
                    int n5 = (int)((double)(mouseEvent.getX() - n) / ((double)n4 + 1.0E-10));
                    if (n5 == 0) {
                        int n6 = 0;
                        for (int i = 0; i < this.m_histBarClassCounts[0].length; ++i) {
                            n6 += this.m_histBarClassCounts[0][i];
                        }
                        return "<html><center><font face=Dialog size=-1>" + n6 + "<br>" + "[" + Utils.doubleToString(d + this.m_barRange * (double)n5, 3) + ", " + Utils.doubleToString(d + this.m_barRange * (double)(n5 + 1), 3) + "]" + "</font></center></html>";
                    }
                    if (n5 < this.m_histBarClassCounts.length) {
                        int n7 = 0;
                        for (int i = 0; i < this.m_histBarClassCounts[n5].length; ++i) {
                            n7 += this.m_histBarClassCounts[n5][i];
                        }
                        return "<html><center><font face=Dialog size=-1>" + n7 + "<br>(" + Utils.doubleToString(d + this.m_barRange * (double)n5, 3) + ", " + Utils.doubleToString(d + this.m_barRange * (double)(n5 + 1), 3) + "]</font></center></html>";
                    }
                }
            } else {
                int n8 = (this.getWidth() - 6) / this.m_histBarCounts.length < 1 ? 1 : (this.getWidth() - 6) / this.m_histBarCounts.length;
                n = 3;
                if (this.getWidth() - (n + this.m_histBarCounts.length * n8) > 5) {
                    n += (this.getWidth() - (n + this.m_histBarCounts.length * n8)) / 2;
                }
                float f = ((float)this.getHeight() - (float)this.m_fm.getHeight()) / (float)this.m_maxValue;
                if (mouseEvent.getX() - n >= 0) {
                    int n9 = (int)((double)(mouseEvent.getX() - n) / ((double)n8 + 1.0E-10));
                    if (n9 == 0) {
                        return "<html><center><font face=Dialog size=-1>" + this.m_histBarCounts[0] + "<br>" + "[" + Utils.doubleToString(d + this.m_barRange * (double)n9, 3) + ", " + Utils.doubleToString(d + this.m_barRange * (double)(n9 + 1), 3) + "]" + "</font></center></html>";
                    }
                    if (n9 < this.m_histBarCounts.length) {
                        return "<html><center><font face=Dialog size=-1>" + this.m_histBarCounts[n9] + "<br>" + "(" + Utils.doubleToString(d + this.m_barRange * (double)n9, 3) + ", " + Utils.doubleToString(d + this.m_barRange * (double)(n9 + 1), 3) + "]" + "</font></center></html>";
                    }
                }
            }
        }
        return PrintableComponent.getToolTipText(this.m_Printer);
    }

    public void paintComponent(Graphics graphics) {
        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        if (this.m_as != null) {
            if (!this.m_threadRun) {
                int n = 0;
                if (this.m_colorAttrib != null) {
                    n = this.m_colorAttrib.getHeight() + this.m_colorAttrib.getLocation().y;
                }
                if (this.m_as.nominalCounts != null && (this.m_histBarClassCounts != null || this.m_histBarCounts != null)) {
                    int n2 = 0;
                    int n3 = 0;
                    if (this.m_classIndex >= 0 && this.m_data.attribute(this.m_classIndex).isNominal()) {
                        float f = (float)this.getWidth() / (float)this.m_histBarClassCounts.length;
                        int n4 = f > 5.0f ? (int)Math.floor(f * 0.8f) : 1;
                        n2 += (int)(Math.floor(f * 0.1f) < 1.0 ? 1.0 : Math.floor(f * 0.1f));
                        if (this.getWidth() - (this.m_histBarClassCounts.length * n4 + (int)(Math.floor(f * 0.2f) < 1.0 ? 1.0 : Math.floor(f * 0.2f)) * this.m_histBarClassCounts.length) > 2) {
                            n2 += (this.getWidth() - (this.m_histBarClassCounts.length * n4 + (int)(Math.floor(f * 0.2f) < 1.0 ? 1.0 : Math.floor(f * 0.2f)) * this.m_histBarClassCounts.length)) / 2;
                        }
                        int n5 = 0;
                        for (int i = 0; i < this.m_histBarClassCounts.length; ++i) {
                            float f2 = ((float)this.getHeight() - (float)this.m_fm.getHeight() - (float)n) / (float)this.m_maxValue;
                            n3 = this.getHeight();
                            for (int j = 0; j < this.m_histBarClassCounts[i].length; ++j) {
                                n5 += this.m_histBarClassCounts[i][j];
                                graphics.setColor((Color)this.m_colorList.elementAt(j));
                                graphics.fillRect(n2, n3 -= Math.round((float)this.m_histBarClassCounts[i][j] * f2), n4, Math.round((float)this.m_histBarClassCounts[i][j] * f2));
                                graphics.setColor(Color.black);
                            }
                            if ((float)this.m_fm.stringWidth(Integer.toString(n5)) < f) {
                                graphics.drawString(Integer.toString(n5), n2, n3 - 1);
                            }
                            n2 = n2 + n4 + (int)(Math.floor(f * 0.2f) < 1.0 ? 1.0 : Math.floor(f * 0.2f));
                            n5 = 0;
                        }
                    } else {
                        float f = (float)this.getWidth() / (float)this.m_histBarCounts.length;
                        int n6 = f > 5.0f ? (int)Math.floor(f * 0.8f) : 1;
                        n2 += (int)(Math.floor(f * 0.1f) < 1.0 ? 1.0 : Math.floor(f * 0.1f));
                        if (this.getWidth() - (this.m_histBarCounts.length * n6 + (int)(Math.floor(f * 0.2f) < 1.0 ? 1.0 : Math.floor(f * 0.2f)) * this.m_histBarCounts.length) > 2) {
                            n2 += (this.getWidth() - (this.m_histBarCounts.length * n6 + (int)(Math.floor(f * 0.2f) < 1.0 ? 1.0 : Math.floor(f * 0.2f)) * this.m_histBarCounts.length)) / 2;
                        }
                        for (int i = 0; i < this.m_histBarCounts.length; ++i) {
                            float f3 = ((float)this.getHeight() - (float)this.m_fm.getHeight() - (float)n) / (float)this.m_maxValue;
                            n3 = this.getHeight() - Math.round((float)this.m_histBarCounts[i] * f3);
                            graphics.fillRect(n2, n3, n6, Math.round((float)this.m_histBarCounts[i] * f3));
                            if ((float)this.m_fm.stringWidth(Integer.toString(this.m_histBarCounts[i])) < f) {
                                graphics.drawString(Integer.toString(this.m_histBarCounts[i]), n2, n3 - 1);
                            }
                            n2 = n2 + n6 + (int)(Math.floor(f * 0.2f) < 1.0 ? 1.0 : Math.floor(f * 0.2f));
                        }
                    }
                } else if (this.m_as.numericStats != null && (this.m_histBarClassCounts != null || this.m_histBarCounts != null)) {
                    int n7 = 0;
                    int n8 = 0;
                    if (this.m_classIndex >= 0 && this.m_data.attribute(this.m_classIndex).isNominal()) {
                        int n9 = (this.getWidth() - 6) / this.m_histBarClassCounts.length < 1 ? 1 : (this.getWidth() - 6) / this.m_histBarClassCounts.length;
                        n7 = 3;
                        if (this.getWidth() - (n7 + this.m_histBarClassCounts.length * n9) > 5) {
                            n7 += (this.getWidth() - (n7 + this.m_histBarClassCounts.length * n9)) / 2;
                        }
                        for (int i = 0; i < this.m_histBarClassCounts.length; ++i) {
                            float f = ((float)this.getHeight() - (float)this.m_fm.getHeight() - (float)n - 19.0f) / (float)this.m_maxValue;
                            n8 = this.getHeight() - 19;
                            int n10 = 0;
                            for (int j = 0; j < this.m_histBarClassCounts[i].length; ++j) {
                                n8 -= Math.round((float)this.m_histBarClassCounts[i][j] * f);
                                graphics.setColor((Color)this.m_colorList.elementAt(j));
                                if (n9 > 1) {
                                    graphics.fillRect(n7, n8, n9, Math.round((float)this.m_histBarClassCounts[i][j] * f));
                                } else if ((float)this.m_histBarClassCounts[i][j] * f > 0.0f) {
                                    graphics.drawLine(n7, n8, n7, n8 + Math.round((float)this.m_histBarClassCounts[i][j] * f));
                                }
                                graphics.setColor(Color.black);
                                n10 += this.m_histBarClassCounts[i][j];
                            }
                            if (this.m_fm.stringWidth(" " + Integer.toString(n10)) < n9) {
                                graphics.drawString(" " + Integer.toString(n10), n7, n8 - 1);
                            }
                            n7 += n9;
                        }
                        n7 = 3;
                        if (this.getWidth() - (n7 + this.m_histBarClassCounts.length * n9) > 5) {
                            n7 += (this.getWidth() - (n7 + this.m_histBarClassCounts.length * n9)) / 2;
                        }
                        graphics.drawLine(n7, this.getHeight() - 17, n9 == 1 ? n7 + n9 * this.m_histBarClassCounts.length - 1 : n7 + n9 * this.m_histBarClassCounts.length, this.getHeight() - 17);
                        graphics.drawLine(n7, this.getHeight() - 16, n7, this.getHeight() - 12);
                        graphics.drawString(Utils.doubleToString(this.m_as.numericStats.min, 2), n7, this.getHeight() - 12 + this.m_fm.getHeight());
                        graphics.drawLine(n7 + n9 * this.m_histBarClassCounts.length / 2, this.getHeight() - 16, n7 + n9 * this.m_histBarClassCounts.length / 2, this.getHeight() - 12);
                        graphics.drawString(Utils.doubleToString(this.m_as.numericStats.max / 2.0 + this.m_as.numericStats.min / 2.0, 2), n7 + n9 * this.m_histBarClassCounts.length / 2 - this.m_fm.stringWidth(Utils.doubleToString(this.m_as.numericStats.max / 2.0 + this.m_as.numericStats.min / 2.0, 2)) / 2, this.getHeight() - 12 + this.m_fm.getHeight());
                        graphics.drawLine(n9 == 1 ? n7 + n9 * this.m_histBarClassCounts.length - 1 : n7 + n9 * this.m_histBarClassCounts.length, this.getHeight() - 16, n9 == 1 ? n7 + n9 * this.m_histBarClassCounts.length - 1 : n7 + n9 * this.m_histBarClassCounts.length, this.getHeight() - 12);
                        graphics.drawString(Utils.doubleToString(this.m_as.numericStats.max, 2), n9 == 1 ? n7 + n9 * this.m_histBarClassCounts.length - this.m_fm.stringWidth(Utils.doubleToString(this.m_as.numericStats.max, 2)) - 1 : n7 + n9 * this.m_histBarClassCounts.length - this.m_fm.stringWidth(Utils.doubleToString(this.m_as.numericStats.max, 2)), this.getHeight() - 12 + this.m_fm.getHeight());
                    } else {
                        int n11 = (this.getWidth() - 6) / this.m_histBarCounts.length < 1 ? 1 : (this.getWidth() - 6) / this.m_histBarCounts.length;
                        n7 = 3;
                        if (this.getWidth() - (n7 + this.m_histBarCounts.length * n11) > 5) {
                            n7 += (this.getWidth() - (n7 + this.m_histBarCounts.length * n11)) / 2;
                        }
                        for (int i = 0; i < this.m_histBarCounts.length; ++i) {
                            float f = ((float)this.getHeight() - (float)this.m_fm.getHeight() - (float)n - 19.0f) / (float)this.m_maxValue;
                            n8 = this.getHeight() - Math.round((float)this.m_histBarCounts[i] * f) - 19;
                            if (n11 > 1) {
                                graphics.drawRect(n7, n8, n11, Math.round((float)this.m_histBarCounts[i] * f));
                            } else if ((float)this.m_histBarCounts[i] * f > 0.0f) {
                                graphics.drawLine(n7, n8, n7, n8 + Math.round((float)this.m_histBarCounts[i] * f));
                            }
                            if (this.m_fm.stringWidth(" " + Integer.toString(this.m_histBarCounts[i])) < n11) {
                                graphics.drawString(" " + Integer.toString(this.m_histBarCounts[i]), n7, n8 - 1);
                            }
                            n7 += n11;
                        }
                        n7 = 3;
                        if (this.getWidth() - (n7 + this.m_histBarCounts.length * n11) > 5) {
                            n7 += (this.getWidth() - (n7 + this.m_histBarCounts.length * n11)) / 2;
                        }
                        graphics.drawLine(n7, this.getHeight() - 17, n11 == 1 ? n7 + n11 * this.m_histBarCounts.length - 1 : n7 + n11 * this.m_histBarCounts.length, this.getHeight() - 17);
                        graphics.drawLine(n7, this.getHeight() - 16, n7, this.getHeight() - 12);
                        graphics.drawString(Utils.doubleToString(this.m_as.numericStats.min, 2), n7, this.getHeight() - 12 + this.m_fm.getHeight());
                        graphics.drawLine(n7 + n11 * this.m_histBarCounts.length / 2, this.getHeight() - 16, n7 + n11 * this.m_histBarCounts.length / 2, this.getHeight() - 12);
                        graphics.drawString(Utils.doubleToString(this.m_as.numericStats.max / 2.0 + this.m_as.numericStats.min / 2.0, 2), n7 + n11 * this.m_histBarCounts.length / 2 - this.m_fm.stringWidth(Utils.doubleToString(this.m_as.numericStats.max / 2.0 + this.m_as.numericStats.min / 2.0, 2)) / 2, this.getHeight() - 12 + this.m_fm.getHeight());
                        graphics.drawLine(n11 == 1 ? n7 + n11 * this.m_histBarCounts.length - 1 : n7 + n11 * this.m_histBarCounts.length, this.getHeight() - 16, n11 == 1 ? n7 + n11 * this.m_histBarCounts.length - 1 : n7 + n11 * this.m_histBarCounts.length, this.getHeight() - 12);
                        graphics.drawString(Utils.doubleToString(this.m_as.numericStats.max, 2), n11 == 1 ? n7 + n11 * this.m_histBarCounts.length - this.m_fm.stringWidth(Utils.doubleToString(this.m_as.numericStats.max, 2)) - 1 : n7 + n11 * this.m_histBarCounts.length - this.m_fm.stringWidth(Utils.doubleToString(this.m_as.numericStats.max, 2)), this.getHeight() - 12 + this.m_fm.getHeight());
                    }
                } else {
                    graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
                    graphics.drawString("Attribute is neither numeric nor nominal.", this.getWidth() / 2 - this.m_fm.stringWidth("Attribute is neither numeric nor nominal.") / 2, this.getHeight() / 2 - this.m_fm.getHeight() / 2);
                }
            } else {
                graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
                graphics.drawString("Calculating. Please Wait...", this.getWidth() / 2 - this.m_fm.stringWidth("Calculating. Please Wait...") / 2, this.getHeight() / 2 - this.m_fm.getHeight() / 2);
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            JFrame jFrame = new JFrame("AttribVisualization");
            AttributeVisualizationPanel attributeVisualizationPanel = new AttributeVisualizationPanel();
            try {
                Instances instances = new Instances(new FileReader(stringArray[0]));
                attributeVisualizationPanel.setInstances(instances);
                System.out.println("Loaded: " + stringArray[0] + "\nRelation: " + attributeVisualizationPanel.m_data.relationName() + "\nAttributes: " + attributeVisualizationPanel.m_data.numAttributes());
                attributeVisualizationPanel.setAttribute(Integer.parseInt(stringArray[1]));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(-1);
            }
            System.out.println("The attributes are: ");
            for (int i = 0; i < attributeVisualizationPanel.m_data.numAttributes(); ++i) {
                System.out.println(attributeVisualizationPanel.m_data.attribute(i).name());
            }
            jFrame.setSize(500, 300);
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)attributeVisualizationPanel, "Center");
            jFrame.setDefaultCloseOperation(3);
            jFrame.setVisible(true);
        } else {
            System.out.println("Usage: java AttributeVisualizationPanel [arff file] [index of attribute]");
        }
    }

    private class HistCalc
    extends Thread {
        private HistCalc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Integer n = AttributeVisualizationPanel.this.m_locker;
            synchronized (n) {
                if (AttributeVisualizationPanel.this.m_classIndex >= 0 && AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_classIndex).isNominal()) {
                    int n2;
                    double d = 0.0;
                    d = 3.49 * AttributeVisualizationPanel.this.m_as.numericStats.stdDev * Math.pow(AttributeVisualizationPanel.this.m_data.numInstances(), -0.3333333333333333);
                    int n3 = Math.max(1, (int)Math.round((AttributeVisualizationPanel.this.m_as.numericStats.max - AttributeVisualizationPanel.this.m_as.numericStats.min) / d));
                    if (n3 > AttributeVisualizationPanel.this.getWidth() && (n3 = AttributeVisualizationPanel.this.getWidth() - 6) < 1) {
                        n3 = 1;
                    }
                    int[][] nArray = new int[n3][AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_classIndex).numValues() + 1];
                    double d2 = (AttributeVisualizationPanel.this.m_as.numericStats.max - AttributeVisualizationPanel.this.m_as.numericStats.min) / (double)nArray.length;
                    AttributeVisualizationPanel.this.m_maxValue = 0;
                    if (AttributeVisualizationPanel.this.m_colorList.size() == 0) {
                        AttributeVisualizationPanel.this.m_colorList.addElement(Color.black);
                    }
                    for (n2 = AttributeVisualizationPanel.this.m_colorList.size(); n2 < AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_classIndex).numValues() + 1; ++n2) {
                        Color color = m_defaultColors[(n2 - 1) % 10];
                        int n4 = (n2 - 1) / 10;
                        n4 *= 2;
                        for (int i = 0; i < n4; ++i) {
                            color = color.darker();
                        }
                        AttributeVisualizationPanel.this.m_colorList.addElement(color);
                    }
                    for (n2 = 0; n2 < AttributeVisualizationPanel.this.m_data.numInstances(); ++n2) {
                        int n5 = 0;
                        try {
                            if (AttributeVisualizationPanel.this.m_data.instance(n2).isMissing(AttributeVisualizationPanel.this.m_attribIndex)) continue;
                            n5 = (int)Math.ceil((float)((AttributeVisualizationPanel.this.m_data.instance(n2).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) / d2));
                            if (n5 == 0) {
                                if (AttributeVisualizationPanel.this.m_data.instance(n2).isMissing(AttributeVisualizationPanel.this.m_classIndex)) {
                                    int[] nArray2 = nArray[n5];
                                    nArray2[0] = nArray2[0] + 1;
                                    continue;
                                }
                                int[] nArray3 = nArray[n5];
                                int n6 = (int)AttributeVisualizationPanel.this.m_data.instance(n2).value(AttributeVisualizationPanel.this.m_classIndex) + 1;
                                nArray3[n6] = nArray3[n6] + 1;
                                continue;
                            }
                            if (AttributeVisualizationPanel.this.m_data.instance(n2).isMissing(AttributeVisualizationPanel.this.m_classIndex)) {
                                int[] nArray4 = nArray[n5 - 1];
                                nArray4[0] = nArray4[0] + 1;
                                continue;
                            }
                            int[] nArray5 = nArray[n5 - 1];
                            int n7 = (int)AttributeVisualizationPanel.this.m_data.instance(n2).value(AttributeVisualizationPanel.this.m_classIndex) + 1;
                            nArray5[n7] = nArray5[n7] + 1;
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            System.out.println("t:" + n5 + " barRange:" + d2 + " histLength:" + nArray.length + " value:" + AttributeVisualizationPanel.this.m_data.instance(n2).value(AttributeVisualizationPanel.this.m_attribIndex) + " min:" + AttributeVisualizationPanel.this.m_as.numericStats.min + " sumResult:" + (AttributeVisualizationPanel.this.m_data.instance(n2).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) + " divideResult:" + (float)((AttributeVisualizationPanel.this.m_data.instance(n2).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) / d2) + " finalResult:" + Math.ceil((float)((AttributeVisualizationPanel.this.m_data.instance(n2).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) / d2)));
                        }
                    }
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        int n8 = 0;
                        for (int i = 0; i < nArray[n2].length; ++i) {
                            n8 += nArray[n2][i];
                        }
                        if (AttributeVisualizationPanel.this.m_maxValue >= n8) continue;
                        AttributeVisualizationPanel.this.m_maxValue = n8;
                    }
                    AttributeVisualizationPanel.this.m_histBarClassCounts = nArray;
                    AttributeVisualizationPanel.this.m_barRange = d2;
                } else {
                    double d = 3.49 * AttributeVisualizationPanel.this.m_as.numericStats.stdDev * Math.pow(AttributeVisualizationPanel.this.m_data.numInstances(), -0.3333333333333333);
                    int n9 = Math.max(1, (int)Math.round((AttributeVisualizationPanel.this.m_as.numericStats.max - AttributeVisualizationPanel.this.m_as.numericStats.min) / d));
                    if (n9 > AttributeVisualizationPanel.this.getWidth() && (n9 = AttributeVisualizationPanel.this.getWidth() - 6) < 1) {
                        n9 = 1;
                    }
                    int[] nArray = new int[n9];
                    double d3 = (AttributeVisualizationPanel.this.m_as.numericStats.max - AttributeVisualizationPanel.this.m_as.numericStats.min) / (double)nArray.length;
                    AttributeVisualizationPanel.this.m_maxValue = 0;
                    for (int i = 0; i < AttributeVisualizationPanel.this.m_data.numInstances(); ++i) {
                        int n10 = 0;
                        if (AttributeVisualizationPanel.this.m_data.instance(i).isMissing(AttributeVisualizationPanel.this.m_attribIndex)) continue;
                        try {
                            n10 = (int)Math.ceil((float)((AttributeVisualizationPanel.this.m_data.instance(i).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) / d3));
                            if (n10 == 0) {
                                int n11 = n10;
                                nArray[n11] = nArray[n11] + 1;
                                if (nArray[n10] <= AttributeVisualizationPanel.this.m_maxValue) continue;
                                AttributeVisualizationPanel.this.m_maxValue = nArray[n10];
                                continue;
                            }
                            int n12 = n10 - 1;
                            nArray[n12] = nArray[n12] + 1;
                            if (nArray[n10 - 1] <= AttributeVisualizationPanel.this.m_maxValue) continue;
                            AttributeVisualizationPanel.this.m_maxValue = nArray[n10 - 1];
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            arrayIndexOutOfBoundsException.printStackTrace();
                            System.out.println("t:" + n10 + " barRange:" + d3 + " histLength:" + nArray.length + " value:" + AttributeVisualizationPanel.this.m_data.instance(i).value(AttributeVisualizationPanel.this.m_attribIndex) + " min:" + AttributeVisualizationPanel.this.m_as.numericStats.min + " sumResult:" + (AttributeVisualizationPanel.this.m_data.instance(i).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) + " divideResult:" + (float)((AttributeVisualizationPanel.this.m_data.instance(i).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) / d3) + " finalResult:" + Math.ceil((float)((AttributeVisualizationPanel.this.m_data.instance(i).value(AttributeVisualizationPanel.this.m_attribIndex) - AttributeVisualizationPanel.this.m_as.numericStats.min) / d3)));
                        }
                    }
                    AttributeVisualizationPanel.this.m_histBarCounts = nArray;
                    AttributeVisualizationPanel.this.m_barRange = d3;
                }
                AttributeVisualizationPanel.this.m_threadRun = false;
                AttributeVisualizationPanel.this.repaint();
            }
        }
    }

    private class BarCalc
    extends Thread {
        private BarCalc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Integer n = AttributeVisualizationPanel.this.m_locker;
            synchronized (n) {
                if (AttributeVisualizationPanel.this.m_classIndex >= 0 && AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_classIndex).isNominal()) {
                    int n2;
                    int[][] nArray = new int[AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_attribIndex).numValues()][AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_classIndex).numValues() + 1];
                    if (AttributeVisualizationPanel.this.m_as.nominalCounts.length > 0) {
                        AttributeVisualizationPanel.this.m_maxValue = AttributeVisualizationPanel.this.m_as.nominalCounts[0];
                        for (n2 = 0; n2 < AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_attribIndex).numValues(); ++n2) {
                            if (AttributeVisualizationPanel.this.m_as.nominalCounts[n2] <= AttributeVisualizationPanel.this.m_maxValue) continue;
                            AttributeVisualizationPanel.this.m_maxValue = AttributeVisualizationPanel.this.m_as.nominalCounts[n2];
                        }
                    } else {
                        AttributeVisualizationPanel.this.m_maxValue = 0;
                    }
                    if (AttributeVisualizationPanel.this.m_colorList.size() == 0) {
                        AttributeVisualizationPanel.this.m_colorList.addElement(Color.black);
                    }
                    for (n2 = AttributeVisualizationPanel.this.m_colorList.size(); n2 < AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_classIndex).numValues() + 1; ++n2) {
                        Color color = m_defaultColors[(n2 - 1) % 10];
                        int n3 = (n2 - 1) / 10;
                        n3 *= 2;
                        for (int i = 0; i < n3; ++i) {
                            color = color.darker();
                        }
                        AttributeVisualizationPanel.this.m_colorList.addElement(color);
                    }
                    for (n2 = 0; n2 < AttributeVisualizationPanel.this.m_data.numInstances(); ++n2) {
                        if (AttributeVisualizationPanel.this.m_data.instance(n2).isMissing(AttributeVisualizationPanel.this.m_attribIndex)) continue;
                        if (AttributeVisualizationPanel.this.m_data.instance(n2).isMissing(AttributeVisualizationPanel.this.m_classIndex)) {
                            int[] nArray2 = nArray[(int)AttributeVisualizationPanel.this.m_data.instance(n2).value(AttributeVisualizationPanel.this.m_attribIndex)];
                            nArray2[0] = nArray2[0] + 1;
                            continue;
                        }
                        int[] nArray3 = nArray[(int)AttributeVisualizationPanel.this.m_data.instance(n2).value(AttributeVisualizationPanel.this.m_attribIndex)];
                        int n4 = (int)AttributeVisualizationPanel.this.m_data.instance(n2).value(AttributeVisualizationPanel.this.m_classIndex) + 1;
                        nArray3[n4] = nArray3[n4] + 1;
                    }
                    AttributeVisualizationPanel.this.m_threadRun = false;
                    AttributeVisualizationPanel.this.m_histBarClassCounts = nArray;
                    AttributeVisualizationPanel.this.repaint();
                } else {
                    int n5;
                    int[] nArray = new int[AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_attribIndex).numValues()];
                    if (AttributeVisualizationPanel.this.m_as.nominalCounts.length > 0) {
                        AttributeVisualizationPanel.this.m_maxValue = AttributeVisualizationPanel.this.m_as.nominalCounts[0];
                        for (n5 = 0; n5 < AttributeVisualizationPanel.this.m_data.attribute(AttributeVisualizationPanel.this.m_attribIndex).numValues(); ++n5) {
                            if (AttributeVisualizationPanel.this.m_as.nominalCounts[n5] <= AttributeVisualizationPanel.this.m_maxValue) continue;
                            AttributeVisualizationPanel.this.m_maxValue = AttributeVisualizationPanel.this.m_as.nominalCounts[n5];
                        }
                    } else {
                        AttributeVisualizationPanel.this.m_maxValue = 0;
                    }
                    for (n5 = 0; n5 < AttributeVisualizationPanel.this.m_data.numInstances(); ++n5) {
                        if (AttributeVisualizationPanel.this.m_data.instance(n5).isMissing(AttributeVisualizationPanel.this.m_attribIndex)) continue;
                        int n6 = (int)AttributeVisualizationPanel.this.m_data.instance(n5).value(AttributeVisualizationPanel.this.m_attribIndex);
                        nArray[n6] = nArray[n6] + 1;
                    }
                    AttributeVisualizationPanel.this.m_threadRun = false;
                    AttributeVisualizationPanel.this.m_histBarCounts = nArray;
                    AttributeVisualizationPanel.this.repaint();
                }
            }
        }
    }
}

