/*
 * Decompiled with CFR 0.152.
 */
package weka.core.xml;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultListModel;
import org.w3c.dom.Element;
import weka.classifiers.CostMatrix;
import weka.core.Matrix;
import weka.core.xml.XMLDocument;
import weka.core.xml.XMLSerialization;

public class XMLBasicSerialization
extends XMLSerialization {
    public static final String VAL_MAPPING = "mapping";
    public static final String VAL_KEY = "key";
    public static final String VAL_VALUE = "value";
    public static final String VAL_CELLS = "cells";
    static /* synthetic */ Class class$java$lang$Object;

    public void clear() throws Exception {
        super.clear();
        this.m_CustomMethods.register(this, DefaultListModel.class, "DefaultListModel");
        this.m_CustomMethods.register(this, HashMap.class, "Map");
        this.m_CustomMethods.register(this, HashSet.class, "Collection");
        this.m_CustomMethods.register(this, Hashtable.class, "Map");
        this.m_CustomMethods.register(this, LinkedList.class, "Collection");
        this.m_CustomMethods.register(this, Properties.class, "Map");
        this.m_CustomMethods.register(this, Stack.class, "Collection");
        this.m_CustomMethods.register(this, TreeMap.class, "Map");
        this.m_CustomMethods.register(this, TreeSet.class, "Collection");
        this.m_CustomMethods.register(this, Vector.class, "Collection");
        this.m_CustomMethods.register(this, weka.core.matrix.Matrix.class, "Matrix");
        this.m_CustomMethods.register(this, Matrix.class, "MatrixOld");
        this.m_CustomMethods.register(this, CostMatrix.class, "CostMatrixOld");
    }

    public Element writeDefaultListModel(Element element, Object object, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        DefaultListModel defaultListModel = (DefaultListModel)object;
        Element element2 = this.addElement(element, string, object.getClass().getName(), false);
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            this.invokeWriteToXML(element2, defaultListModel.get(i), Integer.toString(i));
        }
        return element2;
    }

    public Object readDefaultListModel(Element element) throws Exception {
        Element element2;
        int n;
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute("name"));
        }
        this.m_CurrentNode = element;
        Vector vector = XMLDocument.getChildTags(element);
        DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
        int n2 = vector.size() - 1;
        for (n = 0; n < vector.size(); ++n) {
            element2 = (Element)vector.get(n);
            int n3 = Integer.parseInt(element2.getAttribute("name"));
            if (n3 <= n2) continue;
            n2 = n3;
        }
        defaultListModel.setSize(n2 + 1);
        for (n = 0; n < vector.size(); ++n) {
            element2 = (Element)vector.get(n);
            defaultListModel.set(Integer.parseInt(element2.getAttribute("name")), this.invokeReadFromXML(element2));
        }
        return defaultListModel;
    }

    public Element writeCollection(Element element, Object object, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        Iterator iterator = ((Collection)object).iterator();
        Element element2 = this.addElement(element, string, object.getClass().getName(), false);
        int n = 0;
        while (iterator.hasNext()) {
            this.invokeWriteToXML(element2, iterator.next(), Integer.toString(n));
            ++n;
        }
        return element2;
    }

    public Object readCollection(Element element) throws Exception {
        Element element2;
        int n;
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute("name"));
        }
        this.m_CurrentNode = element;
        Vector vector = XMLDocument.getChildTags(element);
        Vector<Object> vector2 = new Vector<Object>();
        int n2 = vector.size() - 1;
        for (n = 0; n < vector.size(); ++n) {
            element2 = (Element)vector.get(n);
            int n3 = Integer.parseInt(element2.getAttribute("name"));
            if (n3 <= n2) continue;
            n2 = n3;
        }
        vector2.setSize(n2 + 1);
        for (n = 0; n < vector.size(); ++n) {
            element2 = (Element)vector.get(n);
            vector2.set(Integer.parseInt(element2.getAttribute("name")), this.invokeReadFromXML(element2));
        }
        Collection collection = (Collection)Class.forName(element.getAttribute("class")).newInstance();
        collection.addAll(vector2);
        return collection;
    }

    public Element writeMap(Element element, Object object, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        Map map = (Map)object;
        Iterator iterator = map.keySet().iterator();
        Element element2 = this.addElement(element, string, object.getClass().getName(), false);
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Element element3 = this.addElement(element2, VAL_MAPPING, (class$java$lang$Object == null ? XMLBasicSerialization.class$("java.lang.Object") : class$java$lang$Object).getName(), false);
            this.invokeWriteToXML(element3, k, VAL_KEY);
            this.invokeWriteToXML(element3, map.get(k), VAL_VALUE);
        }
        return element2;
    }

    public Object readMap(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute("name"));
        }
        this.m_CurrentNode = element;
        Map map = (Map)Class.forName(element.getAttribute("class")).newInstance();
        Vector vector = XMLDocument.getChildTags(element);
        for (int i = 0; i < vector.size(); ++i) {
            Element element2 = (Element)vector.get(i);
            Vector vector2 = XMLDocument.getChildTags(element2);
            Object object = null;
            Object object2 = null;
            for (int j = 0; j < vector2.size(); ++j) {
                Element element3 = (Element)vector2.get(j);
                String string = element3.getAttribute("name");
                if (string.equals(VAL_KEY)) {
                    object = this.invokeReadFromXML(element3);
                    continue;
                }
                if (string.equals(VAL_VALUE)) {
                    object2 = this.invokeReadFromXML(element3);
                    continue;
                }
                System.out.println("WARNING: '" + string + "' is not a recognized name for maps!");
            }
            map.put(object, object2);
        }
        return map;
    }

    public Element writeMatrix(Element element, Object object, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        weka.core.matrix.Matrix matrix = (weka.core.matrix.Matrix)object;
        Element element2 = this.addElement(element, string, object.getClass().getName(), false);
        this.invokeWriteToXML(element2, matrix.getArray(), VAL_CELLS);
        return element2;
    }

    public Object readMatrix(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute("name"));
        }
        this.m_CurrentNode = element;
        weka.core.matrix.Matrix matrix = null;
        Vector vector = XMLDocument.getChildTags(element);
        for (int i = 0; i < vector.size(); ++i) {
            Element element2 = (Element)vector.get(i);
            String string = element2.getAttribute("name");
            if (!string.equals(VAL_CELLS)) continue;
            Object object = this.invokeReadFromXML(element2);
            matrix = new weka.core.matrix.Matrix((double[][])object);
        }
        return matrix;
    }

    public Element writeMatrixOld(Element element, Object object, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        Matrix matrix = (Matrix)object;
        Element element2 = this.addElement(element, string, object.getClass().getName(), false);
        double[][] dArrayArray = new double[matrix.numRows()][];
        for (int i = 0; i < dArrayArray.length; ++i) {
            dArrayArray[i] = matrix.getRow(i);
        }
        this.invokeWriteToXML(element2, dArrayArray, VAL_CELLS);
        return element2;
    }

    public Object readMatrixOld(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute("name"));
        }
        this.m_CurrentNode = element;
        weka.core.matrix.Matrix matrix = (weka.core.matrix.Matrix)this.readMatrix(element);
        Matrix matrix2 = new Matrix(matrix.getArrayCopy());
        return matrix2;
    }

    public Element writeCostMatrixOld(Element element, Object object, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        return this.writeMatrixOld(element, object, string);
    }

    public Object readCostMatrixOld(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute("name"));
        }
        this.m_CurrentNode = element;
        weka.core.matrix.Matrix matrix = (weka.core.matrix.Matrix)this.readMatrix(element);
        StringWriter stringWriter = new StringWriter();
        matrix.write(stringWriter);
        CostMatrix costMatrix = new CostMatrix(new StringReader(stringWriter.toString()));
        return costMatrix;
    }
}

