/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils.orientation;

import edu.msu.cme.rdp.readseq.utils.orientation.LogWordPriorFileParser;
import edu.msu.cme.rdp.readseq.utils.orientation.TrainingDataException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;

public class TrainingInfo {
    private static int NUM_OF_WORDS = 65536;
    private static final int RNA_BASES = 4;
    private static int[] intComplementLookup;
    private float[] wordPairPriorDiffArr = new float[NUM_OF_WORDS];
    public static TrainingInfo theInfo;
    private static String dataFile;

    private TrainingInfo() {
        try {
            URL aurl = this.getClass().getResource(dataFile);
            InputStream inStream = this.getClass().getResourceAsStream(dataFile);
            InputStreamReader in = new InputStreamReader(inStream);
            this.createLogWordPriorArr(in);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (TrainingDataException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void setDataFile(String file) {
        dataFile = file;
    }

    public static String getDataFile() {
        return dataFile;
    }

    public static synchronized TrainingInfo getInfo() {
        if (theInfo == null) {
            if (dataFile == null) {
                throw new IllegalStateException("Must set the data file for TrainingInfo");
            }
            theInfo = new TrainingInfo();
        }
        return theInfo;
    }

    private void createLogWordPriorArr(Reader reader) throws IOException, TrainingDataException {
        LogWordPriorFileParser parser = new LogWordPriorFileParser();
        float[] logWordPriorArr = new float[NUM_OF_WORDS];
        parser.createLogWordPriorArr(reader, logWordPriorArr);
        int[] origWord = new int[8];
        this.generateWordPairDiffArr(logWordPriorArr, origWord, 0);
    }

    void generateWordPairDiffArr(float[] logWordPriorArr, int[] word, int beginIndex) {
        if (beginIndex < 0 || beginIndex > word.length) {
            return;
        }
        int origWordIndex = TrainingInfo.getWordIndex(word);
        int revWordIndex = TrainingInfo.getWordIndex(TrainingInfo.getReversedWord(word));
        float origWordPrior = logWordPriorArr[origWordIndex];
        float revWordPrior = logWordPriorArr[revWordIndex];
        this.wordPairPriorDiffArr[origWordIndex] = origWordPrior - revWordPrior;
        for (int i = beginIndex; i < word.length; ++i) {
            int origBase = word[i];
            for (int j = 0; j < 4; ++j) {
                if (word[i] == j) continue;
                word[i] = j;
                this.generateWordPairDiffArr(logWordPriorArr, word, i + 1);
                word[i] = origBase;
            }
        }
    }

    private static int getWordIndex(int[] word) {
        int wordIndex = 0;
        for (int w = 0; w < word.length; ++w) {
            wordIndex <<= 2;
            wordIndex &= 0xFFFF;
            wordIndex |= word[w];
        }
        return wordIndex;
    }

    private static int[] getReversedWord(int[] word) {
        int length = word.length;
        int[] reverseWord = new int[length];
        for (int w = 0; w < length; ++w) {
            reverseWord[length - 1 - w] = intComplementLookup[word[w]];
        }
        return reverseWord;
    }

    float getWordPairPriorDiff(int wordIndex) {
        return this.wordPairPriorDiffArr[wordIndex];
    }

    static {
        theInfo = null;
        dataFile = null;
        intComplementLookup = new int[4];
        TrainingInfo.intComplementLookup[0] = 1;
        TrainingInfo.intComplementLookup[1] = 0;
        TrainingInfo.intComplementLookup[2] = 3;
        TrainingInfo.intComplementLookup[3] = 2;
    }
}

