/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils.kmermatch;

import edu.msu.cme.rdp.readseq.readers.Sequence;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KmerMatchCore {
    public abstract ArrayList<BestMatch> findTopKMatch(Sequence var1, int var2) throws IOException;

    public static class BestMatch {
        Sequence match;
        float sab;
        boolean revComp;

        BestMatch(Sequence s, float score, boolean r) {
            this.match = s;
            this.sab = score;
            this.revComp = r;
        }

        public Sequence getBestMatch() {
            return this.match;
        }

        public boolean isRevComp() {
            return this.revComp;
        }

        public float getSab() {
            return this.sab;
        }
    }

    public static class ResultComparator
    implements Comparator {
        public int compare(Object a, Object b) {
            if (((BestMatch)a).sab < ((BestMatch)b).sab) {
                return 1;
            }
            if (((BestMatch)a).sab > ((BestMatch)b).sab) {
                return -1;
            }
            return ((BestMatch)a).match.getSeqName().compareTo(((BestMatch)b).match.getSeqName());
        }
    }
}

