/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils;

import edu.msu.cme.rdp.readseq.SequenceFormat;
import edu.msu.cme.rdp.readseq.SequenceType;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import edu.msu.cme.rdp.readseq.readers.core.EMBLCore;
import edu.msu.cme.rdp.readseq.readers.core.FastaCore;
import edu.msu.cme.rdp.readseq.readers.core.FastqCore;
import edu.msu.cme.rdp.readseq.readers.core.GenbankCore;
import edu.msu.cme.rdp.readseq.readers.core.SFFCore;
import edu.msu.cme.rdp.readseq.readers.core.STKCore;
import edu.msu.cme.rdp.readseq.readers.core.SeqReaderCore;
import edu.msu.cme.rdp.readseq.utils.SequenceStats;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeqUtils {
    private static final List<Character> gapChars = Arrays.asList(Character.valueOf('.'), Character.valueOf('-'), Character.valueOf('~'));
    public static final int SFF_MAGIC_NUMBER = 779314790;
    public static final int SRF_MAGIC_NUMBER = 1397969478;
    public static final int STK_MAGIC_NUMBER = 589321044;
    public static final int GENBANK_MAGIC_NUMBER = 1280262997;
    public static final int EMBL_MAGIC_NUMBER = 1229201440;
    public static final Set<Character> RNAAlphabet = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(Character.valueOf('A'), Character.valueOf('a'), Character.valueOf('C'), Character.valueOf('c'), Character.valueOf('G'), Character.valueOf('g'), Character.valueOf('U'), Character.valueOf('u'), Character.valueOf('T'), Character.valueOf('t'), Character.valueOf('M'), Character.valueOf('m'), Character.valueOf('R'), Character.valueOf('r'), Character.valueOf('W'), Character.valueOf('w'), Character.valueOf('S'), Character.valueOf('s'), Character.valueOf('Y'), Character.valueOf('y'), Character.valueOf('K'), Character.valueOf('k'), Character.valueOf('B'), Character.valueOf('b'), Character.valueOf('H'), Character.valueOf('h'), Character.valueOf('V'), Character.valueOf('v'), Character.valueOf('D'), Character.valueOf('d'), Character.valueOf('N'), Character.valueOf('n'), Character.valueOf('I'), Character.valueOf('i'))));
    public static final Set<Character> proteinAlphabet = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(Character.valueOf('A'), Character.valueOf('a'), Character.valueOf('C'), Character.valueOf('c'), Character.valueOf('D'), Character.valueOf('d'), Character.valueOf('E'), Character.valueOf('e'), Character.valueOf('F'), Character.valueOf('f'), Character.valueOf('G'), Character.valueOf('g'), Character.valueOf('H'), Character.valueOf('h'), Character.valueOf('I'), Character.valueOf('i'), Character.valueOf('K'), Character.valueOf('k'), Character.valueOf('L'), Character.valueOf('l'), Character.valueOf('M'), Character.valueOf('m'), Character.valueOf('N'), Character.valueOf('n'), Character.valueOf('P'), Character.valueOf('p'), Character.valueOf('Q'), Character.valueOf('q'), Character.valueOf('R'), Character.valueOf('r'), Character.valueOf('S'), Character.valueOf('s'), Character.valueOf('T'), Character.valueOf('t'), Character.valueOf('V'), Character.valueOf('v'), Character.valueOf('W'), Character.valueOf('w'), Character.valueOf('Y'), Character.valueOf('y'), Character.valueOf('Z'), Character.valueOf('z'), Character.valueOf('B'), Character.valueOf('b'), Character.valueOf('X'), Character.valueOf('x'), Character.valueOf('u'), Character.valueOf('U'), Character.valueOf('j'), Character.valueOf('J'), Character.valueOf('*'))));
    public static final Set<Character> rrnaAmbiguity = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(Character.valueOf('y'), Character.valueOf('Y'), Character.valueOf('r'), Character.valueOf('R'), Character.valueOf('w'), Character.valueOf('W'), Character.valueOf('s'), Character.valueOf('S'), Character.valueOf('k'), Character.valueOf('K'), Character.valueOf('m'), Character.valueOf('M'), Character.valueOf('d'), Character.valueOf('D'), Character.valueOf('v'), Character.valueOf('V'), Character.valueOf('h'), Character.valueOf('H'), Character.valueOf('b'), Character.valueOf('B'), Character.valueOf('x'), Character.valueOf('X'), Character.valueOf('n'), Character.valueOf('N'))));
    public static final Set<Character> proteinAmbiguity = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(Character.valueOf('x'), Character.valueOf('X'), Character.valueOf('*'))));
    public static final byte[] IUPAC = new byte[127];
    public static final byte NON_COMPAREABLE = Byte.parseByte("01100000", 2);
    public static final byte A = Byte.parseByte("00000001", 2);
    public static final byte C = Byte.parseByte("00000010", 2);
    public static final byte G = Byte.parseByte("00000100", 2);
    public static final byte U = Byte.parseByte("00001000", 2);
    public static final byte AMB = Byte.parseByte("00100000", 2);
    public static final byte GAP = Byte.parseByte("01000000", 2);
    public static final byte Y = (byte)(C | U | AMB);
    public static final byte R = (byte)(A | G | AMB);
    public static final byte W = (byte)(A | U | AMB);
    public static final byte S = (byte)(G | C | AMB);
    public static final byte K = (byte)(G | U | AMB);
    public static final byte M = (byte)(A | C | AMB);
    public static final byte D = (byte)(A | G | U | AMB);
    public static final byte V = (byte)(A | G | C | AMB);
    public static final byte H = (byte)(A | C | U | AMB);
    public static final byte B = (byte)(G | C | U | AMB);
    public static final byte N = (byte)(A | C | G | U | AMB);

    public static byte[] toBytes(String seq) {
        byte[] seqBytes = new byte[seq.length()];
        for (int col = 0; col < seq.length(); ++col) {
            seqBytes[col] = IUPAC[seq.charAt(col)];
        }
        return seqBytes;
    }

    public static String fromBytes(byte[] bases) {
        StringBuilder ret = new StringBuilder();
        for (byte base : bases) {
            if (base == A) {
                ret.append('A');
                continue;
            }
            if (base == C) {
                ret.append('C');
                continue;
            }
            if (base == G) {
                ret.append('G');
                continue;
            }
            if (base == U) {
                ret.append('T');
                continue;
            }
            if (base == GAP) {
                ret.append('-');
                continue;
            }
            if (base == Y) {
                ret.append('Y');
                continue;
            }
            if (base == R) {
                ret.append('R');
                continue;
            }
            if (base == W) {
                ret.append('W');
                continue;
            }
            if (base == S) {
                ret.append('S');
                continue;
            }
            if (base == K) {
                ret.append('K');
                continue;
            }
            if (base == M) {
                ret.append('M');
                continue;
            }
            if (base == D) {
                ret.append('D');
                continue;
            }
            if (base == V) {
                ret.append('V');
                continue;
            }
            if (base == H) {
                ret.append('H');
                continue;
            }
            if (base == B) {
                ret.append('B');
                continue;
            }
            if (base == N) {
                ret.append('N');
                continue;
            }
            ret.append('?');
        }
        return ret.toString();
    }

    public static Sequence getMaskedSeq(Sequence seq, char[] maskSeq) {
        return new Sequence(seq.getSeqName(), seq.getDesc(), SeqUtils.getMaskedSeq(seq.getSeqString(), maskSeq));
    }

    public static String getMaskedSeq(String bases, char[] maskSeq) {
        StringBuilder ret = new StringBuilder();
        if (bases.length() != maskSeq.length) {
            System.err.println("\"" + bases + "\"");
            StringBuffer b = new StringBuffer();
            for (char c : maskSeq) {
                b.append(c);
            }
            System.err.println("\"" + b + "\"");
            throw new IllegalArgumentException("Seq string[" + bases.length() + "] and mask string[" + maskSeq.length + "] are different lengths");
        }
        for (int index = 0; index < maskSeq.length; ++index) {
            if (maskSeq[index] == '0' || maskSeq[index] == '.' || maskSeq[index] == '~') continue;
            ret.append(bases.charAt(index));
        }
        return ret.toString();
    }

    public static Sequence getMaskedBySeqString(Sequence seq) {
        return new Sequence(seq.getSeqName(), seq.getDesc(), SeqUtils.getMaskedBySeqString(seq.getSeqString()));
    }

    public static String getMaskedBySeqString(String seqString) {
        StringBuilder ret = new StringBuilder();
        char[] bases = seqString.toCharArray();
        for (int index = 0; index < bases.length; ++index) {
            if (bases[index] != '-' && !Character.isUpperCase(bases[index])) continue;
            ret.append(bases[index]);
        }
        return ret.toString();
    }

    public static String filterSeqString(String seqString, boolean ignoreGaps) {
        StringBuilder ret = new StringBuilder();
        for (char b : seqString.toCharArray()) {
            if (gapChars.contains(Character.valueOf(b)) && ignoreGaps || Character.isWhitespace(b)) continue;
            ret.append(b);
        }
        return ret.toString();
    }

    public static SeqReaderCore getSeqReaderCore(File f) throws IOException {
        SeqReaderCore core;
        SequenceFormat format = SeqUtils.guessFileFormat(f);
        if (format == SequenceFormat.GZIP) {
            return SeqUtils.getSeqReaderCore(new GZIPInputStream(new FileInputStream(f)));
        }
        if (format == SequenceFormat.FASTA) {
            core = new FastaCore(f);
        } else if (format == SequenceFormat.FASTQ) {
            core = new FastqCore(f);
        } else if (format == SequenceFormat.SFF) {
            core = new SFFCore(f);
        } else if (format == SequenceFormat.STK) {
            core = new STKCore(f);
        } else if (format == SequenceFormat.EMBL) {
            core = new EMBLCore(f);
        } else if (format == SequenceFormat.GENBANK) {
            core = new GenbankCore(f);
        } else if (format == SequenceFormat.EMPTY) {
            core = new SeqReaderCore.EmptyCore(f);
        } else {
            throw new IOException("Unable to process file format " + (Object)((Object)format));
        }
        return core;
    }

    public static SeqReaderCore getSeqReaderCore(InputStream is) throws IOException {
        SeqReaderCore core;
        BufferedInputStream in = is instanceof BufferedInputStream ? (BufferedInputStream)is : new BufferedInputStream(is);
        SequenceFormat format = SeqUtils.guessSequenceFormat(in);
        if (format == SequenceFormat.GZIP) {
            return SeqUtils.getSeqReaderCore(new GZIPInputStream(is));
        }
        if (format == SequenceFormat.FASTA) {
            core = new FastaCore(in);
        } else if (format == SequenceFormat.FASTQ) {
            core = new FastqCore(in);
        } else if (format == SequenceFormat.SFF) {
            core = new SFFCore(in);
        } else if (format == SequenceFormat.EMBL) {
            core = new EMBLCore(in);
        } else if (format == SequenceFormat.GENBANK) {
            core = new GenbankCore(in);
        } else if (format == SequenceFormat.EMPTY) {
            core = new SeqReaderCore.EmptyCore(in);
        } else {
            throw new IOException("Unable to process file format " + (Object)((Object)format));
        }
        return core;
    }

    public static SequenceFormat guessFileFormat(File f) throws IOException {
        if (!f.exists()) {
            throw new FileNotFoundException(f.getPath());
        }
        if (f.length() == 0L) {
            return SequenceFormat.EMPTY;
        }
        FileInputStream is = new FileInputStream(f);
        SequenceFormat format = SeqUtils.guessSequenceFormat(new BufferedInputStream(is));
        ((InputStream)is).close();
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SequenceFormat guessSequenceFormat(InputStream in) throws IOException {
        if (!in.markSupported()) {
            throw new IOException("Cannot test sequence format of an input stream that doesn't support marking");
        }
        DataInputStream is = new DataInputStream(in);
        is.mark(4);
        try {
            int magicNumber = is.readInt();
            switch (magicNumber) {
                case 779314790: {
                    SequenceFormat sequenceFormat = SequenceFormat.SFF;
                    return sequenceFormat;
                }
                case 1397969478: {
                    SequenceFormat sequenceFormat = SequenceFormat.SFF;
                    return sequenceFormat;
                }
                case 589321044: {
                    SequenceFormat sequenceFormat = SequenceFormat.STK;
                    return sequenceFormat;
                }
                case 1280262997: {
                    SequenceFormat sequenceFormat = SequenceFormat.GENBANK;
                    return sequenceFormat;
                }
                case 1229201440: {
                    SequenceFormat sequenceFormat = SequenceFormat.EMBL;
                    return sequenceFormat;
                }
            }
            if (((magicNumber >>= 16) >> 8 | (magicNumber & 0xFF) << 8) == 35615) {
                SequenceFormat sequenceFormat = SequenceFormat.GZIP;
                return sequenceFormat;
            }
            if ((magicNumber >>= 8) == 62) {
                SequenceFormat sequenceFormat = SequenceFormat.FASTA;
                return sequenceFormat;
            }
            if (magicNumber == 64) {
                SequenceFormat sequenceFormat = SequenceFormat.FASTQ;
                return sequenceFormat;
            }
            SequenceFormat sequenceFormat = SequenceFormat.UNKNOWN;
            return sequenceFormat;
        }
        catch (EOFException e) {
            SequenceFormat sequenceFormat = SequenceFormat.EMPTY;
            return sequenceFormat;
        }
        finally {
            is.reset();
        }
    }

    public static SequenceType guessSequenceType(File f) throws IOException {
        SequenceReader reader = new SequenceReader(f);
        Sequence seq = reader.readNextSequence();
        reader.close();
        return SeqUtils.guessSequenceType(seq);
    }

    public static SequenceType guessSequenceType(Sequence seq) {
        boolean canBeNucl = true;
        boolean canBeProt = true;
        for (char c : SeqUtils.getUnalignedSeqString(seq.getSeqString()).toCharArray()) {
            if (!RNAAlphabet.contains(Character.valueOf(c))) {
                canBeNucl = false;
            }
            if (proteinAlphabet.contains(Character.valueOf(c))) continue;
            canBeProt = false;
        }
        if (canBeNucl) {
            return SequenceType.Nucleotide;
        }
        if (canBeProt) {
            return SequenceType.Protein;
        }
        return SequenceType.Unknown;
    }

    public static int[] getSeqEndPoints(String seqString) {
        SequenceStats stats = new SequenceStats(seqString);
        return new int[]{stats.getStart(), stats.getEnd()};
    }

    public static String getUnalignedSeqString(String seqString) {
        return seqString.toLowerCase().replaceAll("[\\-\\.\\~\\s]", "");
    }

    public static Sequence getUnalignedSeq(Sequence seq) {
        return new Sequence(seq.getSeqName(), seq.getDesc(), SeqUtils.getUnalignedSeqString(seq.getSeqString()));
    }

    public static Map<Integer, Integer> generateReferenceSeqMapping(String referenceSeq) {
        HashMap<Integer, Integer> refMapping = new HashMap<Integer, Integer>();
        int modelPosition = 0;
        int refSeqPosition = 0;
        char[] bases = referenceSeq.toCharArray();
        for (int index = 0; index < bases.length; ++index) {
            char base = bases[index];
            if (Character.isLetter(base)) {
                ++refSeqPosition;
            }
            if (!Character.isUpperCase(base) && base != '-') continue;
            refMapping.put(++modelPosition, refSeqPosition);
        }
        return refMapping;
    }

    public static int countModelPositions(String seqString) {
        int count = 0;
        for (char b : seqString.toCharArray()) {
            if (!Character.isUpperCase(b) && b != '-') continue;
            ++count;
        }
        return count;
    }

    public static String translateQualString(byte[] qual) {
        StringBuilder ret = new StringBuilder();
        for (byte c : qual) {
            ret.append(c).append("  ");
        }
        return ret.toString();
    }

    public static int countSequences(List<File> seqFiles) throws IOException {
        int seqCount = 0;
        for (File file : seqFiles) {
            SequenceReader reader = null;
            try {
                Object seq;
                reader = new SequenceReader(file);
                while ((seq = reader.readNextSequence()) != null) {
                    if (((Sequence)seq).getSeqName().startsWith("#")) continue;
                    ++seqCount;
                }
            }
            catch (IOException e) {
                throw new IOException("Invalid sequence found in file " + file.getName());
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
        return seqCount;
    }

    public static void main(String[] args) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(">   ".getBytes()));
        int fasta = dis.readInt();
        System.out.println((Object)SeqUtils.guessFileFormat(new File("test/test.fa.gz")));
        System.out.println(fasta >> 24);
        System.out.println(62);
        dis = new DataInputStream(new ByteArrayInputStream("@   ".getBytes()));
        int fastq = dis.readInt();
        System.out.println(fastq >> 24);
        System.out.println(64);
        dis = new DataInputStream(new ByteArrayInputStream(">".getBytes()));
        System.out.println(dis.read());
    }

    static {
        for (int i = 0; i < IUPAC.length; ++i) {
            SeqUtils.IUPAC[i] = -1;
        }
        SeqUtils.IUPAC[65] = SeqUtils.IUPAC[97] = A;
        SeqUtils.IUPAC[67] = SeqUtils.IUPAC[99] = C;
        SeqUtils.IUPAC[71] = SeqUtils.IUPAC[103] = G;
        SeqUtils.IUPAC[84] = SeqUtils.IUPAC[116] = U;
        SeqUtils.IUPAC[117] = SeqUtils.IUPAC[116];
        SeqUtils.IUPAC[85] = SeqUtils.IUPAC[116];
        SeqUtils.IUPAC[77] = M;
        SeqUtils.IUPAC[82] = R;
        SeqUtils.IUPAC[87] = W;
        SeqUtils.IUPAC[83] = S;
        SeqUtils.IUPAC[89] = Y;
        SeqUtils.IUPAC[75] = K;
        SeqUtils.IUPAC[86] = V;
        SeqUtils.IUPAC[72] = H;
        SeqUtils.IUPAC[68] = D;
        SeqUtils.IUPAC[66] = B;
        SeqUtils.IUPAC[45] = GAP;
        SeqUtils.IUPAC[46] = GAP;
        SeqUtils.IUPAC[126] = GAP;
        SeqUtils.IUPAC[78] = N;
        SeqUtils.IUPAC[88] = N;
        SeqUtils.IUPAC[109] = IUPAC[77];
        SeqUtils.IUPAC[114] = IUPAC[82];
        SeqUtils.IUPAC[119] = IUPAC[87];
        SeqUtils.IUPAC[115] = IUPAC[83];
        SeqUtils.IUPAC[121] = IUPAC[89];
        SeqUtils.IUPAC[107] = IUPAC[75];
        SeqUtils.IUPAC[118] = IUPAC[86];
        SeqUtils.IUPAC[104] = IUPAC[72];
        SeqUtils.IUPAC[100] = IUPAC[68];
        SeqUtils.IUPAC[98] = IUPAC[66];
        SeqUtils.IUPAC[110] = IUPAC[78];
        SeqUtils.IUPAC[120] = IUPAC[88];
    }
}

