/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.utils;

import edu.msu.cme.rdp.classifier.Classifier;
import edu.msu.cme.rdp.classifier.HierarchyTree;
import edu.msu.cme.rdp.classifier.TrainingDataException;
import edu.msu.cme.rdp.classifier.TrainingInfo;
import edu.msu.cme.rdp.classifier.utils.HierarchyVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;

public class ClassifierFactory {
    public static final String RRNA_16S_GENE = "16srrna";
    public static final String FUNGALLSU_GENE = "fungallsu";
    public static final String FUNGALITS_warcup_GENE = "fungalits_warcup";
    public static final String FUNGALITS_unite_GENE = "fungalits_unite";
    private TrainingInfo trainingInfo;
    private static Properties urlProperties;
    private static String classifierVersion;
    private static final String dataDir = "/data/classifier/";
    private static final String defaultDataProp = "rRNAClassifier.properties";
    private static String parentPath;
    private static String dataProp;
    private static HashMap<String, ClassifierFactory> classifierFactoryMap;
    private static boolean relativePath;

    private ClassifierFactory(String gene) throws IOException, TrainingDataException {
        if (urlProperties == null) {
            InputStream inStream = null;
            if (relativePath) {
                String gene_dataProp = dataDir + gene + "/" + defaultDataProp;
                URL aurl = this.getClass().getResource(gene_dataProp);
                inStream = this.getClass().getResourceAsStream(gene_dataProp);
                parentPath = new File(aurl.getFile()).getParent();
            } else {
                File aFile = new File(dataProp);
                String absolutePath = aFile.getAbsolutePath();
                parentPath = absolutePath.substring(0, absolutePath.lastIndexOf(File.separatorChar));
                inStream = new FileInputStream(aFile);
            }
            urlProperties = new Properties();
            urlProperties.load(inStream);
            inStream.close();
        }
    }

    public static void resetDefaultDataProp() {
        dataProp = defaultDataProp;
        urlProperties = null;
        classifierFactoryMap = new HashMap();
        relativePath = true;
    }

    public static void setDataProp(String properties, boolean relative) {
        dataProp = properties.trim();
        urlProperties = null;
        classifierFactoryMap = new HashMap();
        relativePath = relative;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ClassifierFactory getFactory(String gene) throws IOException, TrainingDataException {
        if (!classifierFactoryMap.containsKey(gene)) {
            if (relativePath) {
                ClassifierFactory factory = new ClassifierFactory(gene);
                factory.trainingInfo = new TrainingInfo();
                InputStreamReader in = new InputStreamReader(ClassifierFactory.class.getResourceAsStream(dataDir + gene + "/" + ClassifierFactory.convert("probabilityList")));
                try {
                    factory.trainingInfo.createGenusWordProbList(in);
                }
                finally {
                    in.close();
                }
                in = new InputStreamReader(ClassifierFactory.class.getResourceAsStream(dataDir + gene + "/" + ClassifierFactory.convert("bergeyTree")));
                try {
                    factory.trainingInfo.createTree(in);
                }
                finally {
                    in.close();
                }
                in = new InputStreamReader(ClassifierFactory.class.getResourceAsStream(dataDir + gene + "/" + ClassifierFactory.convert("probabilityIndex")));
                try {
                    factory.trainingInfo.createProbIndexArr(in);
                }
                finally {
                    in.close();
                }
                in = new InputStreamReader(ClassifierFactory.class.getResourceAsStream(dataDir + gene + "/" + ClassifierFactory.convert("wordPrior")));
                try {
                    factory.trainingInfo.createLogWordPriorArr(in);
                }
                finally {
                    in.close();
                }
                classifierVersion = ClassifierFactory.convert("classifierVersion");
                classifierFactoryMap.put(gene, factory);
                classifierFactoryMap.put(Integer.toString(factory.getHierarchyTrainsetNo().getTrainsetNo()), factory);
            } else {
                ClassifierFactory.getNonDefaultFactory(gene);
            }
        }
        return classifierFactoryMap.get(gene);
    }

    private static ClassifierFactory getNonDefaultFactory(String gene) throws IOException, TrainingDataException {
        if (classifierFactoryMap.get(gene) == null) {
            ClassifierFactory factory = new ClassifierFactory(gene);
            factory.trainingInfo = new TrainingInfo();
            String filename = parentPath + File.separatorChar + ClassifierFactory.convert("probabilityList");
            FileReader in = new FileReader(filename);
            factory.trainingInfo.createGenusWordProbList(in);
            filename = parentPath + File.separatorChar + ClassifierFactory.convert("bergeyTree");
            in = new FileReader(filename);
            factory.trainingInfo.createTree(in);
            filename = parentPath + File.separatorChar + ClassifierFactory.convert("probabilityIndex");
            in = new FileReader(filename);
            factory.trainingInfo.createProbIndexArr(in);
            filename = parentPath + File.separatorChar + ClassifierFactory.convert("wordPrior");
            in = new FileReader(filename);
            factory.trainingInfo.createLogWordPriorArr(in);
            classifierVersion = ClassifierFactory.convert("classifierVersion");
            classifierFactoryMap.put(gene, factory);
            classifierFactoryMap.put(Integer.toString(factory.getHierarchyTrainsetNo().getTrainsetNo()), factory);
        }
        return classifierFactoryMap.get(gene);
    }

    private static String convert(String key) throws IOException {
        String filename = urlProperties.getProperty(key);
        if (filename == null) {
            throw new IOException("Returns 'null' while retrieving " + key + " from the Properties, Please check your key'.");
        }
        return filename;
    }

    public Classifier createClassifier() {
        return this.trainingInfo.createClassifier();
    }

    public String getHierarchyVersion() {
        return this.trainingInfo.getHierarchyVersion();
    }

    public HierarchyVersion getHierarchyTrainsetNo() {
        return this.trainingInfo.getHierarchyInfo();
    }

    public String getClassifierVersion() {
        return classifierVersion;
    }

    public HierarchyTree getRoot() {
        return this.trainingInfo.getRootTree();
    }

    static {
        dataProp = "/data/classifier/16srrna/rRNAClassifier.properties";
        classifierFactoryMap = new HashMap();
        relativePath = true;
    }
}

