/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.xml;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.biojava.utils.xml.AppException;
import org.biojava.utils.xml.Initializable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLBeans {
    public static final XMLBeans INSTANCE = new XMLBeans();

    protected XMLBeans() {
    }

    private void configureBean(Object object, Element element, Map map) throws AppException {
        Class<?> clazz = object.getClass();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                String string;
                Object object2;
                Element element2 = (Element)node;
                String string2 = element2.getTagName();
                if (string2.equals("string")) {
                    object2 = element2.getAttribute("name");
                    string = element2.getAttribute("value");
                    this.setProp(clazz, object, (String)object2, string, string.getClass());
                } else if (string2.equals("bean")) {
                    object2 = element2.getAttribute("name");
                    string = element2.getAttribute("ref");
                    Object object3 = null;
                    object3 = !string.equals("") ? (Object)map.get(string) : this.instantiateBean(element2);
                    this.setProp(clazz, object, (String)object2, object3, object3.getClass());
                } else if (string2.equals("int")) {
                    object2 = element2.getAttribute("name");
                    string = element2.getAttribute("value");
                    try {
                        int n = Integer.parseInt(string);
                        this.setProp(clazz, object, (String)object2, new Integer(n), Integer.TYPE);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new AppException("Invalid int: " + string);
                    }
                } else if (string2.equals("double")) {
                    object2 = element2.getAttribute("name");
                    string = element2.getAttribute("value");
                    try {
                        double d = Double.parseDouble(string);
                        this.setProp(clazz, object, (String)object2, new Double(d), Double.TYPE);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new AppException("Invalid double: " + string);
                    }
                } else if (string2.equals("boolean")) {
                    object2 = element2.getAttribute("name");
                    string = element2.getAttribute("value");
                    Boolean bl = Boolean.valueOf(string);
                    this.setProp(clazz, object, (String)object2, bl, Boolean.TYPE);
                } else if (string2.equals("child")) {
                    if (!(object instanceof Collection)) {
                        throw new AppException("Only Collections can have children");
                    }
                    object2 = this.instantiateBean(element2);
                    ((Collection)object).add(object2);
                }
            }
            node = node.getNextSibling();
        }
    }

    public Object instantiateBean(Element element) throws AppException {
        return this.instantiateBean(element, ClassLoader.getSystemClassLoader(), new HashMap());
    }

    public Object instantiateBean(Element element, ClassLoader classLoader, Map map) throws AppException {
        String string = element.getAttribute("jclass");
        if (string == null) {
            throw new AppException("No jclass attribute");
        }
        Object var5_5 = null;
        try {
            Class<?> clazz = classLoader.loadClass(string);
            var5_5 = clazz.newInstance();
            this.configureBean(var5_5, element, map);
            if (var5_5 instanceof Initializable) {
                ((Initializable)var5_5).init();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AppException("Couldn't load bean class " + string);
        }
        catch (ClassCastException classCastException) {
            throw new AppException("Does not implement AppBean: " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new AppException("Couldn't intantiate bean " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AppException("Couldn't access constructor for bean " + string);
        }
        return var5_5;
    }

    private void setProp(Class clazz, Object object, String string, Object object2, Class clazz2) throws AppException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            throw new AppException("Couldn't introspect class " + object.getClass().getName());
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            if (propertyDescriptorArray[n].getName().equals(string)) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n];
                if (!propertyDescriptor.getPropertyType().isAssignableFrom(clazz2)) {
                    throw new AppException("Property " + string + " is not assignable from " + clazz2.getName());
                }
                Object[] objectArray = new Object[]{object2};
                try {
                    propertyDescriptor.getWriteMethod().invoke(object, objectArray);
                }
                catch (Exception exception) {
                    throw new AppException("Invocation failed");
                }
                return;
            }
            ++n;
        }
        throw new AppException("Couldn't find property " + string + " in class " + clazz.getName());
    }
}

