/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.NestedError;

public class ChangeForwarder
implements ChangeListener {
    private final Object source;
    private final transient ChangeSupport changeSupport;

    public ChangeForwarder(Object object, ChangeSupport changeSupport) {
        this.source = object;
        this.changeSupport = changeSupport;
    }

    public ChangeSupport changeSupport() {
        return this.changeSupport;
    }

    protected ChangeEvent generateEvent(ChangeEvent changeEvent) throws ChangeVetoException {
        return new ChangeEvent(this.getSource(), changeEvent.getType(), null, null, changeEvent);
    }

    public Object getSource() {
        return this.source;
    }

    public void postChange(ChangeEvent changeEvent) {
        try {
            ChangeEvent changeEvent2 = this.generateEvent(changeEvent);
            if (changeEvent2 != null) {
                this.changeSupport.firePostChangeEvent(changeEvent2);
            }
        }
        catch (ChangeVetoException changeVetoException) {
            throw new NestedError(changeVetoException, "Assertion Failure: Change was vetoed after it had been accepted by preChange");
        }
    }

    public void preChange(ChangeEvent changeEvent) throws ChangeVetoException {
        ChangeEvent changeEvent2 = this.generateEvent(changeEvent);
        if (changeEvent2 != null) {
            this.changeSupport.firePreChangeEvent(changeEvent2);
        }
    }
}

