/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bridge.Biocorba.Seqcore;

import java.util.NoSuchElementException;
import org.Biocorba.Seqcore.EndOfStream;
import org.Biocorba.Seqcore.PrimarySeq;
import org.Biocorba.Seqcore.PrimarySeqIterator;
import org.Biocorba.Seqcore.UnableToProcess;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bridge.Biocorba.Seqcore.SequenceAdapter;

public class SequenceIteratorAdapter
implements SequenceIterator {
    private PrimarySeqIterator primarySeqIterator;

    public SequenceIteratorAdapter(PrimarySeqIterator primarySeqIterator) {
        this.primarySeqIterator = primarySeqIterator;
    }

    public PrimarySeqIterator getPrimarySeqIterator() {
        return this.primarySeqIterator;
    }

    public boolean hasNext() {
        return this.getPrimarySeqIterator().has_more();
    }

    public Sequence nextSequence() throws NoSuchElementException, BioException {
        try {
            PrimarySeq primarySeq = this.getPrimarySeqIterator().next();
            SequenceAdapter sequenceAdapter = new SequenceAdapter(primarySeq);
            return sequenceAdapter;
        }
        catch (EndOfStream endOfStream) {
            throw new NoSuchElementException(((Throwable)((Object)endOfStream)).getMessage());
        }
        catch (UnableToProcess unableToProcess) {
            throw new BioException((Throwable)((Object)unableToProcess), "Could not create SequenceAdapter for CORBA sequence");
        }
        catch (IllegalAlphabetException illegalAlphabetException) {
            throw new BioException(illegalAlphabetException, "Could not create SequenceAdapter for CORBA sequence");
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioException(illegalSymbolException, "Could not create SequenceAdapter for CORBA sequence");
        }
    }
}

