/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.io.NameParser;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.AbstractAlphabet;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.SingletonList;

public class AllTokensAlphabet
extends AbstractAlphabet
implements Serializable {
    private Map tokenToSymbol;
    private Map nameToSymbol;
    private Set symbols;
    private String name;
    private Annotation annotation;

    public AllTokensAlphabet(String string) {
        this.name = string;
        this.symbols = new HashSet();
        this.tokenToSymbol = new HashMap();
        this.nameToSymbol = new HashMap();
    }

    protected void addSymbolImpl(AtomicSymbol atomicSymbol) {
        this.symbols.add(atomicSymbol);
        Character c = new Character(atomicSymbol.getToken());
        if (!this.tokenToSymbol.keySet().contains(c)) {
            this.tokenToSymbol.put(c, atomicSymbol);
        }
        this.nameToSymbol.put(atomicSymbol.getName(), atomicSymbol);
    }

    protected boolean containsImpl(AtomicSymbol atomicSymbol) {
        return this.symbols.contains(atomicSymbol);
    }

    public List getAlphabets() {
        return new SingletonList(this);
    }

    public Annotation getAnnotation() {
        if (this.annotation == null) {
            this.annotation = new SimpleAnnotation();
        }
        return this.annotation;
    }

    public String getName() {
        return this.name;
    }

    public SymbolParser getParser(String string) throws NoSuchElementException {
        if (string.equals("name")) {
            return new NameParser(this.nameToSymbol){

                public Symbol parseToken(String string) throws IllegalSymbolException {
                    Symbol symbol = (Symbol)AllTokensAlphabet.this.nameToSymbol.get(string);
                    if (symbol == null) {
                        symbol = AlphabetManager.createSymbol(string.charAt(0), string, null);
                        try {
                            AllTokensAlphabet.this.addSymbol(symbol);
                        }
                        catch (ChangeVetoException changeVetoException) {
                            throw new IllegalSymbolException(changeVetoException, "Couldn't parse '" + string + "'");
                        }
                    }
                    return symbol;
                }
            };
        }
        if (string.equals("token")) {
            return new SymbolParser(){

                public Alphabet getAlphabet() {
                    return AllTokensAlphabet.this;
                }

                public SymbolList parse(String string) throws IllegalSymbolException {
                    ArrayList<Symbol> arrayList = new ArrayList<Symbol>(string.length());
                    int n = 0;
                    while (n < string.length()) {
                        arrayList.add(this.parseToken(string.substring(n, n + 1)));
                        ++n;
                    }
                    try {
                        return new SimpleSymbolList(this.getAlphabet(), arrayList);
                    }
                    catch (IllegalSymbolException illegalSymbolException) {
                        throw new BioError(illegalSymbolException);
                    }
                }

                public StreamParser parseStream(SeqIOListener seqIOListener) {
                    SeqIOListener seqIOListener2 = seqIOListener;
                    return new StreamParser(seqIOListener2, AllTokensAlphabet.this, this){
                        private final /* synthetic */ AllTokensAlphabet this$0;
                        private final /* synthetic */ SeqIOListener val$listener;
                        private final /* synthetic */ 2 this$1;
                        {
                            this.val$listener = seqIOListener;
                            this.this$0 = allTokensAlphabet;
                            this.this$1 = var3_3;
                        }

                        public void characters(char[] cArray, int n, int n2) throws IllegalSymbolException {
                            Symbol[] symbolArray = new Symbol[n2];
                            int n3 = 0;
                            while (n3 < n2) {
                                symbolArray[n3] = this.this$1.parseToken(String.valueOf(cArray[n + n3]));
                                ++n3;
                            }
                            try {
                                this.val$listener.addSymbols(this.this$0, symbolArray, 0, n2);
                            }
                            catch (IllegalAlphabetException illegalAlphabetException) {
                                throw new BioError(illegalAlphabetException);
                            }
                        }

                        public void close() {
                        }
                    };
                }

                public Symbol parseToken(String string) throws IllegalSymbolException {
                    char c = string.charAt(0);
                    Character c2 = new Character(c);
                    Symbol symbol = (Symbol)AllTokensAlphabet.this.tokenToSymbol.get(c2);
                    if (symbol == null) {
                        symbol = AlphabetManager.createSymbol(c, string, null);
                        try {
                            AllTokensAlphabet.this.addSymbol(symbol);
                        }
                        catch (ChangeVetoException changeVetoException) {
                            throw new IllegalSymbolException(changeVetoException, "Can't add symbol '" + string + "'");
                        }
                    }
                    return symbol;
                }
            };
        }
        throw new NoSuchElementException("No parser for " + string + " known in alphabet " + this.getName());
    }

    protected AtomicSymbol getSymbolImpl(List list) throws IllegalSymbolException {
        return (AtomicSymbol)list.get(0);
    }

    public Iterator iterator() {
        return this.symbols.iterator();
    }

    public void removeSymbol(Symbol symbol) throws IllegalSymbolException {
        throw new IllegalSymbolException("Can't remove symbols from alphabet: " + symbol.getName() + " in " + this.getName());
    }

    public int size() {
        return this.symbols.size();
    }

    public SymbolList symbols() {
        try {
            return new SimpleSymbolList(this, new ArrayList(this.symbols));
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException);
        }
    }
}

